/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.MultiPointConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.MultiPointCoordSet;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public abstract class MultiPointForm
implements ShapeForm {
    private final String name_;
    private final Icon icon_;
    private final String description_;
    private final MultiPointCoordSet extraCoordSet_;
    private final MultiPointConfigKey rendererKey_;
    private final ConfigKey[] otherKeys_;

    public MultiPointForm(String name, Icon icon, String description, MultiPointCoordSet extraCoordSet, MultiPointConfigKey rendererKey, ConfigKey[] otherKeys) {
        this.name_ = name;
        this.icon_ = icon;
        this.description_ = description;
        this.extraCoordSet_ = extraCoordSet;
        this.rendererKey_ = rendererKey;
        this.otherKeys_ = otherKeys;
    }

    protected abstract double getScaleFactor(ConfigMap var1);

    protected abstract boolean isAutoscale(ConfigMap var1);

    @Override
    public int getPositionCount() {
        return 1;
    }

    @Override
    public String getFormName() {
        return this.name_;
    }

    @Override
    public Icon getFormIcon() {
        return this.icon_;
    }

    @Override
    public String getFormDescription() {
        return this.description_;
    }

    @Override
    public Coord[] getExtraCoords() {
        return this.extraCoordSet_.getCoords();
    }

    @Override
    public ConfigKey[] getConfigKeys() {
        ArrayList<ConfigKey> list = new ArrayList<ConfigKey>();
        list.add(this.rendererKey_);
        list.addAll(Arrays.asList(this.otherKeys_));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        ErrorRenderer renderer = config.get(this.rendererKey_);
        ErrorMode[] errorModes = this.rendererKey_.getErrorModes();
        double scale = this.getScaleFactor(config);
        boolean isAutoscale = this.isAutoscale(config);
        return new MultiPointOutliner(renderer, errorModes, scale, isAutoscale);
    }

    public static MultiPointForm createVectorForm(String name, MultiPointCoordSet extraCoordSet, boolean canScale) {
        String descrip = PlotUtil.concatLines(new String[]{"<p>Plots directed lines from the data position", "given delta values for the coordinates.", "The plotted markers are typically little arrows,", "but there are other options.", "</p>"});
        if (canScale) {
            descrip = descrip + MultiPointForm.getDefaultScalingDescription("vector");
        }
        return MultiPointForm.createDefaultForm(name, ResourceIcon.FORM_VECTOR, descrip, extraCoordSet, StyleKeys.VECTOR_SHAPE, canScale);
    }

    public static String getDefaultScalingDescription(String shapename) {
        return PlotUtil.concatLines(new String[]{"<p>In some cases the supplied data values", "give the actual extents in data coordinates", "for the plotted " + shapename + "s", "but sometimes the data is on a different scale", "or in different units to the positional coordinates.", "As a convenience for this case, the plotter can optionally", "scale the magnitudes of all the " + shapename + "s", "to make them a reasonable size on the plot,", "so by default the largest ones are a few tens of pixels long.", "This auto-scaling is turned off by default,", "but it can be activated with the", "<code>" + StyleKeys.AUTOSCALE.getMeta().getShortName() + "</code>", "option.", "Whether autoscaling is on or off, the", "<code>" + StyleKeys.SCALE.getMeta().getShortName() + "</code>", "option can be used to apply a fixed scaling factor.", "</p>"});
    }

    public static MultiPointForm createErrorForm(String name, MultiPointCoordSet extraCoordSet, MultiPointConfigKey rendererKey) {
        String descrip = PlotUtil.concatLines(new String[]{"<p>Plots symmetric or asymmetric error bars in some or", "all of the plot dimensions.", "The shape of the error \"bars\" is quite configurable,", "including (for 2-d and 3-d errors)", "ellipses, rectangles etc aligned with the axes.", "</p>"});
        return MultiPointForm.createDefaultForm(name, ResourceIcon.FORM_ERROR, descrip, extraCoordSet, rendererKey, false);
    }

    public static MultiPointForm createDefaultForm(String name, Icon icon, String description, MultiPointCoordSet extraCoordSet, MultiPointConfigKey rendererKey, boolean canScale) {
        if (canScale) {
            return new MultiPointForm(name, icon, description, extraCoordSet, rendererKey, new ConfigKey[]{StyleKeys.SCALE, StyleKeys.AUTOSCALE}){

                @Override
                protected double getScaleFactor(ConfigMap config) {
                    return config.get(StyleKeys.SCALE);
                }

                @Override
                protected boolean isAutoscale(ConfigMap config) {
                    return config.get(StyleKeys.AUTOSCALE);
                }
            };
        }
        return new MultiPointForm(name, icon, description, extraCoordSet, rendererKey, new ConfigKey[0]){

            @Override
            protected double getScaleFactor(ConfigMap config) {
                return 1.0;
            }

            @Override
            protected boolean isAutoscale(ConfigMap config) {
                return false;
            }
        };
    }

    private static int getExtrasCoordIndex(DataGeom geom) {
        return geom.getPosCoords().length;
    }

    private static class SizeScale
    extends AuxScale {
        private final MultiPointOutliner outliner_;
        private final boolean scaleFromVisible_;

        SizeScale(MultiPointOutliner outliner) {
            super("autosize");
            this.outliner_ = outliner;
            this.scaleFromVisible_ = true;
        }

        AuxReader createAuxReader(final DataGeom geom, final MultiPointCoordSet extraCoordSet) {
            final int ndim = geom.getDataDimCount();
            final int nextra = extraCoordSet.getPointCount();
            final int icExtra = MultiPointForm.getExtrasCoordIndex(geom);
            return new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return -1;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Range range) {
                    double[] dpos0 = new double[ndim];
                    double[][] dposExtras = new double[nextra][ndim];
                    Point2D.Double gpos0 = new Point2D.Double();
                    Point2D.Double gpos1 = new Point2D.Double();
                    TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
                    while (tseq.next()) {
                        if (!geom.readDataPos(tseq, 0, dpos0) || !surface.dataToGraphics(dpos0, SizeScale.this.scaleFromVisible_, gpos0) || !PlotUtil.isPointFinite(gpos0) || !extraCoordSet.readPoints(tseq, icExtra, geom, dpos0, dposExtras)) continue;
                        for (int ie = 0; ie < nextra; ++ie) {
                            if (!surface.dataToGraphicsOffset(dpos0, gpos0, dposExtras[ie], false, gpos1) || !PlotUtil.isPointFinite(gpos1)) continue;
                            range.submit(gpos1.x - gpos0.x);
                            range.submit(gpos1.y - gpos0.y);
                        }
                    }
                }
            };
        }

        public int hashCode() {
            return this.outliner_.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof SizeScale && this.outliner_.equals(((SizeScale)other).outliner_);
        }
    }

    private static class MultiPointGlyph
    implements Glyph {
        private final ErrorRenderer renderer_;
        private final int[] xoffs_;
        private final int[] yoffs_;

        MultiPointGlyph(ErrorRenderer renderer, int[] xoffs, int[] yoffs) {
            this.renderer_ = renderer;
            this.xoffs_ = xoffs;
            this.yoffs_ = yoffs;
        }

        @Override
        public void paintGlyph(Graphics g) {
            this.renderer_.drawErrors(g, 0, 0, this.xoffs_, this.yoffs_);
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            final Pixellator pixellator = this.renderer_.getPixels(clip, 0, 0, this.xoffs_, this.yoffs_);
            pixellator.start();
            return new Pixer(){

                @Override
                public boolean next() {
                    return pixellator.next();
                }

                @Override
                public int getX() {
                    return pixellator.getX();
                }

                @Override
                public int getY() {
                    return pixellator.getY();
                }
            };
        }
    }

    private static class Offsetter {
        final Surface surface_;
        final int nextra_;
        final double scale_;
        final Point2D.Double gp_;

        Offsetter(Surface surface, int nextra, double scale) {
            this.surface_ = surface;
            this.nextra_ = nextra;
            this.scale_ = scale;
            this.gp_ = new Point2D.Double();
        }

        void calculateOffsets(double[] dpos0, Point2D.Double gpos0, double[][] dposExtras, int[] xoffs, int[] yoffs) {
            double gx0 = gpos0.x;
            double gy0 = gpos0.y;
            for (int ie = 0; ie < this.nextra_; ++ie) {
                int gy;
                int gx;
                if (this.surface_.dataToGraphicsOffset(dpos0, gpos0, dposExtras[ie], false, this.gp_) && PlotUtil.isPointReal(this.gp_)) {
                    gx = (int)Math.round((this.gp_.x - gx0) * this.scale_);
                    gy = (int)Math.round((this.gp_.y - gy0) * this.scale_);
                } else {
                    gx = 0;
                    gy = 0;
                }
                xoffs[ie] = gx;
                yoffs[ie] = gy;
            }
        }
    }

    private class MultiPointOutliner
    extends PixOutliner {
        private final ErrorRenderer renderer_;
        private final ErrorMode[] modes_;
        private final double scale_;
        private final boolean isAutoscale_;
        private final Icon icon_;

        public MultiPointOutliner(ErrorRenderer renderer, ErrorMode[] modes, double scale, boolean isAutoscale) {
            this.renderer_ = renderer;
            this.modes_ = modes;
            this.scale_ = scale;
            this.isAutoscale_ = isAutoscale;
            this.icon_ = renderer.getLegendIcon(modes, 14, 10, 1, 1);
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            if (this.isAutoscale_) {
                SizeScale scale = new SizeScale(this);
                map.put(scale, scale.createAuxReader(geom, MultiPointForm.this.extraCoordSet_));
            }
            return map;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, Map<AuxScale, Range> auxRanges, final PaperType2D paperType) {
            int ndim = surface.getDataDimCount();
            final int nextra = MultiPointForm.this.extraCoordSet_.getPointCount();
            final double[] dpos0 = new double[ndim];
            final double[][] dposExtras = new double[nextra][ndim];
            final Point2D.Double gpos0 = new Point2D.Double();
            final int icExtra = MultiPointForm.getExtrasCoordIndex(geom);
            double scale = this.scale_ * this.getBaseScale(surface, auxRanges);
            final Offsetter offsetter = this.createOffsetter(surface, scale);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos0) && surface.dataToGraphics(dpos0, true, gpos0) && MultiPointForm.this.extraCoordSet_.readPoints(tuple, icExtra, geom, dpos0, dposExtras)) {
                        int[] xoffs = new int[nextra];
                        int[] yoffs = new int[nextra];
                        offsetter.calculateOffsets(dpos0, gpos0, dposExtras, xoffs, yoffs);
                        MultiPointGlyph glyph = new MultiPointGlyph(MultiPointOutliner.this.renderer_, xoffs, yoffs);
                        paperType.placeGlyph(paper, gpos0.x, gpos0.y, glyph, color);
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, Map<AuxScale, Range> auxRanges, final PaperType3D paperType) {
            int ndim = surface.getDataDimCount();
            final int nextra = MultiPointForm.this.extraCoordSet_.getPointCount();
            final double[] dpos0 = new double[ndim];
            final double[][] dposExtras = new double[nextra][ndim];
            final Point2D.Double gpos0 = new Point2D.Double();
            final int icExtra = MultiPointForm.getExtrasCoordIndex(geom);
            final double[] zloc = new double[1];
            double scale = this.scale_ * this.getBaseScale(surface, auxRanges);
            final Offsetter offsetter = this.createOffsetter(surface, scale);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos0) && surface.dataToGraphicZ(dpos0, true, gpos0, zloc) && MultiPointForm.this.extraCoordSet_.readPoints(tuple, icExtra, geom, dpos0, dposExtras)) {
                        double dz0 = zloc[0];
                        int[] xoffs = new int[nextra];
                        int[] yoffs = new int[nextra];
                        offsetter.calculateOffsets(dpos0, gpos0, dposExtras, xoffs, yoffs);
                        MultiPointGlyph glyph = new MultiPointGlyph(MultiPointOutliner.this.renderer_, xoffs, yoffs);
                        paperType.placeGlyph(paper, gpos0.x, gpos0.y, dz0, glyph, color);
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof MultiPointOutliner) {
                MultiPointOutliner other = (MultiPointOutliner)o;
                return this.renderer_.equals(other.renderer_) && Arrays.equals(this.modes_, other.modes_) && this.isAutoscale_ == other.isAutoscale_ && this.scale_ == other.scale_;
            }
            return false;
        }

        public int hashCode() {
            int code = 3203;
            code = code * 23 + this.renderer_.hashCode();
            code = code * 23 + Arrays.hashCode(this.modes_);
            code = code * 23 + (this.isAutoscale_ ? 11 : 13);
            code = code * 23 + Float.floatToIntBits((float)this.scale_);
            return code;
        }

        private double getBaseScale(Surface surface, Map<AuxScale, Range> auxRanges) {
            if (!this.isAutoscale_) {
                return 1.0;
            }
            Range sizeRange = auxRanges.get(new SizeScale(this));
            double[] bounds = sizeRange.getFiniteBounds(false);
            double gmax = Math.max(-bounds[0], bounds[1]);
            assert (gmax >= 0.0);
            return gmax == 0.0 ? 1.0 : 32.0 / gmax;
        }

        private Offsetter createOffsetter(Surface surface, double scale) {
            int nextra = MultiPointForm.this.extraCoordSet_.getPointCount();
            return new Offsetter(surface, nextra, scale);
        }
    }
}

