/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;

public abstract class MultiPosIcon
implements Icon {
    private final int size_;
    private final Point[] positions_;

    public MultiPosIcon(int npos) {
        this.size_ = 16;
        int size2 = this.size_ / 2;
        this.positions_ = new Point[npos];
        this.positions_[0] = new Point(size2, size2);
        for (int ip = 1; ip < npos; ++ip) {
            double theta = 1.5707963267948966 * (double)ip / (double)npos;
            int x = (int)((double)size2 + (double)size2 * Math.cos(theta));
            int y = (int)((double)size2 - (double)size2 * Math.sin(theta));
            this.positions_[ip] = new Point(x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size_;
    }

    @Override
    public int getIconHeight() {
        return this.size_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(x, y);
        this.paintPositions(g, this.positions_);
        g.translate(-x, -y);
    }

    protected abstract void paintPositions(Graphics var1, Point[] var2);
}

