/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public abstract class Normalisation {
    private final String name_;
    private final String description_;
    public static final Normalisation NONE = new Normalisation("None", "No normalisation is performed."){

        @Override
        public double getScaleFactor(double sum, double max, double binWidth, boolean cumul) {
            return 1.0;
        }
    };
    public static final Normalisation AREA = new Normalisation("Area", "The total area of histogram bars is normalised to unity. For cumulative plots, this behaves like <code>height</code>."){

        @Override
        public double getScaleFactor(double sum, double max, double binWidth, boolean cumul) {
            return 1.0 / (cumul ? sum : sum * binWidth);
        }
    };
    public static final Normalisation UNIT = new Normalisation("Unit", "Histogram bars are scaled by the inverse of the bin width in data units. For cumulative plots, this behaves like <code>none</code>."){

        @Override
        public double getScaleFactor(double sum, double max, double binWidth, boolean cumul) {
            return cumul ? 1.0 : 1.0 / binWidth;
        }
    };
    public static final Normalisation MAXIMUM = new Normalisation("Maximum", "The height of the tallest histogram bar is normalised to unity. For cumulative plots, this behaves like <code>height</code>."){

        @Override
        public double getScaleFactor(double sum, double max, double binWidth, boolean cumul) {
            return 1.0 / (cumul ? sum : max);
        }
    };
    public static final Normalisation HEIGHT = new Normalisation("Height", "The total height of histogram bars is normalised to unity."){

        @Override
        public double getScaleFactor(double sum, double max, double binWidth, boolean cumul) {
            return 1.0 / sum;
        }
    };
    private static final Normalisation[] KNOWN_VALUES = new Normalisation[]{NONE, AREA, UNIT, MAXIMUM, HEIGHT};

    protected Normalisation(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public String getDescription() {
        return this.description_;
    }

    public abstract double getScaleFactor(double var1, double var3, double var5, boolean var7);

    public String toString() {
        return this.name_;
    }

    public static Normalisation[] getKnownValues() {
        return (Normalisation[])KNOWN_VALUES.clone();
    }
}

