/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.LineXYShape;
import uk.ac.starlink.ttools.plot2.layer.MultiPosIcon;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class PairLinkForm
implements ShapeForm {
    private static final PairLinkForm instance_ = new PairLinkForm();
    private static final LineXYShape LINE_SHAPE = LineXYShape.getInstance();

    private PairLinkForm() {
    }

    @Override
    public String getFormName() {
        return "Link2";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_LINK2;
    }

    @Override
    public String getFormDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a line linking two positions from the same", "input table row.", "</p>"});
    }

    @Override
    public int getPositionCount() {
        return 2;
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[0];
    }

    @Override
    public ConfigKey[] getConfigKeys() {
        return new ConfigKey[0];
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        return new LinkOutliner();
    }

    public static PairLinkForm getInstance() {
        return instance_;
    }

    private static Icon createLegendIcon() {
        return new MultiPosIcon(2){

            @Override
            protected void paintPositions(Graphics g, Point[] positions) {
                Point p0 = positions[0];
                Point p1 = positions[1];
                int xoff = p0.x;
                int yoff = p0.y;
                g.translate(p0.x, p0.y);
                PairLinkForm.getLineGlyph(p1.x - p0.x, p1.y - p0.y).paintGlyph(g);
                g.translate(-p0.x, -p0.y);
            }
        };
    }

    private static Glyph getLineGlyph(int gx, int gy) {
        return LINE_SHAPE.getGlyph((short)gx, (short)gy);
    }

    private static boolean lineMightCross(Rectangle box, Point p1, Point p2) {
        int xmin = box.x;
        int xmax = box.x + box.width;
        if (PairLinkForm.getRegion(p1.x, xmin, xmax) * PairLinkForm.getRegion(p2.x, xmin, xmax) == 1) {
            return false;
        }
        int ymin = box.y;
        int ymax = box.y + box.height;
        return PairLinkForm.getRegion(p1.y, ymin, ymax) * PairLinkForm.getRegion(p2.y, ymin, ymax) != 1;
    }

    private static int getRegion(int point, int lo, int hi) {
        return point >= lo ? (point <= hi ? 0 : 1) : -1;
    }

    static /* synthetic */ Icon access$100() {
        return PairLinkForm.createLegendIcon();
    }

    private static class LinkOutliner
    extends PixOutliner {
        private final Icon icon_ = PairLinkForm.access$100();

        LinkOutliner() {
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            return new HashMap<AuxScale, AuxReader>();
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, Map<AuxScale, Range> auxRanges, final PaperType2D paperType) {
            int ndim = surface.getDataDimCount();
            final double[] dpos1 = new double[ndim];
            final double[] dpos2 = new double[ndim];
            final Point2D.Double gp1 = new Point2D.Double();
            final Point2D.Double gp2 = new Point2D.Double();
            final Point gp1i = new Point();
            final Point gp2i = new Point();
            final int npc = geom.getPosCoords().length;
            final Rectangle bounds = surface.getPlotBounds();
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos1) && surface.dataToGraphics(dpos1, false, gp1) && PlotUtil.isPointFinite(gp1) && geom.readDataPos(tuple, npc, dpos2) && surface.dataToGraphics(dpos2, false, gp2) && PlotUtil.isPointFinite(gp2)) {
                        PlotUtil.quantisePoint(gp1, gp1i);
                        PlotUtil.quantisePoint(gp2, gp2i);
                        if (PairLinkForm.lineMightCross(bounds, gp1i, gp2i)) {
                            Glyph glyph = PairLinkForm.getLineGlyph(gp2i.x - gp1i.x, gp2i.y - gp1i.y);
                            paperType.placeGlyph(paper, gp1i.x, gp1i.y, glyph, color);
                        }
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, Map<AuxScale, Range> auxRanges, final PaperType3D paperType) {
            int ndim = surface.getDataDimCount();
            final double[] dpos1 = new double[ndim];
            final double[] dpos2 = new double[ndim];
            final Point2D.Double gp1 = new Point2D.Double();
            final Point2D.Double gp2 = new Point2D.Double();
            final Point gp1i = new Point();
            final Point gp2i = new Point();
            final double[] dz1 = new double[1];
            final double[] dz2 = new double[1];
            final int npc = geom.getPosCoords().length;
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos1) && geom.readDataPos(tuple, npc, dpos2) && (surface.inRange(dpos1) || surface.inRange(dpos2)) && surface.dataToGraphicZ(dpos1, false, gp1, dz1) && surface.dataToGraphicZ(dpos2, false, gp2, dz2)) {
                        double z = 0.5 * (dz1[0] + dz2[0]);
                        PlotUtil.quantisePoint(gp1, gp1i);
                        PlotUtil.quantisePoint(gp2, gp2i);
                        Glyph glyph = PairLinkForm.getLineGlyph(gp2i.x - gp1i.x, gp2i.y - gp1i.y);
                        paperType.placeGlyph(paper, gp1i.x, gp1i.y, z, glyph, color);
                    }
                }
            };
        }

        public int hashCode() {
            int code = -1045;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LinkOutliner) {
                LinkOutliner other = (LinkOutliner)o;
                return true;
            }
            return false;
        }
    }
}

