/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Rectangle;
import java.util.Map;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.GlyphPaper;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;

public abstract class PixOutliner
implements Outliner {
    @Override
    public Object calculateBinPlan(Surface surface, DataGeom geom, Map<AuxScale, Range> auxRanges, DataStore dataStore, DataSpec dataSpec, Object[] knownPlans) {
        for (int ip = 0; ip < knownPlans.length; ++ip) {
            PixBinPlan plan;
            if (!(knownPlans[ip] instanceof PixBinPlan) || !(plan = (PixBinPlan)knownPlans[ip]).matches(geom, dataSpec, surface, this)) continue;
            return plan;
        }
        BinPaper paper = new BinPaper(surface.getPlotBounds());
        ShapePainter painter = this.create2DPainter(surface, geom, auxRanges, paper.getPaperType());
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        while (tseq.next()) {
            painter.paintPoint(tseq, null, paper);
        }
        return new PixBinPlan(paper.counts_, paper.pointCount_, geom, dataSpec, surface, this);
    }

    @Override
    public int[] getBinCounts(Object binPlan) {
        return ((PixBinPlan)binPlan).counts_;
    }

    @Override
    public long getPointCount(Object binPlan) {
        return ((PixBinPlan)binPlan).pointCount_;
    }

    private static class PixBinPlan {
        final int[] counts_;
        final long pointCount_;
        final DataGeom geom_;
        final DataSpec dataSpec_;
        final Surface surface_;
        final PixOutliner outliner_;

        PixBinPlan(int[] counts, long pointCount, DataGeom geom, DataSpec dataSpec, Surface surface, PixOutliner outliner) {
            this.counts_ = counts;
            this.pointCount_ = pointCount;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.surface_ = surface;
            this.outliner_ = outliner;
        }

        boolean matches(DataGeom geom, DataSpec dataSpec, Surface surface, PixOutliner outliner) {
            return this.geom_.equals(geom) && this.dataSpec_.equals(dataSpec) && this.surface_.equals(surface) && this.outliner_.equals(outliner);
        }
    }

    private static class BinPaper
    extends GlyphPaper {
        final Rectangle bounds_;
        final Gridder gridder_;
        final int xoff_;
        final int yoff_;
        final int[] counts_;
        long pointCount_;

        BinPaper(Rectangle bounds) {
            super(bounds);
            this.bounds_ = new Rectangle(bounds);
            this.gridder_ = new Gridder(bounds.width, bounds.height);
            this.xoff_ = this.bounds_.x;
            this.yoff_ = this.bounds_.y;
            this.counts_ = new int[this.gridder_.getLength()];
        }

        @Override
        public void glyphPixels(Pixer pixer) {
            while (pixer.next()) {
                int px = pixer.getX();
                int py = pixer.getY();
                assert (this.bounds_.contains(px, py));
                int n = this.gridder_.getIndex(px - this.xoff_, py - this.yoff_);
                this.counts_[n] = this.counts_[n] + 1;
            }
            ++this.pointCount_;
        }
    }
}

