/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.StandardKernel1dShape;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public abstract class Pixel1dPlotter<S extends Style>
implements Plotter<S> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord weightCoord_;
    private final String name_;
    private final Icon icon_;
    private final SliceDataGeom pixoDataGeom_;
    private final CoordGroup pixoCoordGrp_;
    private final int icX_;
    private final int icWeight_;
    private static final int MAX_KERNEL_WIDTH = 50;
    private static final int MAX_KERNEL_EXTENT = 150;
    public static final ReportKey<Double> SMOOTHWIDTH_KEY = ReportKey.createDoubleKey(new ReportMeta("smoothwidth", "Smoothing Width"), false);
    public static final ConfigKey<BinSizer> SMOOTHSIZER_KEY = BinSizer.createSizerConfigKey(new ConfigMeta("smooth", "Smoothing").setStringUsage("+<width>|-<count>").setShortDescription("Smoothing width specification").setXmlDescription(new String[]{"<p>Configures the smoothing width for kernel density", "estimation.", "This is the characteristic width of the kernel function", "to be convolved with the density to produce the visible plot.", "</p>", BinSizer.getConfigKeyDescription()}), SMOOTHWIDTH_KEY, 100, true);
    public static final ConfigKey<Kernel1dShape> KERNEL_KEY = new OptionConfigKey<Kernel1dShape>(new ConfigMeta("kernel", "Kernel").setShortDescription("Smoothing kernel functional form").setXmlDescription(new String[]{"<p>The functional form of the smoothing kernel.", "The functions listed refer to the unscaled shape;", "all kernels are normalised to give a total area of unity.", "</p>"}), Kernel1dShape.class, StandardKernel1dShape.getStandardOptions(), (Kernel1dShape)StandardKernel1dShape.EPANECHNIKOV){

        @Override
        public String getXmlDescription(Kernel1dShape kshape) {
            return kshape.getDescription();
        }
    }.setOptionUsage().addOptionsXml();

    protected Pixel1dPlotter(FloatingCoord xCoord, boolean hasWeight, String name, Icon icon) {
        this.xCoord_ = xCoord;
        this.name_ = name;
        this.icon_ = icon;
        if (hasWeight) {
            this.weightCoord_ = FloatingCoord.WEIGHT_COORD;
            this.pixoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord, this.weightCoord_}, new boolean[]{true, true});
        } else {
            this.weightCoord_ = null;
            this.pixoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord}, new boolean[]{true});
        }
        this.pixoDataGeom_ = new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "X");
        this.icX_ = this.pixoCoordGrp_.getExtraCoordIndex(0, null);
        this.icWeight_ = hasWeight ? this.pixoCoordGrp_.getExtraCoordIndex(1, null) : -1;
    }

    @Override
    public String getPlotterName() {
        return this.name_;
    }

    @Override
    public Icon getPlotterIcon() {
        return this.icon_;
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.pixoCoordGrp_;
    }

    @Override
    public boolean hasReports() {
        return false;
    }

    protected abstract LayerOpt getLayerOpt(S var1);

    protected abstract int getPixelPadding(S var1, PlanarSurface var2);

    protected abstract void paintBins(PlanarSurface var1, BinArray var2, S var3, Graphics2D var4);

    protected abstract void extendPixel1dCoordinateRanges(Range[] var1, boolean[] var2, S var3, DataSpec var4, DataStore var5);

    protected abstract ReportMap getPixel1dReport(Pixel1dPlan var1, S var2, boolean var3);

    public Pixel1dPlan calculatePixelPlan(Object[] knownPlans, Axis xAxis, int xpad, DataSpec dataSpec, DataStore dataStore) {
        for (int ip = 0; ip < knownPlans.length; ++ip) {
            Pixel1dPlan plan;
            if (!(knownPlans[ip] instanceof Pixel1dPlan) || !(plan = (Pixel1dPlan)knownPlans[ip]).matches(xAxis, xpad, dataSpec)) continue;
            return plan;
        }
        BinArray binArray = this.readBins(xAxis, 50, dataSpec, dataStore);
        return new Pixel1dPlan(binArray, xAxis, 50, dataSpec);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, S style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        LayerOpt layerOpt = this.getLayerOpt(style);
        return new AbstractPlotLayer(this, this.pixoDataGeom_, dataSpec, (Style)style, layerOpt, (Style)style, dataSpec, layerOpt){
            final /* synthetic */ Style val$style;
            final /* synthetic */ DataSpec val$dataSpec;
            final /* synthetic */ LayerOpt val$layerOpt;
            {
                this.val$style = style;
                this.val$dataSpec = dataSpec;
                this.val$layerOpt = layerOpt;
                super(x0, x1, x2, x3, x4);
            }

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, final PaperType paperType) {
                if (!(surface instanceof PlanarSurface)) {
                    throw new IllegalArgumentException("Not planar surface " + surface);
                }
                final PlanarSurface pSurf = (PlanarSurface)surface;
                final Axis xAxis = pSurf.getAxes()[0];
                final boolean xLog = pSurf.getLogFlags()[0];
                final int xpad = Pixel1dPlotter.this.getPixelPadding(this.val$style, pSurf);
                return new Drawing(){

                    @Override
                    public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                        for (int ip = 0; ip < knownPlans.length; ++ip) {
                            Pixel1dPlan plan;
                            if (!(knownPlans[ip] instanceof Pixel1dPlan) || !(plan = (Pixel1dPlan)knownPlans[ip]).matches(xAxis, xpad, val$dataSpec)) continue;
                            return plan;
                        }
                        BinArray binArray = Pixel1dPlotter.this.readBins(xAxis, 50, val$dataSpec, dataStore);
                        return new Pixel1dPlan(binArray, xAxis, 50, val$dataSpec);
                    }

                    @Override
                    public void paintData(Object plan, Paper paper, DataStore dataStore) {
                        Pixel1dPlan pPlan = (Pixel1dPlan)plan;
                        final BinArray binArray = pPlan.binArray_;
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                Pixel1dPlotter.this.paintBins(pSurf, binArray, val$style, (Graphics2D)g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return val$layerOpt.isOpaque();
                            }
                        });
                    }

                    @Override
                    public ReportMap getReport(Object plan) {
                        return plan instanceof Pixel1dPlan ? Pixel1dPlotter.this.getPixel1dReport((Pixel1dPlan)plan, val$style, xLog) : null;
                    }
                };
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, boolean[] logFlags, DataStore dataStore) {
                Pixel1dPlotter.this.extendPixel1dCoordinateRanges(ranges, logFlags, this.val$style, this.val$dataSpec, dataStore);
            }
        };
    }

    public int getWeightCoordIndex() {
        return this.icWeight_;
    }

    public BinArray readBins(Axis xAxis, int padPix, DataSpec dataSpec, DataStore dataStore) {
        int[] glimits = xAxis.getGraphicsLimits();
        int ilo = glimits[0] - padPix;
        int ihi = glimits[1] + padPix;
        BinArray binArray = new BinArray(ilo, ihi);
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        if (this.weightCoord_ == null | dataSpec.isCoordBlank(this.icWeight_)) {
            while (tseq.next()) {
                double dx = this.xCoord_.readDoubleCoord(tseq, this.icX_);
                double gx = xAxis.dataToGraphics(dx);
                binArray.addToBin(gx, 1.0);
            }
        } else {
            while (tseq.next()) {
                double w = this.weightCoord_.readDoubleCoord(tseq, this.icWeight_);
                if (!PlotUtil.isFinite(w)) continue;
                double dx = this.xCoord_.readDoubleCoord(tseq, this.icX_);
                double gx = xAxis.dataToGraphics(dx);
                binArray.addToBin(gx, w);
            }
        }
        return binArray;
    }

    public static double[] getDataBins(BinArray binArray, Axis xAxis, Kernel1d kernel, Normalisation norm, boolean cumul) {
        double binWidth;
        double[] bins = binArray.getBins();
        int nb = bins.length;
        if (kernel != null) {
            bins = kernel.convolve(bins);
        }
        double max = 0.0;
        for (int ib = 0; ib < bins.length; ++ib) {
            max = Math.max(max, Math.abs(bins[ib]));
        }
        double total = binArray.getSum();
        double scale = norm.getScaleFactor(total, max, binWidth = Pixel1dPlotter.getPixelDataWidth(xAxis), cumul);
        if (scale != 1.0) {
            double[] nbins = new double[nb];
            for (int ib = 0; ib < nb; ++ib) {
                nbins[ib] = scale * bins[ib];
            }
            bins = nbins;
        }
        if (cumul) {
            double[] dlimits = xAxis.getDataLimits();
            boolean xflip = xAxis.dataToGraphics(dlimits[0]) > xAxis.dataToGraphics(dlimits[1]);
            double[] cbins = new double[nb];
            double sum = scale * binArray.getLowerSum(xflip);
            for (int ib = 0; ib < nb; ++ib) {
                int jb = xflip ? nb - ib - 1 : ib;
                cbins[jb] = sum += bins[jb];
            }
            bins = cbins;
        }
        return bins;
    }

    public static int getEffectiveExtent(Kernel1d kernel) {
        return Math.min(kernel.getExtent(), 150);
    }

    public static Kernel1d createKernel(Kernel1dShape kernelShape, BinSizer sizer, Axis xAxis, boolean xLog) {
        return kernelShape.createFixedWidthKernel(Pixel1dPlotter.getPixelWidth(sizer, xAxis, xLog));
    }

    public static double getPixelWidth(BinSizer sizer, Axis xAxis, boolean xLog) {
        double[] dLimits = xAxis.getDataLimits();
        double dWidth = sizer.getWidth(xLog, dLimits[0], dLimits[1], null);
        double gx0 = xAxis.dataToGraphics(dLimits[0]);
        double gx1 = xAxis.dataToGraphics(xLog ? dLimits[0] * dWidth : dLimits[0] + dWidth);
        return Math.abs(gx1 - gx0);
    }

    private static double getPixelDataWidth(Axis axis) {
        int[] glimits = axis.getGraphicsLimits();
        double gmid = 0.5 * (double)(glimits[0] + glimits[1]);
        double d1 = axis.graphicsToData(gmid - 0.5);
        double d2 = axis.graphicsToData(gmid + 0.5);
        return Math.abs(axis.isLinear() ? d2 - d1 : Math.log(d2) - Math.log(d1));
    }

    public static class BinArray {
        private final double[] bins_;
        private final int glo_;
        private final int ghi_;
        private double loSum_;
        private double hiSum_;
        private double midSum_;

        BinArray(int glo, int ghi) {
            this.glo_ = glo;
            this.ghi_ = ghi;
            this.bins_ = new double[ghi - glo];
        }

        private void addToBin(double gx, double inc) {
            double dx = Math.round(gx - (double)this.glo_);
            if (dx >= 0.0 && dx < (double)this.bins_.length) {
                int n = (int)dx;
                this.bins_[n] = this.bins_[n] + inc;
                this.midSum_ += inc;
            } else if (dx < 0.0) {
                this.loSum_ += inc;
            } else if (dx >= (double)this.bins_.length) {
                this.hiSum_ += inc;
            }
        }

        public double[] getBins() {
            return this.bins_;
        }

        public double getSum() {
            return this.loSum_ + this.midSum_ + this.hiSum_;
        }

        public double getLowerSum(boolean flip) {
            return flip ? this.hiSum_ : this.loSum_;
        }

        public int getBinIndex(int gx) {
            return gx - this.glo_;
        }

        public int getGraphicsCoord(int index) {
            return index + this.glo_;
        }
    }

    public static class Pixel1dPlan {
        final BinArray binArray_;
        final Axis xAxis_;
        final int xpad_;
        final DataSpec dataSpec_;

        Pixel1dPlan(BinArray binArray, Axis xAxis, int xpad, DataSpec dataSpec) {
            this.binArray_ = binArray;
            this.xAxis_ = xAxis;
            this.xpad_ = xpad;
            this.dataSpec_ = dataSpec;
        }

        boolean matches(Axis xAxis, int xpad, DataSpec dataSpec) {
            return this.xAxis_.equals(xAxis) && this.dataSpec_.equals(dataSpec) && this.xpad_ >= xpad;
        }
    }
}

