/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Pixer;

public class Pixers {
    private Pixers() {
    }

    public static Pixer createArrayPixer(final int[] xs, final int[] ys, final int np) {
        return new Pixer(){
            int ip = -1;

            @Override
            public boolean next() {
                return ++this.ip < np;
            }

            @Override
            public int getX() {
                return xs[this.ip];
            }

            @Override
            public int getY() {
                return ys[this.ip];
            }
        };
    }

    public static Pixer translate(final Pixer base, final int tx, final int ty) {
        return new Pixer(){

            @Override
            public boolean next() {
                return base.next();
            }

            @Override
            public int getX() {
                return base.getX() + tx;
            }

            @Override
            public int getY() {
                return base.getY() + ty;
            }
        };
    }

    public static Pixer clip(Pixer base, Rectangle clip) {
        return new ClipPixer(base, clip.x, clip.x + clip.width - 1, clip.y, clip.y + clip.height - 1);
    }

    public static Pixer clip(Pixer base, Rectangle clip, int xminBase, int xmaxBase, int yminBase, int ymaxBase) {
        if (base == null) {
            return null;
        }
        int xminClip = clip.x;
        int xmaxClip = clip.x + clip.width - 1;
        int yminClip = clip.y;
        int ymaxClip = clip.y + clip.height - 1;
        int xcmp = Pixers.compare(xminClip, xmaxClip, xminBase, xmaxBase);
        if (xcmp == 0) {
            return null;
        }
        int ycmp = Pixers.compare(yminClip, ymaxClip, yminBase, ymaxBase);
        if (ycmp == 0) {
            return null;
        }
        if (xcmp == 1 && ycmp == 1) {
            return base;
        }
        int xmin = Math.max(xminClip, xminBase);
        int xmax = Math.min(xmaxClip, xmaxBase);
        int ymin = Math.max(yminClip, yminBase);
        int ymax = Math.min(ymaxClip, ymaxBase);
        return new ClipPixer(base, xmin, xmax, ymin, ymax);
    }

    private static int compare(int minOuter, int maxOuter, int minInner, int maxInner) {
        if (minInner > maxOuter || maxInner < minOuter) {
            return 0;
        }
        if (minInner >= minOuter && maxInner <= maxOuter) {
            return 1;
        }
        return -1;
    }

    private static class ClipPixer
    implements Pixer {
        private final Pixer base_;
        private final int xmin_;
        private final int xmax_;
        private final int ymin_;
        private final int ymax_;

        ClipPixer(Pixer base, int xmin, int xmax, int ymin, int ymax) {
            this.xmin_ = xmin;
            this.xmax_ = xmax;
            this.ymin_ = ymin;
            this.ymax_ = ymax;
            this.base_ = base;
        }

        @Override
        public boolean next() {
            while (this.base_.next()) {
                if (!ClipPixer.contains(this.xmin_, this.xmax_, this.base_.getX()) || !ClipPixer.contains(this.ymin_, this.ymax_, this.base_.getY())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getX() {
            return this.base_.getX();
        }

        @Override
        public int getY() {
            return this.base_.getY();
        }

        private static boolean contains(int min, int max, int value) {
            return value >= min && value <= max;
        }
    }
}

