/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.HashBinList;
import uk.ac.starlink.util.DoubleList;

@Equality
public abstract class QuantileCombiner
extends Combiner {
    private final Quantiler quantiler_;

    public QuantileCombiner(String name, String description, Quantiler quantiler) {
        super(name, description, true);
        this.quantiler_ = quantiler;
    }

    @Override
    public BinList createArrayBinList(int size) {
        final DoubleList[] dlists = new DoubleList[size];
        return new ArrayBinList(size, this){

            @Override
            public void submitToBinInt(int index, double value) {
                DoubleList dlist = dlists[index];
                if (dlist == null) {
                    dlists[index] = new DoubleList(new double[]{value});
                } else {
                    dlist.add(value);
                }
            }

            @Override
            public double getBinResultInt(int index) {
                DoubleList dlist = dlists[index];
                return dlist == null ? Double.NaN : QuantileCombiner.this.calculateQuantile(dlist);
            }
        };
    }

    @Override
    public BinList createHashBinList(long size) {
        return new HashBinList(size, this);
    }

    @Override
    public Combiner.Container createContainer() {
        final DoubleList dlist_ = new DoubleList();
        return new Combiner.Container(){

            @Override
            public void submit(double datum) {
                dlist_.add(datum);
            }

            @Override
            public double getResult() {
                return QuantileCombiner.this.calculateQuantile(dlist_);
            }
        };
    }

    public int hashCode() {
        int code = 23234232;
        code = 23 * code + this.quantiler_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof QuantileCombiner) {
            QuantileCombiner other = (QuantileCombiner)o;
            return this.quantiler_.equals(other.quantiler_);
        }
        return false;
    }

    private double calculateQuantile(DoubleList dlist) {
        double[] values = dlist.toDoubleArray();
        Arrays.sort(values);
        return this.quantiler_.calculateValue(values);
    }

    @Equality
    public static interface Quantiler {
        public double calculateValue(double[] var1);
    }
}

