/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.CountScaler;
import uk.ac.starlink.ttools.plot2.layer.FloatingCoordAuxReader;
import uk.ac.starlink.ttools.plot2.layer.GlyphPaper;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.ModePlotter;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixelImage;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.SkyDensityPlotter;
import uk.ac.starlink.ttools.plot2.layer.Stamper;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;
import uk.ac.starlink.util.IconUtils;

public abstract class ShapeMode
implements ModePlotter.Mode {
    private final String name_;
    private final Icon icon_;
    private final Coord[] extraCoords_;
    private final boolean hasReports_;
    private static final int BIN_THRESH_2D = 50000;
    private static final int NO_BINS = Integer.MAX_VALUE;
    private static final int COLOR_MAP_SIZE = 128;
    public static final ShapeMode AUTO = new AutoDensityMode();
    public static final ShapeMode FLAT2D = new FlatMode(false, 50000);
    public static final ShapeMode FLAT3D = new FlatMode(false, Integer.MAX_VALUE);
    public static final ShapeMode TRANSLUCENT = new AutoTransparentMode();
    public static final ShapeMode TRANSPARENT2D = new FlatMode(true, 50000);
    public static final ShapeMode TRANSPARENT3D = new FlatMode(true, Integer.MAX_VALUE);
    public static final ShapeMode DENSITY = new CustomDensityMode();
    public static final ShapeMode AUX = new AuxShadingMode(true, false);
    public static final ShapeMode WEIGHTED = new WeightedDensityMode(false);
    public static final ShapeMode[] MODES_2D = new ShapeMode[]{AUTO, FLAT2D, TRANSLUCENT, TRANSPARENT2D, DENSITY, AUX, WEIGHTED};
    public static final ShapeMode[] MODES_3D = new ShapeMode[]{FLAT3D, TRANSLUCENT, TRANSPARENT3D, DENSITY, AUX, WEIGHTED};
    public static final ReportKey<Double> REPKEY_XPIX = ReportKey.createDoubleKey(new ReportMeta("xpix_size", "Pixel X dimension in data coords"), true);
    public static final ReportKey<Double> REPKEY_YPIX = ReportKey.createDoubleKey(new ReportMeta("ypix_size", "Pixel Y dimension in data coords"), true);
    public static final ReportKey<Double> REPKEY_SKYPIX = ReportKey.createDoubleKey(new ReportMeta("pixel_sqdeg", "Pixel size in square degrees at proj center"), true);

    public ShapeMode(String name, Icon icon, Coord[] extraCoords, boolean hasReports) {
        this.name_ = name;
        this.icon_ = icon;
        this.extraCoords_ = extraCoords;
        this.hasReports_ = hasReports;
    }

    @Override
    public String getModeName() {
        return this.name_;
    }

    @Override
    public Icon getModeIcon() {
        return this.icon_;
    }

    public boolean hasReports() {
        return this.hasReports_;
    }

    public abstract String getModeDescription();

    public Coord[] getExtraCoords() {
        return this.extraCoords_;
    }

    public abstract ConfigKey[] getConfigKeys();

    public abstract Stamper createStamper(ConfigMap var1);

    public abstract PlotLayer createLayer(ShapePlotter var1, ShapeForm var2, DataGeom var3, DataSpec var4, Outliner var5, Stamper var6);

    private static ReportMap getPixelReport(Surface surface) {
        ReportMap report = new ReportMap();
        if (surface instanceof PlaneSurface) {
            Axis[] axes = ((PlaneSurface)surface).getAxes();
            ShapeMode.addPixelSize(report, REPKEY_XPIX, axes[0]);
            ShapeMode.addPixelSize(report, REPKEY_YPIX, axes[1]);
        } else if (surface instanceof SkySurface) {
            SkySurface ssurf = (SkySurface)surface;
            Point p = ssurf.getSkyCenter();
            double[] p1 = ssurf.graphicsToData(new Point2D.Double((double)p.x - 0.5, (double)p.y - 0.5), null);
            double[] p2 = ssurf.graphicsToData(new Point2D.Double((double)p.x + 0.5, (double)p.y + 0.5), null);
            if (p1 != null && p2 != null) {
                double pixTheta = SkyDensityPlotter.vectorSeparation(p1, p2) / Math.sqrt(2.0);
                double pixSteradians = pixTheta * pixTheta;
                double pixSqdeg = pixSteradians / 3.0461741978670857E-4;
                report.put(REPKEY_SKYPIX, pixSqdeg);
            }
        }
        return report;
    }

    private static void addPixelSize(ReportMap report, ReportKey key, Axis axis) {
        if (axis.isLinear()) {
            int g0 = axis.getGraphicsLimits()[0];
            double pixSize = Math.abs(axis.graphicsToData(g0 + 1) - axis.graphicsToData(g0));
            report.put(key, new Double(pixSize));
        }
    }

    public static Icon createColoredIcon(Icon base, Shader shader, float value) {
        float[] rgba = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        shader.adjustRgba(rgba, value);
        Color color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        return IconUtils.colorIcon((Icon)base, (Color)color);
    }

    public static String modeRef(ShapeMode mode) {
        String mname = mode.getModeName().toString();
        return "<ref id='shading-" + mname + "'>" + mname + "</ref>";
    }

    private static abstract class BinShapeDrawing
    implements Drawing {
        final DrawSpec drawSpec_;

        BinShapeDrawing(DrawSpec drawSpec) {
            this.drawSpec_ = drawSpec;
        }

        abstract PixelImage createPixelImage(Object var1);

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            return this.drawSpec_.calculateBinPlan(knownPlans, dataStore);
        }

        int[] getBinCounts(Object plan) {
            return this.drawSpec_.outliner_.getBinCounts(plan);
        }

        @Override
        public void paintData(Object plan, Paper paper, DataStore dataStore) {
            final PixelImage pim = this.createPixelImage(plan);
            final Rectangle bounds = this.drawSpec_.surface_.getPlotBounds();
            this.drawSpec_.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    pim.paintPixels(g, bounds.getLocation());
                }

                @Override
                public boolean isOpaque() {
                    return true;
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            return null;
        }
    }

    private static abstract class ShapePlotLayer
    extends AbstractPlotLayer {
        private final Outliner outliner_;

        ShapePlotLayer(ShapePlotter plotter, DataGeom geom, DataSpec dataSpec, Style style, LayerOpt opt, Outliner outliner) {
            super(plotter, geom, dataSpec, style, opt);
            this.outliner_ = outliner;
        }

        abstract Drawing createDrawing(DrawSpec var1);

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers() {
            Map<AuxScale, AuxReader> map = super.getAuxRangers();
            map.putAll(this.outliner_.getAuxRangers(this.getDataGeom()));
            return map;
        }

        @Override
        public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
            DrawSpec drawSpec = new DrawSpec(surface, this.getDataGeom(), this.getDataSpec(), this.outliner_, auxRanges, paperType);
            return this.createDrawing(drawSpec);
        }
    }

    private static interface ColorKit {
        public Color readColor(Tuple var1);
    }

    private static class DrawSpec {
        final Surface surface_;
        final DataGeom geom_;
        final DataSpec dataSpec_;
        final Outliner outliner_;
        final Map<AuxScale, Range> auxRanges_;
        final PaperType paperType_;
        final ShapePainter painter_;

        DrawSpec(Surface surface, DataGeom geom, DataSpec dataSpec, Outliner outliner, Map<AuxScale, Range> auxRanges, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.outliner_ = outliner;
            this.auxRanges_ = auxRanges;
            this.paperType_ = paperType;
            if (paperType instanceof PaperType2D) {
                this.painter_ = outliner.create2DPainter(surface, geom, auxRanges, (PaperType2D)paperType);
            } else if (paperType instanceof PaperType3D) {
                this.painter_ = outliner.create3DPainter((CubeSurface)surface, geom, auxRanges, (PaperType3D)paperType);
            } else {
                throw new IllegalArgumentException("paper type");
            }
        }

        public Object calculateBinPlan(Object[] knownPlans, DataStore dataStore) {
            return this.outliner_.calculateBinPlan(this.surface_, this.geom_, this.auxRanges_, dataStore, this.dataSpec_, knownPlans);
        }

        public Drawing createDrawing(final ColorKit kit) {
            return new UnplannedDrawing(){

                @Override
                public void paintData(Paper paper, DataStore dataStore) {
                    TupleSequence tseq = dataStore.getTupleSequence(DrawSpec.this.dataSpec_);
                    while (tseq.next()) {
                        Color color = kit.readColor(tseq);
                        if (color == null) continue;
                        DrawSpec.this.painter_.paintPoint(tseq, color, paper);
                    }
                }
            };
        }
    }

    public static class ShadeStamper
    implements Stamper {
        final Shader shader_;
        final Scaling scaling_;
        final Color baseColor_;
        final Color nullColor_;
        final float scaleAlpha_;

        public ShadeStamper(Shader shader, Scaling scaling, Color baseColor, Color nullColor, float scaleAlpha) {
            this.shader_ = shader;
            this.scaling_ = scaling;
            this.baseColor_ = baseColor;
            this.nullColor_ = nullColor;
            this.scaleAlpha_ = scaleAlpha;
        }

        @Override
        public Icon createLegendIcon(Outliner outliner) {
            return ShapeMode.createColoredIcon(outliner.getLegendIcon(), this.shader_, 0.5f);
        }

        public boolean equals(Object o) {
            if (o instanceof ShadeStamper) {
                ShadeStamper other = (ShadeStamper)o;
                return this.shader_.equals(other.shader_) && this.scaling_.equals(other.scaling_) && PlotUtil.equals(this.baseColor_, other.baseColor_) && PlotUtil.equals(this.nullColor_, other.nullColor_) && this.scaleAlpha_ == other.scaleAlpha_;
            }
            return false;
        }

        public int hashCode() {
            int code = 7301;
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + PlotUtil.hashCode(this.baseColor_);
            code = 23 * code + PlotUtil.hashCode(this.nullColor_);
            code = 23 * code + Float.floatToIntBits(this.scaleAlpha_);
            return code;
        }
    }

    public static class WeightStamper
    implements Stamper {
        final Shader shader_;
        final Scaling scaling_;
        final Combiner combiner_;

        public WeightStamper(Shader shader, Scaling scaling, Combiner combiner) {
            this.shader_ = shader;
            this.scaling_ = scaling;
            this.combiner_ = combiner;
        }

        @Override
        public Icon createLegendIcon(Outliner outliner) {
            return ShapeMode.createColoredIcon(outliner.getLegendIcon(), this.shader_, 0.0f);
        }

        public boolean equals(Object o) {
            if (o instanceof WeightStamper) {
                WeightStamper other = (WeightStamper)o;
                return this.shader_.equals(other.shader_) && this.scaling_.equals(other.scaling_) && this.combiner_.equals(other.combiner_);
            }
            return false;
        }

        public int hashCode() {
            int code = 3311;
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            return code;
        }
    }

    private static class WeightedDensityMode
    extends ShapeMode {
        private final boolean reportAuxKeys_;
        private static final AuxScale SCALE = AuxScale.COLOR;
        private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
        private static final ConfigKey<Combiner> COMBINER_KEY = WeightedDensityMode.createWeightCombinerKey();
        private static final FloatingCoord WEIGHT_COORD = FloatingCoord.createCoord(new InputMeta("weight", "Weight").setShortDescription("Weight coordinate for weighted density shading"), false);

        WeightedDensityMode(boolean reportAuxKeys) {
            super("weighted", ResourceIcon.MODE_WEIGHT, new Coord[]{WEIGHT_COORD}, true);
            this.reportAuxKeys_ = reportAuxKeys;
        }

        @Override
        public String getModeDescription() {
            StringBuffer sbuf = new StringBuffer().append("<p>Paints markers like the Density mode,\n").append("but with optional weighting by an additional\n").append("coordinate.\n").append("You can configure how the weighted coordinates\n").append("are combined to give the final weighted result.\n");
            if (this.reportAuxKeys_) {
                sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
            } else {
                sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
            }
            sbuf.append("</p>\n");
            return sbuf.toString();
        }

        @Override
        public ConfigKey[] getConfigKeys() {
            ArrayList<ConfigKey> keyList = new ArrayList<ConfigKey>();
            keyList.add(StyleKeys.COLOR);
            keyList.add(COMBINER_KEY);
            if (this.reportAuxKeys_) {
                keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
            }
            return keyList.toArray(new ConfigKey[0]);
        }

        @Override
        public Stamper createStamper(ConfigMap config) {
            Color baseColor = config.get(StyleKeys.COLOR);
            RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
            Shader baseShader = ramp.getShader();
            Shader shader = Shaders.applyShader(baseShader, baseColor, 128);
            Scaling scaling = ramp.getScaling();
            Combiner combiner = config.get(COMBINER_KEY);
            return new WeightStamper(shader, scaling, combiner);
        }

        @Override
        public PlotLayer createLayer(ShapePlotter plotter, ShapeForm form, DataGeom geom, DataSpec dataSpec, Outliner outliner, Stamper stamper) {
            return new WeightLayer(plotter, geom, dataSpec, outliner, (WeightStamper)stamper);
        }

        private static ConfigKey<Combiner> createWeightCombinerKey() {
            ConfigMeta meta = new ConfigMeta("combine", "Combine");
            meta.setShortDescription("Value combination mode");
            meta.setXmlDescription(new String[]{"<p>Defines how values contributing to the same", "pixel are combined together to produce", "the value assigned to that pixel (and hence its colour).", "</p>", "<p>When a weight is in use,", "<code>" + Combiner.MEAN + "</code> or", "<code>" + Combiner.SUM + "</code>", "are typically sensible choices.", "If there is no weight (a pure density map)", "then <code>" + Combiner.COUNT + "</code> is usually better,", "but in that case it may make more sense", "(it is more efficient)", "to use one of the other shading modes instead.", "</p>"});
            Combiner[] options = Combiner.getKnownCombiners();
            Combiner dflt = Combiner.MEAN;
            OptionConfigKey<Combiner> key = new OptionConfigKey<Combiner>(meta, Combiner.class, options, dflt){

                @Override
                public String getXmlDescription(Combiner combiner) {
                    return combiner.getDescription();
                }
            };
            key.setOptionUsage();
            key.addOptionsXml();
            return key;
        }

        private static class WeightPaper
        extends GlyphPaper {
            private final Rectangle bounds_;
            private final Gridder gridder_;
            private final BinList binList_;
            private final int xoff_;
            private final int yoff_;
            private double weight_;

            WeightPaper(Rectangle bounds, Combiner combiner) {
                super(bounds);
                this.bounds_ = new Rectangle(bounds);
                this.gridder_ = new Gridder(bounds.width, bounds.height);
                int nbin = this.gridder_.getLength();
                BinList binlist = combiner.createArrayBinList(nbin);
                this.binList_ = binlist == null ? combiner.createHashBinList(nbin) : binlist;
                this.xoff_ = this.bounds_.x;
                this.yoff_ = this.bounds_.y;
            }

            public void setWeight(double weight) {
                this.weight_ = weight;
            }

            @Override
            public void glyphPixels(Pixer pixer) {
                while (pixer.next()) {
                    int px = pixer.getX();
                    int py = pixer.getY();
                    assert (this.bounds_.contains(px, py));
                    int ix = px - this.xoff_;
                    int iy = py - this.yoff_;
                    this.binList_.submitToBin(this.gridder_.getIndex(ix, iy), this.weight_);
                }
            }
        }

        private static class WeightPlan {
            final int nbin_;
            final Combiner combiner_;
            final BinList.Result binResult_;
            final Surface surface_;
            final DataGeom geom_;
            final DataSpec dataSpec_;
            final Outliner outliner_;

            WeightPlan(int nbin, Combiner combiner, BinList.Result binResult, Surface surface, DataGeom geom, DataSpec dataSpec, Outliner outliner) {
                this.nbin_ = nbin;
                this.combiner_ = combiner;
                this.binResult_ = binResult;
                this.surface_ = surface;
                this.geom_ = geom;
                this.dataSpec_ = dataSpec;
                this.outliner_ = outliner;
            }

            public boolean matches(Combiner combiner, Surface surface, DataGeom geom, DataSpec dataSpec, Outliner outliner) {
                return combiner.equals(this.combiner_) && surface.equals(this.surface_) && geom.equals(this.geom_) && dataSpec.equals(this.dataSpec_) && outliner.equals(this.outliner_);
            }
        }

        private static class WeightLayer
        extends AbstractPlotLayer {
            private final Outliner outliner_;
            private final WeightStamper wstamper_;
            private final int icWeight_;

            WeightLayer(ShapePlotter plotter, DataGeom geom, DataSpec dataSpec, Outliner outliner, WeightStamper wstamper) {
                super(plotter, geom, dataSpec, new ShapeStyle(outliner, wstamper), WeightLayer.isTransparent(wstamper) ? LayerOpt.NO_SPECIAL : LayerOpt.OPAQUE);
                this.outliner_ = outliner;
                this.wstamper_ = wstamper;
                this.icWeight_ = plotter.getModeCoordsIndex(geom);
                assert (dataSpec.getCoord(this.icWeight_) == WEIGHT_COORD);
            }

            @Override
            public Map<AuxScale, AuxReader> getAuxRangers() {
                Map<AuxScale, AuxReader> map = super.getAuxRangers();
                map.putAll(this.outliner_.getAuxRangers(this.getDataGeom()));
                map.put(SCALE, new AuxReader(){

                    @Override
                    public int getCoordIndex() {
                        return WeightLayer.this.icWeight_;
                    }

                    @Override
                    public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] knownPlans, Range range) {
                        BinList.Result binResult;
                        WeightPlan wplan = WeightLayer.this.getWeightPlan(knownPlans, surface, dataSpec);
                        if (wplan == null) {
                            HashMap auxRanges = new HashMap();
                            binResult = WeightLayer.this.readBinList(surface, dataSpec, dataStore, auxRanges).getResult();
                        } else {
                            binResult = wplan.binResult_;
                        }
                        PlotUtil.extendRange(range, binResult);
                    }
                });
                return map;
            }

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                return new WeightDrawing(surface, auxRanges, paperType);
            }

            private BinList readBinList(Surface surface, DataSpec dataSpec, DataStore dataStore, Map<AuxScale, Range> auxRanges) {
                boolean hasWeight;
                DataGeom geom = this.getDataGeom();
                WeightPaper wpaper = new WeightPaper(surface.getPlotBounds(), this.wstamper_.combiner_);
                ShapePainter painter = this.outliner_.create2DPainter(surface, geom, auxRanges, wpaper.getPaperType());
                TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
                boolean bl = hasWeight = !dataSpec.isCoordBlank(this.icWeight_);
                if (hasWeight) {
                    while (tseq.next()) {
                        double w = WEIGHT_COORD.readDoubleCoord(tseq, this.icWeight_);
                        if (Double.isNaN(w)) continue;
                        wpaper.setWeight(w);
                        painter.paintPoint(tseq, null, wpaper);
                    }
                } else {
                    wpaper.setWeight(1.0);
                    while (tseq.next()) {
                        painter.paintPoint(tseq, null, wpaper);
                    }
                }
                return wpaper.binList_;
            }

            private static boolean isTransparent(WeightStamper wstamper) {
                return Shaders.isTransparent(wstamper.shader_);
            }

            private WeightPlan getWeightPlan(Object[] knownPlans, Surface surface, DataSpec dataSpec) {
                DataGeom geom = this.getDataGeom();
                for (Object plan : knownPlans) {
                    WeightPlan wplan;
                    if (!(plan instanceof WeightPlan) || !(wplan = (WeightPlan)plan).matches(this.wstamper_.combiner_, surface, geom, dataSpec, this.outliner_)) continue;
                    return wplan;
                }
                return null;
            }

            private class WeightDrawing
            implements Drawing {
                final Surface surface_;
                final Map<AuxScale, Range> auxRanges_;
                final PaperType paperType_;

                WeightDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                    this.surface_ = surface;
                    this.auxRanges_ = auxRanges;
                    this.paperType_ = paperType;
                }

                @Override
                public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                    DataSpec dataSpec = WeightLayer.this.getDataSpec();
                    WeightPlan knownPlan = WeightLayer.this.getWeightPlan(knownPlans, this.surface_, dataSpec);
                    if (knownPlan != null) {
                        return knownPlan;
                    }
                    BinList binList = WeightLayer.this.readBinList(this.surface_, dataSpec, dataStore, this.auxRanges_);
                    int nbin = (int)binList.getSize();
                    Combiner combiner = binList.getCombiner();
                    BinList.Result binResult = binList.getResult().compact();
                    DataGeom geom = WeightLayer.this.getDataGeom();
                    return new WeightPlan(nbin, combiner, binResult, this.surface_, geom, dataSpec, WeightLayer.this.outliner_);
                }

                @Override
                public void paintData(Object plan, Paper paper, DataStore dataStore) {
                    WeightPlan wplan = (WeightPlan)plan;
                    final int nbin = wplan.nbin_;
                    final BinList.Result binResult = wplan.binResult_;
                    this.paperType_.placeDecal(paper, new Decal(){

                        @Override
                        public void paintDecal(Graphics g) {
                            WeightDrawing.this.paintBins(g, nbin, binResult);
                        }

                        @Override
                        public boolean isOpaque() {
                            return !WeightLayer.isTransparent(WeightLayer.this.wstamper_);
                        }
                    });
                }

                @Override
                public ReportMap getReport(Object plan) {
                    return ShapeMode.getPixelReport(this.surface_);
                }

                private void paintBins(Graphics g, int nbin, BinList.Result binResult) {
                    Range auxRange = this.auxRanges_.get(SCALE);
                    if (auxRange == null) {
                        auxRange = new Range();
                    }
                    Rectangle plotBounds = this.surface_.getPlotBounds();
                    IndexColorModel colorModel = PixelImage.createColorModel(((WeightLayer)WeightLayer.this).wstamper_.shader_, true);
                    Scaler scaler = Scaling.createRangeScaler(((WeightLayer)WeightLayer.this).wstamper_.scaling_, auxRange);
                    int[] pixels = this.scaleLevels(nbin, binResult, scaler, colorModel.getMapSize() - 1);
                    PixelImage image = new PixelImage(plotBounds.getSize(), pixels, colorModel);
                    image.paintPixels(g, plotBounds.getLocation());
                }

                private int[] scaleLevels(int nbin, BinList.Result binResult, Scaler scaler, int nlevel) {
                    int[] pixels = new int[nbin];
                    for (int i = 0; i < nbin; ++i) {
                        double val = binResult.getBinValue(i);
                        if (Double.isNaN(val)) continue;
                        int p = (int)(scaler.scaleValue(val) * (double)nlevel);
                        pixels[i] = Math.min(1 + p, nlevel - 1);
                    }
                    return pixels;
                }
            }
        }
    }

    private static class AuxShadingMode
    extends ShapeMode {
        private final boolean transparent_;
        private final boolean reportAuxKeys_;
        private static final AuxScale SCALE = AuxScale.COLOR;
        private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
        private static final String scaleName = SCALE.getName();
        private static final FloatingCoord SHADE_COORD = FloatingCoord.createCoord(new InputMeta(scaleName.toLowerCase(), scaleName).setShortDescription("Colour coordinate for " + scaleName + " shading"), false);

        AuxShadingMode(boolean transparent, boolean reportAuxKeys) {
            super("aux", ResourceIcon.MODE_AUX, new Coord[]{SHADE_COORD}, false);
            this.transparent_ = transparent;
            this.reportAuxKeys_ = reportAuxKeys;
        }

        @Override
        public String getModeDescription() {
            StringBuffer sbuf = new StringBuffer().append("<p>Paints markers in a colour determined by\n").append("the value of an additional data coordinate.\n").append("The marker colours then represent an additional\n").append("dimension of the plot.\n");
            if (this.transparent_) {
                sbuf.append("You can also adjust the transparency\n").append("of the colours used.\n");
            }
            if (this.reportAuxKeys_) {
                sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
            } else {
                sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
            }
            sbuf.append("</p>\n");
            return sbuf.toString();
        }

        @Override
        public ConfigKey[] getConfigKeys() {
            ArrayList<ConfigKey<Serializable>> list = new ArrayList<ConfigKey<Serializable>>();
            if (this.reportAuxKeys_) {
                list.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
            }
            list.add(StyleKeys.AUX_NULLCOLOR);
            if (this.transparent_) {
                list.add(StyleKeys.AUX_OPAQUE);
            }
            return list.toArray(new ConfigKey[0]);
        }

        @Override
        public Stamper createStamper(ConfigMap config) {
            RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
            Shader shader = ramp.getShader();
            Scaling scaling = ramp.getScaling();
            Color nullColor = config.get(StyleKeys.AUX_NULLCOLOR);
            double opaque = this.transparent_ ? config.get(StyleKeys.AUX_OPAQUE) : 1.0;
            float scaleAlpha = 1.0f / (float)opaque;
            Color baseColor = config.get(StyleKeys.COLOR);
            return new ShadeStamper(shader, scaling, baseColor, nullColor, scaleAlpha);
        }

        @Override
        public PlotLayer createLayer(ShapePlotter plotter, ShapeForm form, final DataGeom geom, final DataSpec dataSpec, final Outliner outliner, Stamper stamper) {
            final int iShadeCoord = plotter.getModeCoordsIndex(geom);
            assert (dataSpec.getCoord(iShadeCoord) == SHADE_COORD);
            ShadeStamper shStamper = (ShadeStamper)stamper;
            final Shader shader = shStamper.shader_;
            final Scaling scaling = shStamper.scaling_;
            final Color baseColor = shStamper.baseColor_;
            final Color nullColor = shStamper.nullColor_;
            final float scaleAlpha = shStamper.scaleAlpha_;
            ShapeStyle style = new ShapeStyle(outliner, stamper);
            LayerOpt opt = scaleAlpha < 1.0f || Shaders.isTransparent(shader) ? LayerOpt.NO_SPECIAL : LayerOpt.OPAQUE;
            return new AbstractPlotLayer(plotter, geom, dataSpec, style, opt){

                @Override
                public Map<AuxScale, AuxReader> getAuxRangers() {
                    Map<AuxScale, AuxReader> map = super.getAuxRangers();
                    FloatingCoordAuxReader shadeReader = new FloatingCoordAuxReader(SHADE_COORD, iShadeCoord, geom, true);
                    map.put(SCALE, shadeReader);
                    map.putAll(outliner.getAuxRangers(geom));
                    return map;
                }

                @Override
                public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                    Range shadeRange = auxRanges.get(SCALE);
                    Scaler scaler = Scaling.createRangeScaler(scaling, shadeRange);
                    DrawSpec drawSpec = new DrawSpec(surface, geom, dataSpec, outliner, auxRanges, paperType);
                    AuxColorKit kit = new AuxColorKit(iShadeCoord, shader, scaler, baseColor, nullColor, scaleAlpha);
                    return drawSpec.createDrawing(kit);
                }
            };
        }

        private static class AuxColorKit
        implements ColorKit {
            private final int icShade_;
            private final Shader shader_;
            private final Scaler scaler_;
            private final Color scaledNullColor_;
            private final float scaleAlpha_;
            private final float[] baseRgba_;
            private final float[] rgba_;
            private Color lastColor_;
            private float lastScale_;

            AuxColorKit(int icShade, Shader shader, Scaler scaler, Color baseColor, Color nullColor, float scaleAlpha) {
                this.icShade_ = icShade;
                this.shader_ = shader;
                this.scaler_ = scaler;
                this.scaleAlpha_ = scaleAlpha;
                this.scaledNullColor_ = nullColor == null ? null : this.toOutputColor(nullColor.getRGBComponents(null));
                this.baseRgba_ = baseColor.getRGBComponents(null);
                this.rgba_ = new float[4];
                this.lastColor_ = this.scaledNullColor_;
                this.lastScale_ = Float.NaN;
            }

            @Override
            public Color readColor(Tuple tuple) {
                double auxVal = SHADE_COORD.readDoubleCoord(tuple, this.icShade_);
                float scaleVal = (float)this.scaler_.scaleValue(auxVal);
                if (Float.isNaN(scaleVal)) {
                    return this.scaledNullColor_;
                }
                if (this.lastScale_ == scaleVal) {
                    return this.lastColor_;
                }
                System.arraycopy(this.baseRgba_, 0, this.rgba_, 0, 4);
                this.shader_.adjustRgba(this.rgba_, scaleVal);
                Color color = this.toOutputColor(this.rgba_);
                this.lastScale_ = scaleVal;
                this.lastColor_ = color;
                return color;
            }

            private Color toOutputColor(float[] rgba) {
                float alpha = rgba[3];
                return alpha > 0.0f ? new Color(rgba[0], rgba[1], rgba[2], alpha * this.scaleAlpha_) : null;
            }
        }
    }

    private static class CustomDensityMode
    extends AbstractDensityMode {
        private static final RampKeySet RAMP_KEYS = StyleKeys.DENSITY_RAMP;

        CustomDensityMode() {
            super("density", ResourceIcon.MODE_DENSITY);
        }

        @Override
        public String getModeDescription() {
            return PlotUtil.concatLines(new String[]{"<p>Paints markers using a configurable colour map", "to indicate how many points are plotted over each other.", "Specifically, it colours each pixel according to how many", "times that pixel has has been covered by one of the markers", "plotted by the layer in question.", "To put it another way,", "it generates a false-colour density map with pixel", "granularity using a smoothing kernel of the form of the", "markers plotted by the layer.", "The upshot is that you can see the plot density", "of points or other markers plotted.", "</p>", "<p>This is like " + CustomDensityMode.modeRef(AUTO) + " mode,", "but with more user-configurable options.", "</p>"});
        }

        @Override
        public ConfigKey[] getConfigKeys() {
            ArrayList<ConfigKey> keyList = new ArrayList<ConfigKey>();
            keyList.add(StyleKeys.COLOR);
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
            return keyList.toArray(new ConfigKey[0]);
        }

        @Override
        public Stamper createStamper(ConfigMap config) {
            Color baseColor = config.get(StyleKeys.COLOR);
            RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
            Shader baseShader = ramp.getShader();
            Shader densityShader = Shaders.applyShader(baseShader, baseColor, 128);
            Scaling scaling = ramp.getScaling();
            return new DensityStamper(densityShader, scaling);
        }
    }

    private static class AutoDensityMode
    extends AbstractDensityMode {
        AutoDensityMode() {
            super("auto", ResourceIcon.MODE_AUTO);
        }

        @Override
        public String getModeDescription() {
            return PlotUtil.concatLines(new String[]{"<p>Paints isolated points in their selected colour", "but where multiple points", "<em>in the same layer</em>", "overlap it adjusts the clour by darkening it.", "This means that for isolated points", "(most or all points in a non-crowded plot,", "or outliers in a crowded plot)", "it behaves just like " + AutoDensityMode.modeRef(FLAT2D) + " mode,", "but it's easy to see where overdense regions lie.", "</p>", "<p>This is like " + AutoDensityMode.modeRef(DENSITY) + " mode,", "but with no user-configurable options.", "</p>"});
        }

        @Override
        public ConfigKey[] getConfigKeys() {
            return new ConfigKey[]{StyleKeys.COLOR};
        }

        @Override
        public Stamper createStamper(ConfigMap config) {
            Color baseColor = config.get(StyleKeys.COLOR);
            Shader baseShader = Shaders.stretch(Shaders.SCALE_V, 1.0f, 0.2f);
            Shader densityShader = Shaders.applyShader(baseShader, baseColor, 128);
            return new DensityStamper(densityShader, Scaling.AUTO);
        }
    }

    public static class DensityStamper
    implements Stamper {
        final Shader shader_;
        final Scaling scaling_;

        public DensityStamper(Shader shader, Scaling scaling) {
            this.shader_ = shader;
            this.scaling_ = scaling;
        }

        @Override
        public Icon createLegendIcon(Outliner outliner) {
            return ShapeMode.createColoredIcon(outliner.getLegendIcon(), this.shader_, 0.0f);
        }

        public boolean equals(Object o) {
            if (o instanceof DensityStamper) {
                DensityStamper other = (DensityStamper)o;
                return this.shader_.equals(other.shader_) && this.scaling_.equals(other.scaling_);
            }
            return false;
        }

        public int hashCode() {
            int code = 3311;
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            return code;
        }
    }

    private static abstract class AbstractDensityMode
    extends ShapeMode {
        AbstractDensityMode(String name, Icon icon) {
            super(name, icon, new Coord[0], false);
        }

        @Override
        public PlotLayer createLayer(ShapePlotter plotter, ShapeForm form, DataGeom geom, DataSpec dataSpec, Outliner outliner, Stamper stamper) {
            final Shader shader = ((DensityStamper)stamper).shader_;
            final Scaling scaling = ((DensityStamper)stamper).scaling_;
            ShapeStyle style = new ShapeStyle(outliner, stamper);
            LayerOpt opt = Shaders.isTransparent(shader) ? LayerOpt.NO_SPECIAL : LayerOpt.OPAQUE;
            return new ShapePlotLayer(plotter, geom, dataSpec, style, opt, outliner){

                @Override
                public Drawing createDrawing(DrawSpec drawSpec) {
                    return new DensityDrawing(drawSpec, shader, scaling);
                }
            };
        }

        private static class DensityDrawing
        extends BinShapeDrawing {
            private final Shader shader_;
            private final Scaling scaling_;

            DensityDrawing(DrawSpec drawSpec, Shader shader, Scaling scaling) {
                super(drawSpec);
                this.shader_ = shader;
                this.scaling_ = scaling;
            }

            @Override
            PixelImage createPixelImage(Object plan) {
                int[] counts = (int[])this.getBinCounts(plan).clone();
                IndexColorModel colorModel = PixelImage.createColorModel(this.shader_, true);
                this.scaleLevels(counts, colorModel.getMapSize() - 1);
                Dimension size = this.drawSpec_.surface_.getPlotBounds().getSize();
                return new PixelImage(size, counts, colorModel);
            }

            private void scaleLevels(int[] buf, int nlevel) {
                int n = buf.length;
                int max = 0;
                for (int i = 0; i < n; ++i) {
                    max = Math.max(max, buf[i]);
                }
                if (max > 0) {
                    max = Math.max(max, 12);
                    CountScaler scaler = new CountScaler(this.scaling_, max, nlevel);
                    if (max != 1 || scaler.scaleCount(1) != 1) {
                        for (int i = 0; i < n; ++i) {
                            buf[i] = scaler.scaleCount(buf[i]);
                        }
                    }
                }
            }
        }
    }

    public static class AutoTransparentStamper
    implements Stamper {
        final Color color_;
        final double level_;

        public AutoTransparentStamper(Color color, double level) {
            this.color_ = color;
            this.level_ = level;
        }

        @Override
        public Icon createLegendIcon(Outliner outliner) {
            return IconUtils.colorIcon((Icon)outliner.getLegendIcon(), (Color)this.color_);
        }

        public boolean equals(Object o) {
            if (o instanceof AutoTransparentStamper) {
                AutoTransparentStamper other = (AutoTransparentStamper)o;
                return this.color_.equals(other.color_) && this.level_ == other.level_;
            }
            return false;
        }

        public int hashCode() {
            int code = 5231;
            code = code * 23 + this.color_.hashCode();
            code = code * 23 + Float.floatToIntBits((float)this.level_);
            return code;
        }
    }

    private static class AutoTransparentMode
    extends ShapeMode {
        AutoTransparentMode() {
            super("translucent", ResourceIcon.MODE_ALPHA, new Coord[0], false);
        }

        @Override
        public String getModeDescription() {
            return PlotUtil.concatLines(new String[]{"<p>Paints markers in a transparent version of their", "selected colour.", "The degree of transparency is determined by how many points", "are plotted on top of each other and by the transparency", "level.", "Unlike " + AutoTransparentMode.modeRef(TRANSPARENT2D) + " mode,", "the transparency varies according to the average", "point density in the plot,", "so leaving the setting the same as you zoom in and out", "usually has a sensible effect.", "</p>"});
        }

        @Override
        public ConfigKey[] getConfigKeys() {
            return new ConfigKey[]{StyleKeys.COLOR, StyleKeys.TRANSPARENT_LEVEL};
        }

        @Override
        public Stamper createStamper(ConfigMap config) {
            Color color = config.get(StyleKeys.COLOR);
            double level = config.get(StyleKeys.TRANSPARENT_LEVEL);
            return new AutoTransparentStamper(color, level);
        }

        @Override
        public PlotLayer createLayer(ShapePlotter plotter, ShapeForm form, DataGeom geom, DataSpec dataSpec, Outliner outliner, Stamper stamper) {
            final Color color = ((AutoTransparentStamper)stamper).color_;
            final double level = ((AutoTransparentStamper)stamper).level_;
            ShapeStyle style = new ShapeStyle(outliner, stamper);
            LayerOpt opt = new LayerOpt(color, level == 0.0);
            return new ShapePlotLayer(plotter, geom, dataSpec, style, opt, outliner){

                @Override
                public Drawing createDrawing(DrawSpec drawSpec) {
                    return new AutoTransparentDrawing(drawSpec, color, level);
                }
            };
        }

        private static class AutoTransparentDrawing
        implements Drawing {
            private final float[] rgb_;
            private final double level_;
            private final DrawSpec drawSpec_;

            AutoTransparentDrawing(DrawSpec drawSpec, Color color, double level) {
                this.drawSpec_ = drawSpec;
                this.rgb_ = color.getRGBColorComponents(new float[3]);
                this.level_ = level;
            }

            @Override
            public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                return this.drawSpec_.calculateBinPlan(knownPlans, dataStore);
            }

            @Override
            public void paintData(Object plan, Paper paper, DataStore dataStore) {
                int[] counts = this.drawSpec_.outliner_.getBinCounts(plan);
                float alpha = (float)AutoTransparentDrawing.getAlpha(counts, this.level_);
                Color color = new Color(this.rgb_[0], this.rgb_[1], this.rgb_[2], alpha);
                ShapePainter painter = this.drawSpec_.painter_;
                TupleSequence tseq = dataStore.getTupleSequence(this.drawSpec_.dataSpec_);
                while (tseq.next()) {
                    painter.paintPoint(tseq, color, paper);
                }
            }

            @Override
            public ReportMap getReport(Object plan) {
                return null;
            }

            private static double getAlpha(int[] counts, double level) {
                int count = 0;
                int max = 0;
                for (int c : counts) {
                    if (c <= 0) continue;
                    ++count;
                    if (c <= max) continue;
                    max = c;
                }
                double opaque = Math.max(1.0, (double)max * level);
                return 1.0 / opaque;
            }
        }
    }

    public static class FlatStamper
    implements Stamper {
        final Color color_;

        public FlatStamper(Color color) {
            this.color_ = color;
        }

        @Override
        public Icon createLegendIcon(Outliner outliner) {
            return IconUtils.colorIcon((Icon)outliner.getLegendIcon(), (Color)new Color(this.color_.getRGB(), false));
        }

        public boolean equals(Object o) {
            if (o instanceof FlatStamper) {
                FlatStamper other = (FlatStamper)o;
                return this.color_.equals(other.color_);
            }
            return false;
        }

        public int hashCode() {
            return this.color_.hashCode();
        }
    }

    private static class FlatMode
    extends ShapeMode {
        private final int binThresh_;
        private final boolean transparent_;

        FlatMode(boolean transparent, int binThresh) {
            super(transparent ? "transparent" : "flat", transparent ? ResourceIcon.MODE_ALPHA_FIX : ResourceIcon.MODE_FLAT, new Coord[0], false);
            this.transparent_ = transparent;
            this.binThresh_ = binThresh;
        }

        @Override
        public String getModeDescription() {
            if (this.transparent_) {
                return PlotUtil.concatLines(new String[]{"<p>Paints markers in a transparent version of their", "selected colour.", "The degree of transparency is determined by", "how many points are plotted on top of each other", "and by the opaque limit.", "The opaque limit fixes how many points must be", "plotted on top of each other to completely obscure", "the background.  This is set to a fixed value,", "so a transparent level that works well for a crowded", "region (or low magnification) may not work so well", "for a sparse region (or when zoomed in).", "</p>"});
            }
            return "<p>Paints markers in a single fixed colour.</p>";
        }

        @Override
        public ConfigKey[] getConfigKeys() {
            ArrayList<ConfigKey<Serializable>> keyList = new ArrayList<ConfigKey<Serializable>>();
            keyList.add(StyleKeys.COLOR);
            if (this.transparent_) {
                keyList.add(StyleKeys.OPAQUE);
            }
            return keyList.toArray(new ConfigKey[0]);
        }

        @Override
        public Stamper createStamper(ConfigMap config) {
            Color color;
            Color baseColor = config.get(StyleKeys.COLOR);
            if (this.transparent_) {
                int opaque = config.get(StyleKeys.OPAQUE).intValue();
                float[] rgba = baseColor.getRGBColorComponents(new float[4]);
                rgba[3] = 1.0f / (float)opaque;
                color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
            } else {
                color = baseColor;
            }
            return new FlatStamper(color);
        }

        @Override
        public PlotLayer createLayer(ShapePlotter plotter, ShapeForm form, DataGeom geom, DataSpec dataSpec, Outliner outliner, Stamper stamper) {
            final Color color = ((FlatStamper)stamper).color_;
            ShapeStyle style = new ShapeStyle(outliner, stamper);
            LayerOpt opt = new LayerOpt(color, color.getAlpha() == 255);
            return new ShapePlotLayer(plotter, geom, dataSpec, style, opt, outliner){

                @Override
                public Drawing createDrawing(DrawSpec drawSpec) {
                    return drawSpec.paperType_.isBitmap() && !FlatMode.this.transparent_ ? new HybridFlatDrawing(drawSpec, color, FlatMode.this.binThresh_) : new PaintFlatDrawing(drawSpec, color);
                }
            };
        }

        private static class HybridFlatDrawing
        implements Drawing {
            private final DrawSpec drawSpec_;
            private final int binThreshold_;
            private final PaintFlatDrawing paintDrawing_;
            private final BinFlatDrawing binDrawing_;
            private static final Object PAINT_PLAN = null;

            HybridFlatDrawing(DrawSpec drawSpec, Color color, int binThreshold) {
                this.drawSpec_ = drawSpec;
                this.binThreshold_ = binThreshold;
                this.paintDrawing_ = new PaintFlatDrawing(drawSpec, color);
                this.binDrawing_ = new BinFlatDrawing(drawSpec, color);
            }

            @Override
            public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                assert (this.paintDrawing_.calculatePlan(knownPlans, dataStore) == PAINT_PLAN);
                return this.binDrawing_.calculatePlan(knownPlans, dataStore);
            }

            @Override
            public void paintData(Object binPlan, Paper paper, DataStore dataStore) {
                long npoint = this.drawSpec_.outliner_.getPointCount(binPlan);
                if (npoint < (long)this.binThreshold_) {
                    this.paintDrawing_.paintData(PAINT_PLAN, paper, dataStore);
                } else {
                    this.binDrawing_.paintData(binPlan, paper, dataStore);
                }
            }

            @Override
            public ReportMap getReport(Object plan) {
                return null;
            }
        }

        private static class BinFlatDrawing
        extends BinShapeDrawing {
            private final Color color_;

            BinFlatDrawing(DrawSpec drawSpec, Color color) {
                super(drawSpec);
                this.color_ = color;
            }

            @Override
            PixelImage createPixelImage(Object plan) {
                int[] counts = (int[])this.getBinCounts(plan).clone();
                int n = counts.length;
                for (int i = 0; i < n; ++i) {
                    counts[i] = Math.min(counts[i], 1);
                }
                IndexColorModel colorModel = PixelImage.createMaskColorModel(this.color_);
                Dimension size = this.drawSpec_.surface_.getPlotBounds().getSize();
                return new PixelImage(size, counts, colorModel);
            }
        }

        private static class PaintFlatDrawing
        extends UnplannedDrawing {
            private final DrawSpec drawSpec_;
            private final Color color_;

            PaintFlatDrawing(DrawSpec drawSpec, Color color) {
                this.drawSpec_ = drawSpec;
                this.color_ = color;
            }

            @Override
            public void paintData(Paper paper, DataStore dataStore) {
                ShapePainter painter = this.drawSpec_.painter_;
                TupleSequence tseq = dataStore.getTupleSequence(this.drawSpec_.dataSpec_);
                while (tseq.next()) {
                    painter.paintPoint(tseq, this.color_, paper);
                }
            }
        }
    }
}

