/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.func.Tilings;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinResultColumnData;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.SkyPixer;
import uk.ac.starlink.ttools.plot2.layer.SkyTileRenderer;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class SkyDensityPlotter
implements Plotter<SkyDenseStyle> {
    private final boolean transparent_;
    private final CoordGroup coordGrp_;
    private final FloatingCoord weightCoord_;
    private final boolean reportAuxKeys_;
    public static final ReportKey<Double> TILESIZE_REPKEY = ReportKey.createDoubleKey(new ReportMeta("tile_sqdeg", "Tile size/sq.deg"), true);
    private static final ReportKey<Integer> ABSLEVEL_REPKEY = ReportKey.createIntegerKey(new ReportMeta("abs_level", "Absolute HEALPix Level"), false);
    private static final ReportKey<Integer> RELLEVEL_REPKEY = ReportKey.createIntegerKey(new ReportMeta("rel_level", "Relative HEALPix Level"), false);
    private static final ReportKey<StarTable> HPXTABLE_REPKEY = ReportKey.createTableKey(new ReportMeta("hpx_map", "HEALPix Map"), true);
    private static final AuxScale SCALE = AuxScale.COLOR;
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.WEIGHT_COORD;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
    private static final ConfigKey<Integer> LEVEL_KEY = IntegerConfigKey.createSpinnerPairKey(new ConfigMeta("level", "HEALPix Level").setStringUsage("<-rel-level|+abs-level>").setShortDescription("HEALPix level, negative for relative").setXmlDescription(new String[]{"<p>Determines the HEALPix level of pixels which are averaged", "over to calculate density.", "</p>", "<p>If the supplied value is a non-negative integer,", "it gives the absolute level to use;", "at level 0 there are 12 pixels on the sky, and", "the count multiplies by 4 for each increment.", "</p>", "<p>If the value is negative, it represents a relative level;", "it is approximately the (negative) number of screen pixels", "along one side of a HEALPix sky pixel.", "In this case the actual HEALPix level will depend on", "the current zoom.", "</p>"}), -3, 29, -8, "Abs", "Rel", ABSLEVEL_REPKEY, RELLEVEL_REPKEY);
    private static final ConfigKey<Double> TRANSPARENCY_KEY = StyleKeys.TRANSPARENCY;

    public SkyDensityPlotter(boolean transparent, boolean hasWeight) {
        Coord[] coordArray;
        this.transparent_ = transparent;
        FloatingCoord floatingCoord = this.weightCoord_ = hasWeight ? FloatingCoord.WEIGHT_COORD : null;
        if (this.weightCoord_ == null) {
            coordArray = new Coord[]{};
        } else {
            Coord[] coordArray2 = new Coord[1];
            coordArray = coordArray2;
            coordArray2[0] = this.weightCoord_;
        }
        Coord[] extraCoords = coordArray;
        this.coordGrp_ = CoordGroup.createCoordGroup(1, extraCoords);
        this.reportAuxKeys_ = false;
    }

    @Override
    public String getPlotterName() {
        return "SkyDensity";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_SKYDENSITY;
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.coordGrp_;
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer().append("<p>Plots a density map on the sky.\n").append("The grid on which the values are drawn uses\n").append("the HEALPix tesselation,\n").append("with a configurable resolution.\n").append("You can optionally use a weighting for the points,\n").append("and you can configure how the points are combined\n").append("to produce the output pixel values.\n").append("</p>\n");
        sbuf.append("<p>");
        if (this.reportAuxKeys_) {
            sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
        } else {
            sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Double>> keyList = new ArrayList<ConfigKey<Double>>();
        keyList.add(LEVEL_KEY);
        if (this.weightCoord_ != null) {
            keyList.add(StyleKeys.COMBINER);
        }
        if (this.reportAuxKeys_) {
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
        }
        if (this.transparent_) {
            keyList.add(TRANSPARENCY_KEY);
        }
        return keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public SkyDenseStyle createStyle(ConfigMap config) {
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        int level = config.get(LEVEL_KEY);
        Scaling scaling = ramp.getScaling();
        float scaleAlpha = 1.0f - config.get(TRANSPARENCY_KEY).floatValue();
        Shader shader = Shaders.fade(ramp.getShader(), scaleAlpha);
        Combiner combiner = this.weightCoord_ == null ? Combiner.COUNT : config.get(StyleKeys.COMBINER);
        return new SkyDenseStyle(level, scaling, shader, combiner);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, SkyDenseStyle style) {
        return new SkyDensityLayer((SkyDataGeom)geom, dataSpec, style);
    }

    public static int getPixelLevel(SkySurface surface) {
        Point p = surface.getSkyCenter();
        double[] p1 = surface.graphicsToData(new Point(p.x - 1, p.y - 1), null);
        double[] p2 = surface.graphicsToData(new Point(p.x + 1, p.y + 1), null);
        double pixTheta = SkyDensityPlotter.vectorSeparation(p1, p2) / Math.sqrt(8.0);
        return Tilings.healpixK(Math.toDegrees(pixTheta));
    }

    public static double vectorSeparation(double[] p1, double[] p2) {
        double modCross = Matrices.mod(Matrices.cross(p1, p2));
        double dot = Matrices.dot(p1, p2);
        return modCross == 0.0 && dot == 0.0 ? 0.0 : Math.atan2(modCross, dot);
    }

    private static class SkyDensityPlan {
        final int level_;
        final Combiner combiner_;
        final BinList.Result binResult_;
        final DataSpec dataSpec_;
        final SkyDataGeom geom_;
        int pixelLevel_;

        SkyDensityPlan(int level, Combiner combiner, BinList.Result binResult, DataSpec dataSpec, SkyDataGeom geom) {
            this.level_ = level;
            this.combiner_ = combiner;
            this.binResult_ = binResult;
            this.dataSpec_ = dataSpec;
            this.geom_ = geom;
            this.pixelLevel_ = Integer.MIN_VALUE;
        }

        public boolean matches(int level, Combiner combiner, DataSpec dataSpec, SkyDataGeom geom) {
            return this.level_ == level && this.combiner_.equals(combiner) && this.dataSpec_.equals(dataSpec) && this.geom_.equals(geom);
        }

        public void extendVisibleRange(Range range, SkySurface surface) {
            Rectangle bounds = surface.getPlotBounds();
            int nx = bounds.width;
            int ny = bounds.height;
            Gridder gridder = new Gridder(nx, ny);
            int npix = gridder.getLength();
            Point2D.Double point = new Point2D.Double();
            double x0 = (double)bounds.x + 0.5;
            double y0 = (double)bounds.y + 0.5;
            SkyPixer skyPixer = new SkyPixer(this.level_);
            for (int ip = 0; ip < npix; ++ip) {
                point.x = x0 + (double)gridder.getX(ip);
                point.y = y0 + (double)gridder.getY(ip);
                double[] dpos = surface.graphicsToData(point, null);
                if (dpos == null) continue;
                double dval = this.binResult_.getBinValue(skyPixer.getIndex(dpos));
                range.submit(dval);
            }
        }
    }

    private class SkyDensityLayer
    extends AbstractPlotLayer {
        private final SkyDenseStyle dstyle_;
        private final SkyDataGeom geom_;
        private final int icWeight_;

        SkyDensityLayer(SkyDataGeom geom, DataSpec dataSpec, SkyDenseStyle style) {
            super(SkyDensityPlotter.this, geom, dataSpec, style, style.isOpaque() ? LayerOpt.OPAQUE : LayerOpt.NO_SPECIAL);
            this.dstyle_ = style;
            this.geom_ = geom;
            int n = this.icWeight_ = SkyDensityPlotter.this.weightCoord_ == null ? -1 : SkyDensityPlotter.this.coordGrp_.getExtraCoordIndex(0, geom);
            assert (SkyDensityPlotter.this.weightCoord_ == null || SkyDensityPlotter.this.weightCoord_ == dataSpec.getCoord(this.icWeight_));
        }

        @Override
        public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
            SkySurface ssurf = (SkySurface)surface;
            return new SkyDensityDrawing(ssurf, this.createTileRenderer(ssurf), auxRanges.get(SCALE), paperType);
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers() {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            map.put(SCALE, new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return SkyDensityLayer.this.icWeight_;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] knownPlans, Range range) {
                    SkySurface ssurf = (SkySurface)surface;
                    int level = SkyDensityLayer.this.getLevel(ssurf);
                    SkyDensityPlan splan = SkyDensityLayer.this.getSkyPlan(knownPlans, level, dataSpec);
                    if (splan != null) {
                        splan.extendVisibleRange(range, ssurf);
                    } else {
                        BinList.Result binResult = SkyDensityLayer.this.readBins(ssurf, dataSpec, dataStore).getResult();
                        SkyDensityLayer.this.createTileRenderer(ssurf).extendAuxRange(range, binResult);
                    }
                }
            });
            return map;
        }

        private SkyTileRenderer createTileRenderer(SkySurface surface) {
            return SkyTileRenderer.createRenderer(surface, Rotation.IDENTITY, this.getLevel(surface));
        }

        private int getLevel(SkySurface surface) {
            int pixLevel = SkyDensityPlotter.getPixelLevel(surface);
            return this.dstyle_.level_ >= 0 ? Math.min(this.dstyle_.level_, pixLevel) : Math.max(0, pixLevel + this.dstyle_.level_);
        }

        private SkyPixer createSkyPixer(SkySurface surface) {
            return new SkyPixer(this.getLevel(surface));
        }

        private BinList readBins(SkySurface surface, DataSpec dataSpec, DataStore dataStore) {
            SkyPixer skyPixer = this.createSkyPixer(surface);
            BinList binList = null;
            long npix = skyPixer.getPixelCount();
            Combiner combiner = this.dstyle_.combiner_;
            if (npix < 200000L) {
                binList = combiner.createArrayBinList((int)npix);
            }
            if (binList == null) {
                binList = combiner.createHashBinList(npix);
            }
            assert (binList != null);
            TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
            int icPos = SkyDensityPlotter.this.coordGrp_.getPosCoordIndex(0, this.geom_);
            double[] v3 = new double[3];
            if (this.icWeight_ < 0 || dataSpec.isCoordBlank(this.icWeight_)) {
                while (tseq.next()) {
                    if (!this.geom_.readDataPos(tseq, icPos, v3)) continue;
                    binList.submitToBin(skyPixer.getIndex(v3), 1.0);
                }
            } else {
                while (tseq.next()) {
                    double w;
                    if (!this.geom_.readDataPos(tseq, icPos, v3) || Double.isNaN(w = SkyDensityPlotter.this.weightCoord_.readDoubleCoord(tseq, this.icWeight_))) continue;
                    binList.submitToBin(skyPixer.getIndex(v3), w);
                }
            }
            return binList;
        }

        private SkyDensityPlan getSkyPlan(Object[] knownPlans, int level, DataSpec dataSpec) {
            Combiner combiner = this.dstyle_.combiner_;
            for (Object plan : knownPlans) {
                SkyDensityPlan skyPlan;
                if (!(plan instanceof SkyDensityPlan) || !(skyPlan = (SkyDensityPlan)plan).matches(level, combiner, dataSpec, this.geom_)) continue;
                return skyPlan;
            }
            return null;
        }

        private StarTable createExportTable(SkyDensityPlan splan) {
            DefaultValueInfo weightInfo;
            int level = splan.level_;
            if (level > 13) {
                return null;
            }
            SkyPixer skyPixer = new SkyPixer(level);
            DataSpec dataSpec = splan.dataSpec_;
            Combiner combiner = splan.combiner_;
            BinList.Result binResult = splan.binResult_;
            String indexDescrip = "HEALPix index, level " + level + ", " + (skyPixer.isNested() ? "Nested" : "Ring") + " scheme";
            ColumnInfo indexInfo = new ColumnInfo("hpx" + level, Integer.class, indexDescrip);
            ColumnData indexCol = new ColumnData(indexInfo){

                public Object readValue(long irow) {
                    return new Integer((int)irow);
                }
            };
            if (this.icWeight_ < 0 || dataSpec.isCoordBlank(this.icWeight_)) {
                weightInfo = null;
            } else {
                ValueInfo[] winfos = dataSpec.getUserCoordInfos(this.icWeight_);
                ValueInfo valueInfo = weightInfo = winfos != null && winfos.length == 1 ? winfos[0] : null;
            }
            if (weightInfo == null) {
                weightInfo = new DefaultValueInfo("data", Double.class);
            }
            ValueInfo dataInfo = combiner.createCombinedInfo((ValueInfo)weightInfo);
            ColumnData dataCol = BinResultColumnData.createInstance(dataInfo, binResult);
            long nrow = skyPixer.getPixelCount();
            assert ((long)((int)nrow) == nrow);
            ColumnStarTable table = ColumnStarTable.makeTableWithRows((long)((int)nrow));
            table.addColumn(indexCol);
            table.addColumn(dataCol);
            return table;
        }

        private class SkyDensityDrawing
        implements Drawing {
            private final SkySurface surface_;
            private final SkyTileRenderer renderer_;
            private final Range auxRange_;
            private final PaperType paperType_;
            private final int level_;
            private final int pixelLevel_;

            SkyDensityDrawing(SkySurface surface, SkyTileRenderer renderer, Range auxRange, PaperType paperType) {
                this.surface_ = surface;
                this.renderer_ = renderer;
                this.auxRange_ = auxRange;
                this.paperType_ = paperType;
                this.level_ = SkyDensityLayer.this.getLevel(surface);
                this.pixelLevel_ = SkyDensityPlotter.getPixelLevel(surface);
            }

            @Override
            public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                SkyDensityPlan plan = this.calculateBasicPlan(knownPlans, dataStore);
                plan.pixelLevel_ = this.pixelLevel_;
                return plan;
            }

            private SkyDensityPlan calculateBasicPlan(Object[] knownPlans, DataStore dataStore) {
                DataSpec dataSpec = SkyDensityLayer.this.getDataSpec();
                Combiner combiner = SkyDensityLayer.this.dstyle_.combiner_;
                SkyDensityPlan knownPlan = SkyDensityLayer.this.getSkyPlan(knownPlans, this.level_, dataSpec);
                if (knownPlan != null) {
                    return knownPlan;
                }
                BinList.Result binResult = SkyDensityLayer.this.readBins(this.surface_, dataSpec, dataStore).getResult().compact();
                return new SkyDensityPlan(this.level_, combiner, binResult, dataSpec, SkyDensityLayer.this.geom_);
            }

            @Override
            public void paintData(Object plan, Paper paper, DataStore dataStore) {
                final BinList.Result binResult = ((SkyDensityPlan)plan).binResult_;
                final Scaler scaler = Scaling.createRangeScaler(SkyDensityLayer.this.dstyle_.scaling_, this.auxRange_);
                final Shader shader = SkyDensityLayer.this.dstyle_.shader_;
                this.paperType_.placeDecal(paper, new Decal(){

                    @Override
                    public void paintDecal(Graphics g) {
                        SkyDensityDrawing.this.renderer_.renderBins(g, binResult, shader, scaler);
                    }

                    @Override
                    public boolean isOpaque() {
                        return SkyDensityLayer.this.dstyle_.isOpaque();
                    }
                });
            }

            @Override
            public ReportMap getReport(Object plan) {
                ReportMap map = new ReportMap();
                if (plan instanceof SkyDensityPlan) {
                    SkyDensityPlan splan = (SkyDensityPlan)plan;
                    int absLevel = splan.level_;
                    int relLevel = absLevel - splan.pixelLevel_;
                    double tileSize = Tilings.healpixSqdeg(absLevel);
                    map.put(ABSLEVEL_REPKEY, new Integer(absLevel));
                    map.put(RELLEVEL_REPKEY, new Integer(relLevel));
                    map.put(TILESIZE_REPKEY, new Double(tileSize));
                    map.put(HPXTABLE_REPKEY, SkyDensityLayer.this.createExportTable(splan));
                }
                return map;
            }
        }
    }

    public static class SkyDenseStyle
    implements Style {
        private final int level_;
        private final Scaling scaling_;
        private final Shader shader_;
        private final Combiner combiner_;

        public SkyDenseStyle(int level, Scaling scaling, Shader shader, Combiner combiner) {
            this.level_ = level;
            this.scaling_ = scaling;
            this.shader_ = shader;
            this.combiner_ = combiner;
        }

        boolean isOpaque() {
            return !Shaders.isTransparent(this.shader_);
        }

        @Override
        public Icon getLegendIcon() {
            return Shaders.createShaderIcon(this.shader_, null, true, 16, 8, 2, 2);
        }

        public int hashCode() {
            int code = 23443;
            code = 23 * code + this.level_;
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof SkyDenseStyle) {
                SkyDenseStyle other = (SkyDenseStyle)o;
                return this.level_ == other.level_ && this.scaling_.equals(other.scaling_) && this.shader_.equals(other.shader_) && this.combiner_.equals(other.combiner_);
            }
            return false;
        }
    }
}

