/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.SkySysConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.geom.GridLiner;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabellers;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class SkyGridPlotter
extends AbstractPlotter<GridStyle> {
    public static final ConfigKey<Color> COLOR_KEY = StyleKeys.GRID_COLOR;
    public static final ConfigKey<Double> TRANSPARENCY_KEY = StyleKeys.TRANSPARENCY;
    public static final ConfigKey<Double> CROWD_KEY = SkySurfaceFactory.CROWD_KEY;
    public static final ConfigKey<SkySys> GRIDSYS_KEY = new SkySysConfigKey(new ConfigMeta("gridsys", "Sky System").setShortDescription("Sky coordinate system for grid layer").setXmlDescription(new String[]{"<p>The sky coordinate system used for the additional", "grid axes.", "</p>"}), false).setOptionUsage().addOptionsXml();
    public static final ConfigKey<SkyAxisLabeller> LABELLER_KEY = new OptionConfigKey<SkyAxisLabeller>(new ConfigMeta("labelpos", "Label Position").setShortDescription("Position of grid axis labels").setXmlDescription(new String[]{"<p>Controls how and whether the numeric annotations", "of the lon/lat axes are displayed.", "</p>"}), SkyAxisLabeller.class, new SkyAxisLabeller[]{SkyAxisLabellers.INTERNAL, SkyAxisLabellers.NONE}, SkyAxisLabellers.INTERNAL, true){

        @Override
        public String valueToString(SkyAxisLabeller labeller) {
            return labeller.getLabellerName();
        }

        @Override
        public String getXmlDescription(SkyAxisLabeller labeller) {
            return labeller.getLabellerDescription();
        }
    }.setOptionUsage().addOptionsXml();

    public SkyGridPlotter() {
        super("SkyGrid", ResourceIcon.PLOT_SKYGRID);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots an additional axis grid on the celestial sphere.", "This can be overlaid on the default sky axis grid", "so that axes for multiple sky coordinate systems", "are simultaneously visible.", "</p>", "<p>Note that some of the configuration items for this plotter,", "such as grid line antialiasing and the decimal/sexagesimal flag,", "are inherited from the values set for the main sky plot grid.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        return new ConfigKey[]{GRIDSYS_KEY, COLOR_KEY, TRANSPARENCY_KEY, LABELLER_KEY, CROWD_KEY};
    }

    @Override
    public GridStyle createStyle(ConfigMap config) {
        SkySys viewsys = config.get(SkySurfaceFactory.VIEWSYS_KEY);
        Captioner captioner = StyleKeys.CAPTIONER.createValue(config);
        boolean antialias = config.get(StyleKeys.GRID_ANTIALIAS);
        boolean sexagesimal = config.get(SkySurfaceFactory.SEX_KEY);
        SkySys gridsys = config.get(GRIDSYS_KEY);
        Color color = StyleKeys.getAlphaColor(config, COLOR_KEY, TRANSPARENCY_KEY);
        SkyAxisLabeller labeller = config.get(LABELLER_KEY);
        double crowd = config.get(CROWD_KEY);
        Rotation rotation = Rotation.createRotation(gridsys, viewsys);
        return new GridStyle(rotation, color, labeller, captioner, sexagesimal, crowd, antialias);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, final GridStyle style) {
        final LayerOpt layerOpt = style.getLayerOpt();
        return new AbstractPlotLayer(this, geom, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surf, Map<AuxScale, Range> auxRanges, final PaperType paperType) {
                final SkySurface skySurf = (SkySurface)surf;
                return new UnplannedDrawing(){

                    @Override
                    protected void paintData(Paper paper, DataStore dataStore) {
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                SkyGridPlotter.this.paintGrid(skySurf, style, g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return layerOpt.isOpaque();
                            }
                        });
                    }
                };
            }
        };
    }

    private void paintGrid(SkySurface surf, GridStyle style, Graphics g) {
        GridLiner gl = surf.createGridder(style.rotation_, style.sexagesimal_, style.crowd_);
        if (gl == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(style.color_);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, style.antialias_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        for (double[][] line : gl.getLines()) {
            int nseg = line.length;
            GeneralPath path = new GeneralPath(1, nseg);
            double[] seg0 = line[0];
            path.moveTo((float)seg0[0], (float)seg0[1]);
            for (double[] seg : line) {
                path.lineTo((float)seg[0], (float)seg[1]);
            }
            g2.draw(path);
        }
        style.labeller_.createAxisAnnotation(gl, style.captioner_).drawLabels(g2);
    }

    public static class GridStyle
    implements Style {
        private final Rotation rotation_;
        private final Color color_;
        private final SkyAxisLabeller labeller_;
        private final Captioner captioner_;
        private final boolean sexagesimal_;
        private final double crowd_;
        private final boolean antialias_;

        public GridStyle(Rotation rotation, Color color, SkyAxisLabeller labeller, Captioner captioner, boolean sexagesimal, double crowd, boolean antialias) {
            this.rotation_ = rotation;
            this.color_ = color;
            this.labeller_ = labeller;
            this.captioner_ = captioner;
            this.sexagesimal_ = sexagesimal;
            this.crowd_ = crowd;
            this.antialias_ = antialias;
        }

        @Override
        public Icon getLegendIcon() {
            return ResourceIcon.PLOT_SKYGRID;
        }

        private LayerOpt getLayerOpt() {
            boolean isOpaque = !this.antialias_ && this.color_.getAlpha() == 255;
            return new LayerOpt(this.color_, isOpaque);
        }

        public int hashCode() {
            int code = 23225289;
            code = 23 * code + this.rotation_.hashCode();
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + this.labeller_.hashCode();
            code = 23 * code + this.captioner_.hashCode();
            code = 23 * code + (this.sexagesimal_ ? 11 : 13);
            code = 23 * code + Float.floatToIntBits((float)this.crowd_);
            code = 23 * code + (this.antialias_ ? 17 : 29);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof GridStyle) {
                GridStyle other = (GridStyle)o;
                return this.rotation_.equals(other.rotation_) && this.color_.equals(other.color_) && this.labeller_.equals(other.labeller_) && this.captioner_.equals(other.captioner_) && this.sexagesimal_ == other.sexagesimal_ && this.crowd_ == other.crowd_ && this.antialias_ == other.antialias_;
            }
            return false;
        }
    }
}

