/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import gov.fnal.eag.healpix.PixTools;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.vecmath.Vector3d;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;

public class SkySurfaceTiler {
    private final SkySurface surf_;
    private final long nside_;
    private final Rotation rotation_;
    private final PixTools pixTools_;
    private final Set<Long> visiblePixels_;

    public SkySurfaceTiler(SkySurface surf, Rotation rotation, int hpxOrder) {
        this.surf_ = surf;
        this.nside_ = 1L << hpxOrder;
        this.rotation_ = rotation;
        this.pixTools_ = new PixTools();
        Set<Long> visPixels = SkySurfaceTiler.calculateVisiblePixels(surf, rotation, hpxOrder, PolygonTiler.PIXTOOLS_DISC);
        this.visiblePixels_ = Collections.unmodifiableSet(visPixels);
    }

    public Set<Long> visiblePixels() {
        return this.visiblePixels_;
    }

    public boolean isVisible(long hpxIndex) {
        return this.visiblePixels_.contains(new Long(hpxIndex));
    }

    public Polygon getTileShape(long hpxIndex) {
        Vector3d v3 = this.pixTools_.pix2vect_nest(this.nside_, hpxIndex);
        double[] dpos0 = new double[]{v3.x, v3.y, v3.z};
        Point2D.Double gpos0 = new Point2D.Double();
        this.rotation_.rotate(dpos0);
        if (this.surf_.dataToGraphics(dpos0, false, gpos0)) {
            double[][] vertices = this.pixTools_.pix2vertex_nest(this.nside_, hpxIndex);
            int[] gxs = new int[4];
            int[] gys = new int[4];
            double[] dpos1 = new double[3];
            Point2D.Double gpos1 = new Point2D.Double();
            int np = 0;
            int nInvisible = 0;
            for (int i = 0; i < 4; ++i) {
                dpos1[0] = vertices[0][i];
                dpos1[1] = vertices[1][i];
                dpos1[2] = vertices[2][i];
                this.rotation_.rotate(dpos1);
                if (this.surf_.dataToGraphicsOffset(dpos0, gpos0, dpos1, false, gpos1)) {
                    assert (!Double.isNaN(gpos1.x));
                    assert (!Double.isNaN(gpos1.y));
                    gxs[np] = PlotUtil.ifloor(gpos1.x);
                    gys[np] = PlotUtil.ifloor(gpos1.y);
                    ++np;
                    continue;
                }
                if (++nInvisible <= 1) continue;
                return null;
            }
            assert (np >= 1);
            return new Polygon(gxs, gys, np);
        }
        return null;
    }

    private static Set<Long> calculateVisiblePixels(SkySurface surf, Rotation rotation, int order, PolygonTiler ptiler) {
        List<double[]> vertexList = SkySurfaceTiler.createSurfacePolygon(surf, rotation);
        Set<Long> indexSet = vertexList == null ? null : ptiler.queryPolygon(order, vertexList);
        return indexSet != null ? indexSet : SkySurfaceTiler.createIntegerSet(12L << 2 * order);
    }

    private static List<double[]> createSurfacePolygon(SkySurface surf, Rotation rotation) {
        Rectangle bounds = surf.getPlotBounds();
        Rotation unrot = rotation.invert();
        int nq = 4;
        double nq1 = 1.0 / (double)nq;
        ArrayList<double[]> vertexList = new ArrayList<double[]>(4 * nq + 1);
        for (int is = 0; is < 4; ++is) {
            for (int iq = 0; iq < nq; ++iq) {
                Point2D.Double gpos = SkySurfaceTiler.traceEdge(bounds, is, (double)iq * nq1);
                double[] dpos = surf.graphicsToData(gpos, null);
                if (dpos == null) {
                    return null;
                }
                unrot.rotate(dpos);
                vertexList.add(dpos);
            }
        }
        vertexList.add((double[])vertexList.get(0));
        return vertexList;
    }

    private static Point2D.Double traceEdge(Rectangle bounds, int iside, double fraction) {
        double gy;
        double gx;
        if (iside == 0) {
            gx = (double)bounds.x + (double)bounds.width * fraction;
            gy = bounds.y;
        } else if (iside == 1) {
            gx = bounds.x + bounds.width;
            gy = (double)bounds.y + (double)bounds.height * fraction;
        } else if (iside == 2) {
            gx = (double)bounds.x + (double)bounds.width * (1.0 - fraction);
            gy = bounds.y + bounds.height;
        } else if (iside == 3) {
            gx = bounds.x;
            gy = (double)bounds.y + (double)bounds.height * (1.0 - fraction);
        } else {
            throw new IllegalArgumentException();
        }
        return new Point2D.Double(gx, gy);
    }

    private static Set<Long> createIntegerSet(final long leng) {
        return new AbstractSet<Long>(){

            @Override
            public int size() {
                return (int)leng;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Number) {
                    long l = ((Number)o).longValue();
                    return l >= 0L && l < leng;
                }
                return false;
            }

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    private long lx_;

                    @Override
                    public boolean hasNext() {
                        return this.lx_ < leng;
                    }

                    @Override
                    public Long next() {
                        if (this.hasNext()) {
                            return new Long(this.lx_++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static abstract class PolygonTiler {
        public static final PolygonTiler PIXTOOLS_POLY = new PolygonTiler(){
            private static final long NEST = 1L;
            private static final long INCLUSIVE = 1L;

            @Override
            Set<Long> queryPolygon(int order, List<double[]> vertices) {
                ArrayList indexList;
                ArrayList<Vector3d> v3list = new ArrayList<Vector3d>(vertices.size());
                for (double[] p : vertices) {
                    v3list.add(new Vector3d(p[0], p[1], p[2]));
                }
                long nside = 1L << order;
                try {
                    indexList = new PixTools().query_polygon(nside, v3list, 1L, 1L);
                }
                catch (Exception e) {
                    return null;
                }
                return new TreeSet<Long>(indexList);
            }
        };
        public static final PolygonTiler PIXTOOLS_DISC = new PolygonTiler(){
            private static final int NEST = 1;
            private static final int INCLUSIVE = 1;

            @Override
            Set<Long> queryPolygon(int order, List<double[]> vertices) {
                ArrayList indexList;
                double[] sv = new double[3];
                for (double[] dpos : vertices) {
                    for (int i = 0; i < 3; ++i) {
                        int n = i;
                        sv[n] = sv[n] + dpos[i];
                    }
                }
                double fv = 1.0 / Math.sqrt(sv[0] * sv[0] + sv[1] * sv[1] + sv[2] * sv[2]);
                double[] c0 = new double[]{sv[0] * fv, sv[1] * fv, sv[2] * fv};
                double maxTheta = 0.0;
                for (double[] dpos : vertices) {
                    double dotp = c0[0] * dpos[0] + c0[1] * dpos[1] + c0[2] * dpos[2];
                    if (dotp < 0.0) {
                        return null;
                    }
                    maxTheta = Math.max(maxTheta, Math.acos(dotp));
                }
                try {
                    long nside = 1L << order;
                    Vector3d cv = new Vector3d(c0[0], c0[1], c0[2]);
                    indexList = new PixTools().query_disc(nside, cv, maxTheta, 1, 1);
                }
                catch (Exception e) {
                    return null;
                }
                return new TreeSet<Long>(indexList);
            }
        };

        private PolygonTiler() {
        }

        abstract Set<Long> queryPolygon(int var1, List<double[]> var2);
    }
}

