/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class SpectrogramPlotter
implements Plotter<SpectroStyle> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord xExtentCoord_;
    private final FloatingArrayCoord spectrumCoord_;
    private final SliceDataGeom spectroDataGeom_;
    private final CoordGroup spectroCoordGrp_;
    private final int icX_;
    private final int icExtent_;
    private final int icSpectrum_;
    private final boolean reportAuxKeys_;
    private static final AuxScale SPECTRO_SCALE = AuxScale.COLOR;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
    private static final ConfigKey<Color> NULLCOLOR_KEY = StyleKeys.AUX_NULLCOLOR;
    private static final ChannelGrid DEFAULT_CHANGRID = new AssumedChannelGrid();
    private static final int MAX_SAMPLE = 100;

    public SpectrogramPlotter(FloatingCoord xCoord) {
        this.xCoord_ = xCoord;
        this.spectrumCoord_ = FloatingArrayCoord.createCoord(new InputMeta("spectrum", "Spectrum").setShortDescription("Array of spectrum channel values").setXmlDescription(new String[]{"<p>Provides an array of spectral samples at each", "data point.", "The value must be a numeric array", "(e.g. the value of an array-valued column).", "</p>"}).setValueUsage("array"), true);
        InputMeta xMeta = xCoord.getInput().getMeta();
        String xName = xMeta.getLongName();
        this.xExtentCoord_ = FloatingCoord.createCoord(new InputMeta(xMeta.getShortName() + "width", xMeta.getLongName() + " Width").setShortDescription(xName + " extent of spectrum").setXmlDescription(new String[]{"<p>Range on the " + xName + " axis", "over which the spectrum is plotted.", "If no value is supplied, an attempt will be made", "to determine it automatically by looking at the", "spacing of the " + xName + " coordinates", "plotted in the spectrogram.", "</p>"}), false);
        this.spectroDataGeom_ = new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "Time");
        Coord[] coords = new Coord[]{this.xCoord_, this.spectrumCoord_, this.xExtentCoord_};
        boolean[] rangeFlags = new boolean[]{true, true, false};
        this.spectroCoordGrp_ = CoordGroup.createPartialCoordGroup(coords, rangeFlags);
        this.icX_ = this.spectroCoordGrp_.getExtraCoordIndex(0, null);
        this.icSpectrum_ = this.spectroCoordGrp_.getExtraCoordIndex(1, null);
        this.icExtent_ = this.spectroCoordGrp_.getExtraCoordIndex(2, null);
        this.reportAuxKeys_ = false;
    }

    public int getSpectrumCoordIndex() {
        return this.icSpectrum_;
    }

    public int getExtentCoordIndex() {
        return this.icExtent_;
    }

    @Override
    public String getPlotterName() {
        return "Spectrogram";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.PLOT_SPECTRO;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer().append("<p>Plots spectrograms.\n").append("A spectrogram is a sequence of spectra ").append("plotted as vertical 1-d images, each one\n").append("plotted at a different horizontal coordinate.\n").append("</p>\n").append("<p>This specialised layer is only available for\n").append("<ref id='plot2time'><code>time</code></ref> plots.\n").append("</p>\n");
        sbuf.append("<p>");
        if (this.reportAuxKeys_) {
            sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
        } else {
            sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.spectroCoordGrp_;
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Color>> keyList = new ArrayList<ConfigKey<Color>>();
        if (this.reportAuxKeys_) {
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
            keyList.add(NULLCOLOR_KEY);
        }
        return keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public SpectroStyle createStyle(ConfigMap config) {
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        Shader shader = ramp.getShader();
        Scaling scaling = ramp.getScaling();
        Color nullColor = config.get(NULLCOLOR_KEY);
        ChannelGrid grid = DEFAULT_CHANGRID;
        return new SpectroStyle(shader, scaling, nullColor, grid);
    }

    @Override
    public boolean hasReports() {
        return false;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, final DataSpec dataSpec, final SpectroStyle style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        LayerOpt layerOpt = LayerOpt.OPAQUE;
        return new AbstractPlotLayer(this, this.spectroDataGeom_, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(final Surface surface, Map<AuxScale, Range> auxRanges, final PaperType paperType) {
                final Range spectroRange = auxRanges.get(SPECTRO_SCALE);
                return new UnplannedDrawing(){

                    @Override
                    protected void paintData(Paper paper, final DataStore dataStore) {
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                SpectrogramPlotter.this.paintSpectrogram(surface, dataStore, dataSpec, style, spectroRange, g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return true;
                            }
                        });
                    }
                };
            }

            @Override
            public Map<AuxScale, AuxReader> getAuxRangers() {
                HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
                map.put(SPECTRO_SCALE, new AuxReader(){

                    @Override
                    public int getCoordIndex() {
                        return SpectrogramPlotter.this.icSpectrum_;
                    }

                    @Override
                    public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Range range) {
                        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
                        while (tseq.next()) {
                            double[] spectrum = SpectrogramPlotter.this.spectrumCoord_.readArrayCoord(tseq, SpectrogramPlotter.this.icSpectrum_);
                            int nchan = spectrum.length;
                            for (int ic = 0; ic < nchan; ++ic) {
                                range.submit(spectrum[ic]);
                            }
                        }
                    }
                });
                return map;
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, boolean[] logFlags, DataStore dataStore) {
                Range specRange = ranges[1];
                ChannelGrid grid = style.grid_;
                int nchan = grid.getChannelCount();
                if (nchan < 0) {
                    TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
                    while (tseq.next()) {
                        int nc = SpectrogramPlotter.this.spectrumCoord_.getArrayCoordLength(tseq, SpectrogramPlotter.this.icSpectrum_);
                        nchan = Math.max(nc, nchan);
                    }
                }
                double[] bounds = new double[2];
                for (int ic = 0; ic < nchan; ++ic) {
                    grid.getChannelBounds(ic, bounds);
                    specRange.submit(bounds[0]);
                    specRange.submit(bounds[1]);
                }
            }
        };
    }

    private void paintSpectrogram(Surface surface, DataStore dataStore, DataSpec dataSpec, SpectroStyle style, Range spectroRange, Graphics g) {
        ChannelGrid grid = style.grid_;
        Shader shader = style.shader_;
        Scaler specScaler = Scaling.createRangeScaler(style.scaling_, spectroRange);
        Rectangle plotBounds = surface.getPlotBounds();
        Point gCorner0 = new Point(plotBounds.x, plotBounds.y);
        Point gCorner3 = new Point(plotBounds.x + plotBounds.width, plotBounds.y + plotBounds.height);
        double[] dCorner0 = surface.graphicsToData(gCorner0, null);
        double[] dCorner3 = surface.graphicsToData(gCorner3, null);
        double dxmin = Math.min(dCorner0[0], dCorner3[0]);
        double dxmax = Math.max(dCorner0[0], dCorner3[0]);
        double dymin = Math.min(dCorner0[1], dCorner3[1]);
        double dymax = Math.max(dCorner0[1], dCorner3[1]);
        TupleSequence tseq0 = dataStore.getTupleSequence(dataSpec);
        double[] diffs = new double[100];
        int idiff = 0;
        double lastx = Double.NaN;
        while (tseq0.next() && idiff < 100) {
            double x = this.xCoord_.readDoubleCoord(tseq0, this.icX_);
            if (Double.isNaN(x)) continue;
            if (!Double.isNaN(lastx)) {
                diffs[idiff++] = x - lastx;
            }
            lastx = x;
        }
        if (idiff == 0) {
            return;
        }
        Arrays.sort(diffs);
        double median = diffs[idiff / 2];
        double dfltExtent = Double.isNaN(median) ? 1.0 : median;
        int[] chanRange = grid.getChannelRange(dymin, dymax);
        int ichanLo = chanRange[0];
        int ichanHi = chanRange[1];
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        double[] dxs = new double[2];
        Point2D.Double gp0 = new Point2D.Double();
        Point2D.Double gp3 = new Point2D.Double();
        Point gp0i = new Point();
        Point gp3i = new Point();
        double[] dpos0 = new double[2];
        double[] dpos3 = new double[2];
        double[] chanBounds = new double[2];
        float[] rgba = new float[4];
        Color color0 = g.getColor();
        while (tseq.next()) {
            double x = this.xCoord_.readDoubleCoord(tseq, this.icX_);
            if (Double.isNaN(x)) continue;
            double xExtent = this.xExtentCoord_.readDoubleCoord(tseq, this.icExtent_);
            if (Double.isNaN(xExtent)) {
                xExtent = dfltExtent;
            }
            double xlo = x;
            double xhi = x + xExtent;
            if (!(xhi > dxmin) && !(xlo < dxmax)) continue;
            dpos0[0] = xlo;
            dpos3[0] = xhi;
            double[] chanVector = this.spectrumCoord_.readArrayCoord(tseq, this.icSpectrum_);
            int nchan = Math.min(chanVector.length, ichanHi);
            for (int ic = ichanLo; ic < nchan; ++ic) {
                int pheight;
                int py;
                int pwidth;
                int px;
                grid.getChannelBounds(ic, chanBounds);
                dpos0[1] = chanBounds[0];
                dpos3[1] = chanBounds[1];
                if (!surface.dataToGraphics(dpos0, false, gp0) || !surface.dataToGraphics(dpos3, false, gp3)) continue;
                PlotUtil.quantisePoint(gp0, gp0i);
                PlotUtil.quantisePoint(gp3, gp3i);
                double sval = specScaler.scaleValue(chanVector[ic]);
                shader.adjustRgba(rgba, (float)sval);
                g.setColor(new Color(rgba[0], rgba[1], rgba[2]));
                int x03 = gp3i.x - gp0i.x;
                int y03 = gp3i.y - gp0i.y;
                if (x03 > 0) {
                    px = gp0i.x;
                    pwidth = x03;
                } else {
                    px = gp3i.x;
                    pwidth = -x03;
                }
                if (y03 > 0) {
                    py = gp0i.y;
                    pheight = y03;
                } else {
                    py = gp3i.y;
                    pheight = -y03;
                }
                assert (pwidth >= 0);
                assert (pheight >= 0);
                g.fillRect(px, py, Math.max(pwidth, 1), Math.max(pheight, 1));
            }
        }
        g.setColor(color0);
    }

    public static class SpectroStyle
    implements Style {
        private final Shader shader_;
        private final Scaling scaling_;
        private final Color nullColor_;
        private final ChannelGrid grid_;

        public SpectroStyle(Shader shader, Scaling scaling, Color nullColor, ChannelGrid grid) {
            this.shader_ = shader;
            this.scaling_ = scaling;
            this.nullColor_ = nullColor;
            this.grid_ = grid;
        }

        @Override
        public Icon getLegendIcon() {
            return ResourceIcon.PLOT_SPECTRO;
        }

        public int hashCode() {
            int code = 9703;
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + PlotUtil.hashCode(this.nullColor_);
            code = 23 * code + PlotUtil.hashCode(this.grid_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof SpectroStyle) {
                SpectroStyle other = (SpectroStyle)o;
                return this.shader_.equals(other.shader_) && this.scaling_ == other.scaling_ && PlotUtil.equals(this.nullColor_, other.nullColor_) && PlotUtil.equals(this.grid_, other.grid_);
            }
            return false;
        }
    }

    private static class DataChannelGrid
    implements ChannelGrid {
        private final int count_;
        private final double[] lows_;
        private final double[] highs_;

        DataChannelGrid(int count, double[] lows, double[] highs) {
            this.count_ = count;
            this.lows_ = lows;
            this.highs_ = highs;
        }

        @Override
        public int getChannelCount() {
            return this.count_;
        }

        @Override
        public int[] getChannelRange(double ylo, double yhi) {
            int ilo = this.count_;
            int ihi = 0;
            for (int ic = 0; ic < this.count_; ++ic) {
                if (this.highs_[ic] > ylo) {
                    ilo = Math.min(ilo, ic);
                }
                if (!(this.lows_[ic] < yhi)) continue;
                ihi = Math.max(ihi, ic + 1);
            }
            return new int[]{ilo, ihi};
        }

        @Override
        public void getChannelBounds(int ichan, double[] bounds) {
            bounds[0] = this.lows_[ichan];
            bounds[1] = this.highs_[ichan];
        }

        public int hashCode() {
            int code = 5501;
            code = 23 * code + this.count_;
            code = 23 * code + Arrays.hashCode(this.lows_);
            code = 23 * code + Arrays.hashCode(this.highs_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof DataChannelGrid) {
                DataChannelGrid other = (DataChannelGrid)o;
                return this.count_ == other.count_ && Arrays.equals(this.lows_, other.lows_) && Arrays.equals(this.highs_, other.highs_);
            }
            return false;
        }
    }

    private static class AssumedChannelGrid
    implements ChannelGrid {
        private AssumedChannelGrid() {
        }

        @Override
        public int getChannelCount() {
            return -1;
        }

        @Override
        public int[] getChannelRange(double ylo, double yhi) {
            return new int[]{Math.max(0, (int)Math.floor(ylo)), (int)Math.ceil(yhi)};
        }

        @Override
        public void getChannelBounds(int ichan, double[] bounds) {
            bounds[0] = ichan;
            bounds[1] = ichan + 1;
        }
    }

    @Equality
    public static interface ChannelGrid {
        public int getChannelCount();

        public int[] getChannelRange(double var1, double var3);

        public void getChannelBounds(int var1, double[] var2);
    }
}

