/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;

@Equality
public abstract class StandardKernel1dShape
implements Kernel1dShape {
    private final String name_;
    private final String description_;
    private final double normExtent_;
    private final boolean isSquare_;
    public static final StandardKernel1dShape SQUARE = new StandardKernel1dShape("square", "Uniform value: f(x)=1, |x|=0..1", 1.0, true){

        @Override
        public double evaluate(double x) {
            return 1.0;
        }
    };
    public static final StandardKernel1dShape LINEAR = new StandardKernel1dShape("linear", "Triangle: f(x)=1-|x|, |x|=0..1", 1.0, false){

        @Override
        public double evaluate(double x) {
            return 1.0 - x;
        }
    };
    public static final StandardKernel1dShape EPANECHNIKOV = new StandardKernel1dShape("Epanechnikov", "Parabola: f(x)=1-x*x, |x|=0..1", 1.0, false){

        @Override
        public double evaluate(double x) {
            return 1.0 - x * x;
        }
    };
    public static final StandardKernel1dShape COS = new StandardKernel1dShape("cos", "Cosine: f(x)=cos(x*pi/2), |x|=0..1", 1.0, false){

        @Override
        public double evaluate(double x) {
            return Math.cos(1.5707963267948966 * x);
        }
    };
    public static final StandardKernel1dShape COS2 = new StandardKernel1dShape("cos2", "Cosine squared: f(x)=cos^2(x*pi/2), |x|=0..1", 1.0, false){

        @Override
        public double evaluate(double x) {
            double c = Math.cos(1.5707963267948966 * x);
            return c * c;
        }
    };
    public static final Kernel1d DELTA = new Kernel1d(){

        @Override
        public double[] convolve(double[] in) {
            return in;
        }

        @Override
        public int getExtent() {
            return 0;
        }

        @Override
        public boolean isSquare() {
            return true;
        }
    };
    private static final Kernel1dShape[] STANDARD_OPTIONS = new Kernel1dShape[]{SQUARE, LINEAR, EPANECHNIKOV, COS, COS2, StandardKernel1dShape.createTruncatedGaussian(3.0), StandardKernel1dShape.createTruncatedGaussian(6.0)};

    protected StandardKernel1dShape(String name, String description, double normExtent, boolean isSquare) {
        this.name_ = name;
        this.description_ = description;
        this.normExtent_ = normExtent;
        this.isSquare_ = isSquare;
    }

    protected abstract double evaluate(double var1);

    public double getNormalisedExtent() {
        return this.normExtent_;
    }

    public boolean isSquare() {
        return this.isSquare_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public Kernel1d createFixedWidthKernel(double width) {
        if (width < 0.0) {
            throw new IllegalArgumentException("negative width");
        }
        if (width == 0.0) {
            return DELTA;
        }
        double normExtent = this.getNormalisedExtent();
        double ext = normExtent * width;
        int nlevel = (int)Math.ceil(ext);
        if ((double)nlevel == ext && this.evaluate(normExtent) != 0.0) {
            ++nlevel;
        }
        double[] levels = new double[nlevel];
        double xscale = 1.0 / width;
        assert ((double)nlevel * xscale / normExtent >= 0.99999999);
        for (int i = 0; i < nlevel; ++i) {
            double x = (double)i * xscale;
            assert (x >= 0.0 && x <= normExtent);
            levels[i] = this.evaluate(x);
        }
        return StandardKernel1dShape.createSymmetricNormalisedKernel(levels, this.isSquare());
    }

    @Override
    public Kernel1d createKnnKernel(double k, boolean isSymmetric, int minWidth, int maxWidth) {
        if (!(k >= 0.0)) {
            throw new IllegalArgumentException("negative knn");
        }
        if (minWidth < 0) {
            throw new IllegalArgumentException("negative minimum width");
        }
        if (minWidth > maxWidth) {
            throw new IllegalArgumentException("min/max wrong way round");
        }
        if (k == 0.0 || minWidth == maxWidth) {
            return this.createFixedWidthKernel(minWidth);
        }
        return new KnnKernel(this, k, isSymmetric, minWidth, maxWidth);
    }

    public String toString() {
        return this.name_;
    }

    public static Kernel1dShape[] getStandardOptions() {
        return (Kernel1dShape[])STANDARD_OPTIONS.clone();
    }

    public static StandardKernel1dShape createTruncatedGaussian(double truncSigma) {
        String strunc = (double)((int)truncSigma) == truncSigma ? Integer.toString((int)truncSigma) : Double.toString(truncSigma);
        String name = "gauss" + strunc;
        String description = "Gaussian truncated at " + truncSigma + " sigma: " + "f(x)=exp(-x*x/2), |x|=0.." + strunc;
        return new StandardKernel1dShape(name, description, truncSigma, false){

            @Override
            public double evaluate(double x) {
                return Math.exp(-0.5 * x * x);
            }
        };
    }

    public static Kernel1d createSymmetricNormalisedKernel(double[] levels, boolean isSquare) {
        if (levels.length <= 1) {
            return DELTA;
        }
        int offset = levels.length - 1;
        double[] weights = new double[2 * offset + 1];
        for (int il = 0; il < levels.length; ++il) {
            weights[offset + il] = levels[il];
            weights[offset - il] = levels[il];
        }
        double sum = 0.0;
        for (int iw = 0; iw < weights.length; ++iw) {
            sum += weights[iw];
        }
        double scale = 1.0 / sum;
        int iw = 0;
        while (iw < weights.length) {
            int n = iw++;
            weights[n] = weights[n] * scale;
        }
        FixedKernel kernel = new FixedKernel(weights, offset, isSquare);
        assert (kernel.getExtent() == levels.length - 1);
        return kernel;
    }

    private static class KnnKernel
    implements Kernel1d {
        private final StandardKernel1dShape kshape_;
        private final double k_;
        private final boolean isSymmetric_;
        private final int minWidth_;
        private final int maxWidth_;
        private final double[][] weightArrays_;
        private final int maxExtent_;

        KnnKernel(StandardKernel1dShape kshape, double k, boolean isSymmetric, int minWidth, int maxWidth) {
            this.kshape_ = kshape;
            this.k_ = k;
            this.isSymmetric_ = isSymmetric;
            this.minWidth_ = minWidth;
            this.maxWidth_ = maxWidth;
            this.weightArrays_ = new double[this.maxWidth_ - this.minWidth_ + 1][];
            for (int iw = this.minWidth_; iw <= this.maxWidth_; ++iw) {
                this.weightArrays_[iw - this.minWidth_] = KnnKernel.getNormalisedWeightArray(kshape, iw);
            }
            this.maxExtent_ = kshape.createFixedWidthKernel(maxWidth).getExtent();
        }

        @Override
        public int getExtent() {
            return this.maxExtent_;
        }

        @Override
        public boolean isSquare() {
            return this.kshape_.isSquare();
        }

        @Override
        public double[] convolve(double[] in) {
            int ns = in.length;
            double[] out = new double[ns];
            for (int is = 0; is < ns; ++is) {
                int js;
                int mw;
                int pw;
                if (this.isSymmetric_) {
                    mw = pw = this.bidirectionalKnnWidth(in, is, this.maxWidth_);
                } else {
                    pw = this.unidirectionalKnnWidth(in, is, true, Math.min(this.maxWidth_, ns - is));
                    mw = this.unidirectionalKnnWidth(in, is, false, Math.min(this.maxWidth_, is));
                }
                int pWidth = Math.max(this.minWidth_, pw);
                int mWidth = Math.max(this.minWidth_, mw);
                double[] pWeights = this.weightArrays_[pWidth - this.minWidth_];
                double[] mWeights = this.weightArrays_[mWidth - this.minWidth_];
                double oval = 0.5 * (pWeights[0] + mWeights[0]) * in[is];
                int pnw = Math.min(pWeights.length, ns - is);
                int mnw = Math.min(mWeights.length, is);
                for (js = 1; js < pnw; ++js) {
                    oval += pWeights[js] * in[is + js];
                }
                for (js = 1; js < mnw; ++js) {
                    oval += mWeights[js] * in[is - js];
                }
                out[is] = oval;
            }
            return out;
        }

        public int hashCode() {
            int code = 4254352;
            code = 23 * code + this.kshape_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.k_);
            code = 23 * code + (this.isSymmetric_ ? 11 : 13);
            code = 23 * code + this.minWidth_;
            code = 23 * code + this.maxWidth_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof KnnKernel) {
                KnnKernel other = (KnnKernel)o;
                return this.kshape_.equals(other.kshape_) && this.k_ == other.k_ && this.isSymmetric_ == other.isSymmetric_ && this.minWidth_ == other.minWidth_ && this.maxWidth_ == other.maxWidth_;
            }
            return false;
        }

        private int unidirectionalKnnWidth(double[] data, int js, boolean isPositive, int maxWidth) {
            int step = isPositive ? 1 : -1;
            double sum = 0.0;
            for (int i = 0; i < maxWidth; ++i) {
                if ((sum += data[js]) >= this.k_) {
                    return i;
                }
                js += step;
            }
            return maxWidth;
        }

        private int bidirectionalKnnWidth(double[] data, int js, int maxWidth) {
            double sum = data[js];
            for (int i = 1; i < maxWidth; ++i) {
                int ks = js - i;
                int ls = js + i;
                if (ks >= 0) {
                    sum += data[ks];
                }
                if (ls < data.length) {
                    sum += data[ls];
                }
                if (!(sum >= this.k_)) continue;
                return i;
            }
            return maxWidth;
        }

        private static double[] getNormalisedWeightArray(StandardKernel1dShape kshape, int width) {
            if (width == 0) {
                return new double[]{1.0};
            }
            double normExtent = kshape.getNormalisedExtent();
            double ext = normExtent * (double)width;
            int nw = (int)Math.ceil(ext);
            if ((double)nw == ext && kshape.evaluate(normExtent) != 0.0) {
                ++nw;
            }
            double[] weights = new double[nw];
            double xscale = 1.0 / (double)width;
            double total = 0.0;
            for (int i = 0; i < nw; ++i) {
                double f;
                double x = (double)i * xscale;
                assert (x >= 0.0 && x <= normExtent);
                weights[i] = f = kshape.evaluate(x);
                total += f * (double)(i == 0 ? 1 : 2);
            }
            double scale = 1.0 / total;
            int i = 0;
            while (i < nw) {
                int n = i++;
                weights[n] = weights[n] * scale;
            }
            return weights;
        }
    }

    private static class FixedKernel
    implements Kernel1d {
        private final double[] weights_;
        private final int offset_;
        private final boolean isSquare_;

        public FixedKernel(double[] weights, int offset, boolean isSquare) {
            this.weights_ = (double[])weights.clone();
            this.offset_ = offset;
            this.isSquare_ = isSquare;
        }

        @Override
        public int getExtent() {
            return Math.max(this.offset_, this.weights_.length - 1 - this.offset_);
        }

        @Override
        public double[] convolve(double[] in) {
            int ns = in.length;
            int nw = this.weights_.length;
            double[] out = new double[ns];
            for (int iw = 0; iw < nw; ++iw) {
                double weight = this.weights_[iw];
                int is0 = Math.max(0, this.offset_ - iw);
                int is1 = Math.min(ns, ns + this.offset_ - iw);
                for (int is = is0; is < is1; ++is) {
                    int n = is;
                    out[n] = out[n] + in[is + iw - this.offset_] * weight;
                }
            }
            return out;
        }

        @Override
        public boolean isSquare() {
            return this.isSquare_;
        }

        public int hashCode() {
            int code = 9902;
            code = 23 * code + Arrays.hashCode(this.weights_);
            code = 23 * code + this.offset_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FixedKernel) {
                FixedKernel other = (FixedKernel)o;
                return Arrays.equals(this.weights_, other.weights_) && this.offset_ == other.offset_;
            }
            return false;
        }
    }
}

