/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.HistogramPlotter;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Rounding;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class Stats1Plotter
implements Plotter<StatsStyle> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord weightCoord_;
    private final ConfigKey<Normalisation> normKey_;
    private final SliceDataGeom fitDataGeom_;
    private final CoordGroup fitCoordGrp_;
    private final int icX_;
    private final int icWeight_;
    public static final ReportKey<Double> CONST_KEY = ReportKey.createDoubleKey(new ReportMeta("c", "Factor"), true);
    public static final ReportKey<Double> MEAN_KEY = ReportKey.createDoubleKey(new ReportMeta("mu", "Mean"), true);
    public static final ReportKey<Double> STDEV_KEY = ReportKey.createDoubleKey(new ReportMeta("sigma", "Standard Deviation"), true);
    public static final ReportKey<String> FUNCTION_KEY = ReportKey.createStringKey(new ReportMeta("function", "Function"), true);
    public static final ConfigKey<BinSizer> BINSIZER_KEY = HistogramPlotter.BINSIZER_KEY;
    public static final ConfigKey<Boolean> SHOWMEAN_KEY = new BooleanConfigKey(new ConfigMeta("showmean", "Show Mean").setShortDescription("Display a line at the mean").setXmlDescription(new String[]{"<p>If true, a line is drawn at the position of", "the calculated mean.", "</p>"}), true);

    public Stats1Plotter(FloatingCoord xCoord, boolean hasWeight, ConfigKey<Normalisation> normKey) {
        this.xCoord_ = xCoord;
        this.normKey_ = normKey;
        if (hasWeight) {
            this.weightCoord_ = FloatingCoord.WEIGHT_COORD;
            this.fitCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord, this.weightCoord_}, new boolean[]{false, false});
        } else {
            this.weightCoord_ = null;
            this.fitCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord}, new boolean[]{false});
        }
        this.fitDataGeom_ = new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "X");
        this.icX_ = this.fitCoordGrp_.getExtraCoordIndex(0, null);
        this.icWeight_ = hasWeight ? this.fitCoordGrp_.getExtraCoordIndex(1, null) : -1;
    }

    @Override
    public String getPlotterName() {
        return "Gaussian";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_GAUSSIAN;
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a best fit Gaussian to the histogram of", "a sample of data.", "In fact, all this plotter does is to calculate the mean", "and standard deviation of the sample,", "and plot the corresponding Gaussian curve.", "The mean and standard deviation values are reported by the plot.", "</p>", "<p>The <code>" + this.normKey_ + "</code> config option,", "perhaps in conjunction with <code>" + BINSIZER_KEY + "</code>,", "can be used to scale the height of the plotted curve", "in data units.", "In this case, <code>" + BINSIZER_KEY + "</code>", "just describes the bar width of a notional histogram", "whose outline the plotted Gaussian should try to fit,", "and is only relevant for some of the normalisation options.", "</p>"});
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.fitCoordGrp_;
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Object>> list = new ArrayList<ConfigKey<Object>>();
        list.add(StyleKeys.COLOR);
        list.add(SHOWMEAN_KEY);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(StyleKeys.ANTIALIAS);
        list.add(this.normKey_);
        list.add(BINSIZER_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public StatsStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        boolean showmean = Boolean.TRUE.equals(config.get(SHOWMEAN_KEY));
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        Normalisation norm = config.get(this.normKey_);
        BinSizer sizer = config.get(BINSIZER_KEY);
        return new StatsStyle(color, stroke, antialias, showmean, norm, sizer);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final StatsStyle style) {
        LayerOpt layerOpt = new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, this.fitDataGeom_, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                return new StatsDrawing((PlanarSurface)surface, geom, dataSpec, style, paperType);
            }
        };
    }

    private static double log(double val) {
        return Math.log10(val);
    }

    private static class WStats {
        private double sw_;
        private double swX_;
        private double swXX_;

        private WStats() {
        }

        public void addPoint(double x, double w) {
            if (w > 0.0 && !Double.isInfinite(w)) {
                this.sw_ += w;
                this.swX_ += w * x;
                this.swXX_ += w * x * x;
            }
        }

        public void addPoint(double x) {
            this.sw_ += 1.0;
            this.swX_ += x;
            this.swXX_ += x * x;
        }

        public double getMean() {
            return this.swX_ / this.sw_;
        }

        public double getSigma() {
            return Math.sqrt((this.swXX_ - this.swX_ * this.swX_ / this.sw_) / this.sw_);
        }

        public double getSum() {
            return this.sw_;
        }
    }

    private static class StatsPlan {
        final boolean isLog_;
        final double mean_;
        final double sigma_;
        final double sum_;
        final DataSpec dataSpec_;

        StatsPlan(boolean isLog, WStats stats, DataSpec dataSpec) {
            this.isLog_ = isLog;
            this.mean_ = stats.getMean();
            this.sigma_ = stats.getSigma();
            this.sum_ = stats.getSum();
            this.dataSpec_ = dataSpec;
        }

        boolean matches(boolean isLog, DataSpec dataSpec) {
            return isLog == this.isLog_ && dataSpec.equals(this.dataSpec_);
        }

        void paintLine(Graphics g, PlanarSurface surface, StatsStyle style, boolean isBitmap) {
            double factor = this.getFactor(surface, style);
            Graphics2D g2 = (Graphics2D)g;
            Rectangle box = surface.getPlotBounds();
            int gxlo = box.x - 2;
            int gxhi = box.x + box.width + 2;
            int np = gxhi - gxlo;
            LineTracer tracer = style.createLineTracer(g2, box, np, isBitmap);
            Point2D.Double gpos = new Point2D.Double();
            double[] dpos = new double[surface.getDataDimCount()];
            for (int ip = 0; ip < np; ++ip) {
                double dx = surface.graphicsToData(new Point(gxlo + ip, box.y), null)[0];
                if (Double.isNaN(dx)) continue;
                dpos[0] = dx;
                dpos[1] = factor * this.gaussian(dx);
                if (!surface.dataToGraphics(dpos, false, gpos) || !PlotUtil.isPointReal(gpos)) continue;
                tracer.addVertex(gpos.x, gpos.y);
            }
            tracer.flush();
            if (style.showmean_) {
                double dx = this.mean_;
                Axis[] axes = surface.getAxes();
                double gx = axes[0].dataToGraphics(dx);
                double gylo = axes[1].dataToGraphics(0.0);
                double gyhi = axes[1].dataToGraphics(factor);
                LineTracer meanTracer = style.createLineTracer(g2, box, 3, isBitmap);
                meanTracer.addVertex(gx, gylo);
                meanTracer.addVertex(gx, gyhi);
                meanTracer.flush();
            }
        }

        private double getFactor(PlanarSurface surface, StatsStyle style) {
            boolean xlog = surface.getLogFlags()[0];
            double[] xlims = surface.getDataLimits()[0];
            Rounding xround = Rounding.getRounding(surface.getTimeFlags()[0]);
            double bw = style.sizer_.getWidth(xlog, xlims[0], xlims[1], xround);
            double binWidth = xlog ? Stats1Plotter.log(bw) : bw;
            double c = 1.0 / (this.sigma_ * Math.sqrt(Math.PI * 2));
            double sum = this.sum_;
            double max = c * sum * binWidth;
            boolean isCumulative = false;
            double normFactor = style.norm_.getScaleFactor(sum, max, binWidth, isCumulative);
            return normFactor * c * this.sum_ * binWidth;
        }

        double gaussian(double x) {
            double s = this.isLog_ ? Stats1Plotter.log(x) : x;
            double p = (s - this.mean_) / this.sigma_;
            return Math.exp(-0.5 * p * p);
        }

        public ReportMap getReport(PlanarSurface surface, StatsStyle style) {
            ReportMap report = new ReportMap();
            double factor = this.getFactor(surface, style);
            report.put(MEAN_KEY, this.mean_);
            report.put(STDEV_KEY, this.sigma_);
            report.put(CONST_KEY, factor);
            String function = new StringBuffer().append(CONST_KEY.toText(factor)).append(" * ").append("exp(-0.5 * pow((").append(this.isLog_ ? "log10(x)" : "x").append("-").append(MEAN_KEY.toText(this.mean_)).append(")/").append(STDEV_KEY.toText(this.sigma_)).append(", 2))").toString();
            report.put(FUNCTION_KEY, function);
            return report;
        }
    }

    private class StatsDrawing
    implements Drawing {
        private final PlanarSurface surface_;
        private final DataGeom geom_;
        private final DataSpec dataSpec_;
        private final StatsStyle style_;
        private final PaperType paperType_;

        StatsDrawing(PlanarSurface surface, DataGeom geom, DataSpec dataSpec, StatsStyle style, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.style_ = style;
            this.paperType_ = paperType;
        }

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            boolean isLog = this.surface_.getLogFlags()[0];
            for (Object plan : knownPlans) {
                if (!(plan instanceof StatsPlan) || !((StatsPlan)plan).matches(isLog, this.dataSpec_)) continue;
                return plan;
            }
            WStats stats = new WStats();
            TupleSequence tseq = dataStore.getTupleSequence(this.dataSpec_);
            if (Stats1Plotter.this.weightCoord_ == null || this.dataSpec_.isCoordBlank(Stats1Plotter.this.icWeight_)) {
                while (tseq.next()) {
                    double x = Stats1Plotter.this.xCoord_.readDoubleCoord(tseq, Stats1Plotter.this.icX_);
                    double s = isLog ? Stats1Plotter.log(x) : x;
                    if (!PlotUtil.isFinite(s)) continue;
                    stats.addPoint(s);
                }
            } else {
                while (tseq.next()) {
                    double x = Stats1Plotter.this.xCoord_.readDoubleCoord(tseq, Stats1Plotter.this.icX_);
                    double s = isLog ? Stats1Plotter.log(x) : x;
                    if (!PlotUtil.isFinite(s)) continue;
                    double w = Stats1Plotter.this.weightCoord_.readDoubleCoord(tseq, Stats1Plotter.this.icWeight_);
                    stats.addPoint(s, w);
                }
            }
            return new StatsPlan(isLog, stats, this.dataSpec_);
        }

        @Override
        public void paintData(Object plan, Paper paper, DataStore dataStore) {
            final StatsPlan splan = (StatsPlan)plan;
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    splan.paintLine(g, StatsDrawing.this.surface_, StatsDrawing.this.style_, StatsDrawing.this.paperType_.isBitmap());
                }

                @Override
                public boolean isOpaque() {
                    return !StatsDrawing.this.style_.getAntialias();
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            return ((StatsPlan)plan).getReport(this.surface_, this.style_);
        }
    }

    public static class StatsStyle
    extends LineStyle {
        final boolean showmean_;
        final Normalisation norm_;
        final BinSizer sizer_;

        public StatsStyle(Color color, Stroke stroke, boolean antialias, boolean showmean, Normalisation norm, BinSizer sizer) {
            super(color, stroke, antialias);
            this.showmean_ = showmean;
            this.norm_ = norm;
            this.sizer_ = sizer;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code = 23 * code + (this.showmean_ ? 11 : 17);
            code = 23 * code + PlotUtil.hashCode(this.norm_);
            code = 23 * code + PlotUtil.hashCode(this.sizer_);
            return code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof StatsStyle) {
                StatsStyle other = (StatsStyle)o;
                return super.equals(other) && this.showmean_ == other.showmean_ && PlotUtil.equals(this.norm_, other.norm_) && PlotUtil.equals(this.sizer_, other.sizer_);
            }
            return false;
        }
    }
}

