/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.gui.ThicknessComboBox;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.config.SubrangeConfigKey;
import uk.ac.starlink.ttools.plot2.config.UnitRangeSpecifier;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.FillPlan;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Pixel1dPlotter;
import uk.ac.starlink.ttools.plot2.layer.StandardKernel1dShape;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class TracePlotter
extends AbstractPlotter<TraceStyle> {
    private final boolean hasVertical_;
    public static final ConfigKey<Boolean> HORIZONTAL_KEY = new BooleanConfigKey(new ConfigMeta("horizontal", "Horizontal").setShortDescription("Horizontal trace?").setXmlDescription(new String[]{"<p>Determines whether the trace bins are horizontal", "or vertical.", "If <code>true</code>, there is a <m>y</m> value calculated", "for each pixel column, and", "if <code>false</code>, there is an <m>x</m> value for each", "pixel row.", "</p>"}), true);
    public static final ConfigKey<Integer> THICK_KEY = TracePlotter.createThicknessKey();
    public static final ConfigKey<Subrange> QUANTILES_KEY = TracePlotter.createQuantilesKey();
    public static final ReportKey<Double> SMOOTHWIDTH_KEY = ReportKey.createDoubleKey(new ReportMeta("smoothwidth", "Smoothing Width"), false);
    public static final ConfigKey<BinSizer> SMOOTHSIZER_KEY = BinSizer.createSizerConfigKey(new ConfigMeta("smooth", "Smoothing").setStringUsage("+<width>|-<count>").setShortDescription("Smoothing width specification").setXmlDescription(new String[]{"<p>Configures the smoothing width.", "This is the characteristic width of the kernel function", "to be convolved with the density in one dimension", "to smooth the quantile function.", "</p>", BinSizer.getConfigKeyDescription()}), SMOOTHWIDTH_KEY, 0, true);
    public static final ConfigKey<Kernel1dShape> KERNEL_KEY = new OptionConfigKey<Kernel1dShape>(new ConfigMeta("kernel", "Kernel").setShortDescription("Smoothing kernel functional form").setXmlDescription(new String[]{"<p>The functional form of the smoothing kernel.", "The functions listed refer to the unscaled shape;", "all kernels are normalised to give a total area of unity.", "</p>"}), Kernel1dShape.class, StandardKernel1dShape.getStandardOptions(), (Kernel1dShape)StandardKernel1dShape.EPANECHNIKOV){

        @Override
        public String getXmlDescription(Kernel1dShape kshape) {
            return kshape.getDescription();
        }
    }.setOptionUsage().addOptionsXml();
    private static final String QUANTILES_NAME = "quantiles";

    public TracePlotter(boolean hasVertical) {
        super("Quantile", ResourceIcon.FORM_QUANTILE, 1, new Coord[0]);
        this.hasVertical_ = hasVertical;
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a line through a given quantile of the values", "binned within each pixel column (or row) of a plot.", "The line is optionally smoothed", "using a configurable kernel and width,", "to even out noise arising from the pixel binning.", "Instead of a simple line through a given quantile,", "it is also possible to fill the region between two quantiles.", "</p>", "<p>One way to use this is to draw a line estimating a function", "<m>y=f(x)</m> (or <m>x=g(y)</m>) sampled by a noisy set", "of data points in two dimensions.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Object>> list = new ArrayList<ConfigKey<Object>>();
        list.add(StyleKeys.COLOR);
        list.add(StyleKeys.TRANSPARENCY);
        list.add(QUANTILES_KEY);
        list.add(THICK_KEY);
        list.add(SMOOTHSIZER_KEY);
        list.add(KERNEL_KEY);
        if (this.hasVertical_) {
            list.add(HORIZONTAL_KEY);
        }
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public TraceStyle createStyle(ConfigMap config) {
        Color color = StyleKeys.getAlphaColor(config, StyleKeys.COLOR, StyleKeys.TRANSPARENCY);
        boolean isHorizontal = config.get(HORIZONTAL_KEY);
        Subrange qrange = config.get(QUANTILES_KEY);
        int thickness = config.get(THICK_KEY);
        Kernel1dShape kernelShape = config.get(KERNEL_KEY);
        BinSizer smoothSizer = config.get(SMOOTHSIZER_KEY);
        return new TraceStyle(color, isHorizontal, thickness, qrange.getLow(), qrange.getHigh(), kernelShape, smoothSizer);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final TraceStyle style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        Color color = style.color_;
        final boolean isOpaque = color.getAlpha() == 255;
        LayerOpt layerOpt = new LayerOpt(color, isOpaque);
        return new AbstractPlotLayer(this, geom, dataSpec, style, layerOpt){
            final boolean isHorizontal;
            final int icPos;
            {
                super(x0, x1, x2, x3, x4);
                this.isHorizontal = style.isHorizontal_;
                this.icPos = TracePlotter.this.getCoordGroup().getPosCoordIndex(0, geom);
            }

            @Override
            public Drawing createDrawing(final Surface surface, Map<AuxScale, Range> auxRanges, final PaperType paperType) {
                final PlanarSurface psurf = (PlanarSurface)surface;
                final ReportMap report = TracePlotter.this.createReport(style, psurf);
                return new Drawing(){

                    @Override
                    public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                        for (Object plan : knownPlans) {
                            if (!(plan instanceof FillPlan) || !((FillPlan)plan).matches(geom, dataSpec, surface)) continue;
                            return plan;
                        }
                        return FillPlan.createPlan(surface, dataSpec, geom, icPos, dataStore);
                    }

                    @Override
                    public void paintData(Object plan, Paper paper, DataStore dataStore) {
                        final FillPlan fplan = (FillPlan)plan;
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                TracePlotter.this.paintTrace(psurf, fplan, style, g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return isOpaque;
                            }
                        });
                    }

                    @Override
                    public ReportMap getReport(Object plan) {
                        return report;
                    }
                };
            }
        };
    }

    private ReportMap createReport(TraceStyle style, PlanarSurface psurf) {
        int iax = style.isHorizontal_ ? 0 : 1;
        Axis xAxis = psurf.getAxes()[iax];
        boolean xLog = psurf.getLogFlags()[iax];
        double[] dlims = xAxis.getDataLimits();
        double w = style.smoothSizer_.getWidth(xLog, dlims[0], dlims[1], null);
        ReportMap report = new ReportMap();
        report.put(SMOOTHWIDTH_KEY, new Double(w));
        return report;
    }

    private void paintTrace(PlanarSurface surface, FillPlan plan, TraceStyle style, Graphics g) {
        Gridder gridder;
        int[] xhis;
        int[] xlos;
        boolean isHorizontal = style.isHorizontal_;
        int minThick = style.thickness_;
        Binner binner = plan.getBinner();
        if (isHorizontal) {
            xlos = plan.getXlos();
            xhis = plan.getXhis();
            gridder = plan.getGridder();
        } else {
            xlos = plan.getYlos();
            xhis = plan.getYhis();
            gridder = Gridder.transpose(plan.getGridder());
        }
        int iXax = isHorizontal ? 0 : 1;
        int iYax = isHorizontal ? 1 : 0;
        Axis xAxis = surface.getAxes()[iXax];
        boolean xLog = surface.getLogFlags()[iXax];
        boolean yFlip = surface.getFlipFlags()[iYax];
        boolean yInvert = isHorizontal ^ yFlip;
        double qlo = yInvert ? 1.0 - style.qhi_ : style.qlo_;
        double qhi = yInvert ? 1.0 - style.qlo_ : style.qhi_;
        Kernel1d kernel = Pixel1dPlotter.createKernel(style.kernelShape_, style.smoothSizer_, xAxis, xLog);
        GridData gdata = TracePlotter.createGridData(kernel, xlos, xhis, binner, gridder);
        Color color0 = g.getColor();
        g.setColor(style.color_);
        Rectangle bounds = surface.getPlotBounds();
        int x0 = bounds.x;
        int y0 = bounds.y;
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        double[] line = new double[ny];
        for (int ix = 0; ix < nx; ++ix) {
            int thick;
            int jy0;
            int jyhi;
            double xlo = gdata.getSumBelow(ix);
            double xhi = gdata.getSumAbove(ix);
            double count = xlo;
            for (int iy = 0; iy < ny; ++iy) {
                double c;
                line[iy] = c = gdata.getSample(ix, iy);
                count += c;
            }
            int jylo = TracePlotter.getRankIndex(xlo, xhi, count += xhi, line, qlo);
            int n = jyhi = qlo == qhi ? jylo : TracePlotter.getRankIndex(xlo, xhi, count, line, qhi);
            if (jylo < 0 && jyhi < 0 || jylo >= ny && jyhi >= ny) continue;
            int natThick = jyhi - jylo;
            assert (natThick >= 0) : jylo + " - " + jyhi;
            if (natThick >= minThick) {
                jy0 = jylo;
                thick = natThick;
            } else {
                jy0 = jylo - minThick / 2;
                thick = minThick;
            }
            if (isHorizontal) {
                g.fillRect(x0 + ix, y0 + jy0, 1, thick);
                continue;
            }
            g.fillRect(x0 + jy0, y0 + ix, thick, 1);
        }
        g.setColor(color0);
    }

    private static int getRankIndex(double xlo, double xhi, double count, double[] line, double quantile) {
        double rank = quantile * count;
        if (!(count > 0.0)) {
            return -1;
        }
        if (rank < xlo) {
            return -1;
        }
        if (rank > count - xhi) {
            return line.length;
        }
        double s = xlo;
        for (int iy = 0; iy < line.length; ++iy) {
            if (s >= rank && s > 0.0) {
                return iy;
            }
            s += line[iy];
        }
        return line.length;
    }

    private static GridData createGridData(Kernel1d kernel, final int[] xlos, final int[] xhis, final Binner binner, final Gridder gridder) {
        if (kernel.getExtent() < 1) {
            return new GridData(){

                @Override
                public double getSumBelow(int ix) {
                    return xlos[ix];
                }

                @Override
                public double getSumAbove(int ix) {
                    return xhis[ix];
                }

                @Override
                public double getSample(int ix, int iy) {
                    return binner.getCount(gridder.getIndex(ix, iy));
                }
            };
        }
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        final double[] cdata = new double[nx * ny];
        double[] line = new double[nx];
        for (int iy = 0; iy < ny; ++iy) {
            int ix;
            for (ix = 0; ix < nx; ++ix) {
                line[ix] = binner.getCount(gridder.getIndex(ix, iy));
            }
            line = kernel.convolve(line);
            for (ix = 0; ix < nx; ++ix) {
                cdata[gridder.getIndex((int)ix, (int)iy)] = line[ix];
            }
        }
        double[] dxlos = new double[nx];
        double[] dxhis = new double[nx];
        for (int ix = 0; ix < nx; ++ix) {
            dxlos[ix] = xlos[ix];
            dxhis[ix] = xhis[ix];
        }
        final double[] cxlos = kernel.convolve(dxlos);
        final double[] cxhis = kernel.convolve(dxhis);
        return new GridData(){

            @Override
            public double getSumBelow(int ix) {
                return cxlos[ix];
            }

            @Override
            public double getSumAbove(int ix) {
                return cxhis[ix];
            }

            @Override
            public double getSample(int ix, int iy) {
                return cdata[gridder.getIndex(ix, iy)];
            }
        };
    }

    private static ConfigKey<Integer> createThicknessKey() {
        ConfigMeta meta = new ConfigMeta("thick", "Thickness");
        meta.setStringUsage("<pixels>");
        meta.setShortDescription("Minimum line thickness in pixels");
        meta.setXmlDescription(new String[]{"<p>Sets the minimum extent of the markers that are plotted", "in each pixel column (or row) to indicate the designated", "value range.", "If the range is zero sized", "(<code>quantiles</code>", "specifies a single value rather than a pair)", "this will give the actual thickness of the plotted line.", "If the range is non-zero however, the line may be thicker", "than this in places according to the quantile positions.", "</p>"});
        return new IntegerConfigKey(meta, 3){

            @Override
            public Specifier<Integer> createSpecifier() {
                return new ComboBoxSpecifier<Integer>((JComboBox)((Object)new ThicknessComboBox(7)));
            }
        };
    }

    private static ConfigKey<Subrange> createQuantilesKey() {
        ConfigMeta meta = new ConfigMeta(QUANTILES_NAME, "Quantiles");
        meta.setStringUsage("<low-frac>[,<high-frac>]");
        meta.setShortDescription("Target quantile value or range");
        meta.setXmlDescription(new String[]{"<p>Defines the quantile or quantile range", "of values that should be marked in each pixel column (or row).", "The value may be a single number in the range 0..1", "indicating the quantile which should be marked.", "Alternatively, it may be a pair of numbers,", "each in the range 0..1,", "separated by commas (<code>&lt;lo&gt;,&lt;hi&gt;</code>)", "indicating two quantile lines bounding an area to be filled.", "A pair of equal values \"<code>a,a</code>\"", "is equivalent to the single value \"<code>a</code>\".", "The default is <code>0.5</code>,", "which means to mark the median value in each column,", "and could equivalently be specified <code>0.5,0.5</code>.", "</p>"});
        final Subrange dflt = new Subrange(0.5, 0.5);
        return new SubrangeConfigKey(meta, dflt, 0.0, 1.0){

            @Override
            public String valueToString(Subrange range) {
                double hi;
                double lo = range.getLow();
                return lo == (hi = range.getHigh()) ? this.format(lo) : this.format(lo) + "," + this.format(hi);
            }

            @Override
            public Subrange stringToValue(String txt) throws ConfigException {
                Subrange r0;
                try {
                    double v0 = Double.parseDouble(txt.trim());
                    r0 = new Subrange(v0, v0);
                }
                catch (NumberFormatException e) {
                    r0 = null;
                }
                Subrange range = r0 == null ? super.stringToValue(txt) : r0;
                double lo = range.getLow();
                double hi = range.getHigh();
                if (!(lo >= 0.0)) {
                    throw new ConfigException(this, "Bad lower bound: " + lo + " < 0");
                }
                if (!(hi <= 1.0)) {
                    throw new ConfigException(this, "Bad upper bound: " + hi + " > 1");
                }
                return range;
            }

            @Override
            public Specifier<Subrange> createSpecifier() {
                return new UnitRangeSpecifier(dflt);
            }

            private String format(double val) {
                String txt = Double.toString(val);
                txt.replaceAll("\\.0$", "");
                return txt;
            }
        };
    }

    public static class TraceStyle
    implements Style {
        private final Color color_;
        private final boolean isHorizontal_;
        private final int thickness_;
        private final double qlo_;
        private final double qhi_;
        private final Kernel1dShape kernelShape_;
        private final BinSizer smoothSizer_;
        private final int[] TDATA = new int[]{3, 3, 3, 4, 5, 5, 6, 6, 6, 5, 5, 4, 4, 3, 3, 4, 4, 4, 3, 3};
        private final int[] YDATA = new int[]{-1, -1, -2, -2, -2, -1, -1, 0, 1, 1, 2, 2, 1, 1, 0, 0, -1, -1, 0};

        public TraceStyle(Color color, boolean isHorizontal, int thickness, double qlo, double qhi, Kernel1dShape kernelShape, BinSizer smoothSizer) {
            this.color_ = color;
            this.isHorizontal_ = isHorizontal;
            this.thickness_ = thickness;
            this.qlo_ = qlo;
            this.qhi_ = qhi;
            this.kernelShape_ = kernelShape;
            this.smoothSizer_ = smoothSizer;
        }

        @Override
        public Icon getLegendIcon() {
            int width = 20;
            int height = 12;
            return new Icon(){

                @Override
                public int getIconWidth() {
                    return 20;
                }

                @Override
                public int getIconHeight() {
                    return 12;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color color0 = g.getColor();
                    g.setColor(TraceStyle.this.color_);
                    for (int ix = 0; ix < 20; ++ix) {
                        int td;
                        int yd = TraceStyle.this.YDATA[Math.min(ix, TraceStyle.this.YDATA.length - 1)];
                        if (TraceStyle.this.qlo_ == TraceStyle.this.qhi_) {
                            td = TraceStyle.this.thickness_;
                        } else {
                            td = TraceStyle.this.TDATA[Math.min(ix, TraceStyle.this.TDATA.length - 1)];
                            if (td < TraceStyle.this.thickness_) {
                                td = TraceStyle.this.thickness_;
                            }
                        }
                        g.fillRect(x + ix, y + (12 - td) / 2 + yd, 1, td);
                    }
                    g.setColor(color0);
                }
            };
        }

        public int hashCode() {
            int code = 4422621;
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + (this.isHorizontal_ ? 3 : 5);
            code = 23 * code + this.thickness_;
            code = 23 * code + Float.floatToIntBits((float)this.qlo_);
            code = 23 * code + Float.floatToIntBits((float)this.qhi_);
            code = 23 * code + PlotUtil.hashCode(this.kernelShape_);
            code = 23 * code + this.smoothSizer_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof TraceStyle) {
                TraceStyle other = (TraceStyle)o;
                return this.color_.equals(other.color_) && this.isHorizontal_ == other.isHorizontal_ && this.thickness_ == other.thickness_ && this.qlo_ == other.qlo_ && this.qhi_ == other.qhi_ && PlotUtil.equals(this.kernelShape_, other.kernelShape_) && this.smoothSizer_.equals(other.smoothSizer_);
            }
            return false;
        }
    }

    private static interface GridData {
        public double getSumBelow(int var1);

        public double getSumAbove(int var1);

        public double getSample(int var1, int var2);
    }
}

