/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import uk.ac.starlink.ttools.plot.Drawing;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.PixellatorPixerFactory;
import uk.ac.starlink.ttools.plot2.layer.XYShape;

public class XYShapes {
    private static final XYShape[] XYSHAPES = XYShapes.createXYShapes();

    private XYShapes() {
    }

    public static XYShape[] getXYShapes() {
        return (XYShape[])XYSHAPES.clone();
    }

    private static XYShape[] createXYShapes() {
        ArrayList<XYShape> shapes = new ArrayList<XYShape>();
        shapes.add(XYShapes.createRectangleShape("Open Rectangle", false));
        shapes.add(XYShapes.createTriangleShape("Open Triangle", false, true));
        shapes.add(XYShapes.createTriangleShape("Open Triangle Down", false, false));
        shapes.add(XYShapes.createDiamondShape("Open Diamond", false));
        shapes.add(XYShapes.createEllipseShape("Open Ellipse", false));
        shapes.add(XYShapes.createRectangleShape("Filled Rectangle", true));
        shapes.add(XYShapes.createTriangleShape("Filled Triangle", true, true));
        shapes.add(XYShapes.createTriangleShape("Filled Triangle Down", true, false));
        shapes.add(XYShapes.createDiamondShape("Filled Diamond", true));
        shapes.add(XYShapes.createEllipseShape("Filled Ellipse", true));
        return shapes.toArray(new XYShape[0]);
    }

    private static int getPixelMaxCacheRadius(boolean isFill) {
        return isFill ? 16 : 24;
    }

    private static XYShape createEllipseShape(String name, final boolean isFill) {
        return new DrawingShape(name, XYShapes.getPixelMaxCacheRadius(isFill)){

            @Override
            public DrawingShape.Glypher createGlypher(final int dx, final int dy) {
                if (isFill) {
                    return new DrawingShape.Glypher(){

                        @Override
                        public void paintShape(Graphics g) {
                            g.fillOval(-dx, -dy, 2 * dx, 2 * dy);
                        }

                        @Override
                        public void drawShape(Drawing d) {
                            d.fillOval(-dx, -dy, 2 * dx, 2 * dy);
                        }
                    };
                }
                return new DrawingShape.Glypher(){

                    @Override
                    public void paintShape(Graphics g) {
                        g.drawOval(-dx, -dy, 2 * dx, 2 * dy);
                    }

                    @Override
                    public void drawShape(Drawing d) {
                        d.drawOval(-dx, -dy, 2 * dx, 2 * dy);
                    }
                };
            }
        };
    }

    private static XYShape createRectangleShape(String name, boolean isFill) {
        if (isFill) {
            return new BlockShape(name);
        }
        return new PolygonShape(name, false){

            @Override
            Polygon createPolygon(int dx, int dy) {
                return new Polygon(new int[]{-dx, -dx, dx, dx}, new int[]{-dy, dy, dy, -dy}, 4);
            }
        };
    }

    private static XYShape createTriangleShape(String name, boolean isFill, final boolean isUp) {
        return new PolygonShape(name, isFill){

            @Override
            Polygon createPolygon(int dx, int dy) {
                int[] nArray;
                int[] xoffs = new int[]{-dx, dx, 0};
                if (isUp) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = dy;
                    nArray2[1] = dy;
                    nArray = nArray2;
                    nArray2[2] = -dy;
                } else {
                    int[] nArray3 = new int[3];
                    nArray3[0] = -dy;
                    nArray3[1] = -dy;
                    nArray = nArray3;
                    nArray3[2] = dy;
                }
                int[] yoffs = nArray;
                return new Polygon(xoffs, yoffs, 3);
            }
        };
    }

    private static XYShape createDiamondShape(String name, boolean isFill) {
        return new PolygonShape(name, isFill){

            @Override
            Polygon createPolygon(int dx, int dy) {
                return new Polygon(new int[]{-dx, 0, dx, 0}, new int[]{0, dy, 0, -dy}, 4);
            }
        };
    }

    private static class ErrorEllipseShape
    extends XYShape {
        private final ErrorRenderer renderer_;

        ErrorEllipseShape(ErrorRenderer renderer) {
            super(renderer.getName(), 20);
            this.renderer_ = renderer;
        }

        @Override
        public Glyph createGlyph(short sx, short sy) {
            short x = sx;
            short y = sy;
            final int[] xoffs = new int[]{x, -x, 0, 0};
            final int[] yoffs = new int[]{0, 0, -y, y};
            if (this.isCached(sx, sy)) {
                Rectangle bounds = new Rectangle(-x, -y, x * 2 + 1, y * 2 + 1);
                Pixellator pixellator = this.renderer_.getPixels(bounds, 0, 0, xoffs, yoffs);
                final PixellatorPixerFactory pfact = new PixellatorPixerFactory(pixellator);
                return new Glyph(){

                    @Override
                    public void paintGlyph(Graphics g) {
                        ErrorEllipseShape.this.renderer_.drawErrors(g, 0, 0, xoffs, yoffs);
                    }

                    @Override
                    public Pixer createPixer(Rectangle clip) {
                        return pfact.createPixer(clip);
                    }
                };
            }
            return new Glyph(){

                @Override
                public void paintGlyph(Graphics g) {
                    ErrorEllipseShape.this.renderer_.drawErrors(g, 0, 0, xoffs, yoffs);
                }

                @Override
                public Pixer createPixer(Rectangle clip) {
                    final Pixellator pixellator = ErrorEllipseShape.this.renderer_.getPixels(clip, 0, 0, xoffs, yoffs);
                    pixellator.start();
                    return new Pixer(){

                        @Override
                        public boolean next() {
                            return pixellator.next();
                        }

                        @Override
                        public int getX() {
                            return pixellator.getX();
                        }

                        @Override
                        public int getY() {
                            return pixellator.getY();
                        }
                    };
                }
            };
        }
    }

    private static abstract class DrawingShape
    extends XYShape {
        DrawingShape(String name, int maxCacheRadius) {
            super(name, maxCacheRadius);
        }

        abstract Glypher createGlypher(int var1, int var2);

        @Override
        public Glyph createGlyph(short sx, short sy) {
            short x = sx;
            short y = sy;
            int[] xoffs = new int[]{x, -x, 0, 0};
            int[] yoffs = new int[]{0, 0, -y, y};
            final Rectangle bounds = new Rectangle(-x, -y, x * 2 + 1, y * 2 + 1);
            final Glypher glypher = this.createGlypher(sx, sy);
            if (this.isCached(sx, sy)) {
                Drawing drawing = new Drawing(bounds);
                glypher.drawShape(drawing);
                final PixellatorPixerFactory pfact = new PixellatorPixerFactory(drawing);
                return new Glyph(){

                    @Override
                    public void paintGlyph(Graphics g) {
                        glypher.paintShape(g);
                    }

                    @Override
                    public Pixer createPixer(Rectangle clip) {
                        return pfact.createPixer(clip);
                    }
                };
            }
            return new Glyph(){

                @Override
                public void paintGlyph(Graphics g) {
                    glypher.paintShape(g);
                }

                @Override
                public Pixer createPixer(Rectangle clip) {
                    Rectangle rect = clip.contains(bounds) ? bounds : bounds.intersection(clip);
                    final Drawing drawing = new Drawing(rect);
                    glypher.drawShape(drawing);
                    drawing.start();
                    return new Pixer(){

                        @Override
                        public boolean next() {
                            return drawing.next();
                        }

                        @Override
                        public int getX() {
                            return drawing.getX();
                        }

                        @Override
                        public int getY() {
                            return drawing.getY();
                        }
                    };
                }
            };
        }

        public static interface Glypher {
            public void paintShape(Graphics var1);

            public void drawShape(Drawing var1);
        }
    }

    private static abstract class PolygonShape
    extends DrawingShape {
        private boolean isFill_;

        PolygonShape(String name, boolean isFill) {
            super(name, XYShapes.getPixelMaxCacheRadius(isFill));
            this.isFill_ = isFill;
        }

        abstract Polygon createPolygon(int var1, int var2);

        @Override
        public DrawingShape.Glypher createGlypher(int dx, int dy) {
            final Polygon polygon = this.createPolygon(dx, dy);
            if (this.isFill_) {
                return new DrawingShape.Glypher(){

                    @Override
                    public void paintShape(Graphics g) {
                        g.fillPolygon(polygon);
                    }

                    @Override
                    public void drawShape(Drawing d) {
                        d.fill(polygon);
                    }
                };
            }
            return new DrawingShape.Glypher(){

                @Override
                public void paintShape(Graphics g) {
                    g.drawPolygon(polygon);
                }

                @Override
                public void drawShape(Drawing d) {
                    int n = polygon.npoints;
                    int[] xs = polygon.xpoints;
                    int[] ys = polygon.ypoints;
                    for (int i = 0; i < n - 1; ++i) {
                        d.drawLine(xs[i], ys[i], xs[i + 1], ys[i + 1]);
                    }
                    d.drawLine(xs[n - 1], ys[n - 1], xs[0], ys[0]);
                }
            };
        }
    }

    private static class BlockShape
    extends XYShape {
        BlockShape(String name) {
            super(name, 6);
        }

        @Override
        protected Glyph createGlyph(short sx, short sy) {
            if (sx == 0 && sy == 0) {
                return POINT;
            }
            final short ix = sx;
            final short iy = sy;
            return new Glyph(){

                @Override
                public void paintGlyph(Graphics g) {
                    g.fillRect(-ix, -iy, 2 * ix, 2 * iy);
                }

                @Override
                public Pixer createPixer(Rectangle clip) {
                    int xmin = Math.max(-ix, clip.x);
                    int ymin = Math.max(-iy, clip.y);
                    int xmax = Math.min(ix, clip.x + clip.width - 1);
                    int ymax = Math.min(iy, clip.y + clip.height - 1);
                    return new BlockPixer(xmin, xmax, ymin, ymax);
                }
            };
        }

        private static class BlockPixer
        implements Pixer {
            private final int xmin_;
            private final int xmax_;
            private final int ymax_;
            private int x_;
            private int y_;

            BlockPixer(int xmin, int xmax, int ymin, int ymax) {
                this.xmin_ = xmin;
                this.xmax_ = xmax;
                this.ymax_ = ymax;
                this.x_ = xmax;
                this.y_ = ymin - 1;
            }

            @Override
            public boolean next() {
                if (++this.x_ > this.xmax_) {
                    this.x_ = this.xmin_;
                    if (++this.y_ > this.ymax_) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public int getX() {
                return this.x_;
            }

            @Override
            public int getY() {
                return this.y_;
            }
        }
    }
}

