/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;
import uk.ac.starlink.ttools.plot2.paper.RgbImage;
import uk.ac.starlink.ttools.plot2.paper.RgbPaperType;

public class MonoPaperType
extends RgbPaperType
implements PaperType2D,
PaperType3D {
    private final int rgb_;
    private final Compositor compositor_;

    public MonoPaperType(Color color, Compositor compositor) {
        super("Monochrome", true);
        this.rgb_ = color.getRGB() & 0xFFFFFF;
        this.compositor_ = compositor;
    }

    @Override
    protected RgbPaperType.RgbPaper createPaper(Rectangle bounds) {
        return new MonoPaper(this, bounds);
    }

    @Override
    public void placeGlyph(Paper paper, double dx, double dy, Glyph glyph, Color color) {
        int gx = PlotUtil.ifloor(dx);
        int gy = PlotUtil.ifloor(dy);
        ((MonoPaper)paper).placeGlyph(gx, gy, glyph, color);
    }

    @Override
    public void placeGlyph(Paper paper, double dx, double dy, double dz, Glyph glyph, Color color) {
        int gx = PlotUtil.ifloor(dx);
        int gy = PlotUtil.ifloor(dy);
        ((MonoPaper)paper).placeGlyph(gx, gy, glyph, color);
    }

    private static class MonoPaper
    extends RgbPaperType.RgbPaper {
        private final int x0_;
        private final int y0_;
        private final Rectangle clip_;
        private final int rgb_;
        private final Compositor compositor_;
        private final float[] alphas_;
        private final float[] frgba_;
        private Color lastColor_;
        private float lastAlpha_;

        MonoPaper(MonoPaperType paperType, Rectangle bounds) {
            super(paperType, bounds);
            this.rgb_ = paperType.rgb_;
            this.x0_ = bounds.x;
            this.y0_ = bounds.y;
            this.clip_ = new Rectangle(bounds);
            this.compositor_ = paperType.compositor_;
            this.alphas_ = new float[bounds.width * bounds.height];
            this.frgba_ = new float[4];
        }

        @Override
        public void placeDecal(Decal decal) {
            Rectangle bounds = this.getBounds();
            boolean hasAlpha = !decal.isOpaque();
            RgbImage decalIm = RgbImage.createRgbImage(bounds.width, bounds.height, hasAlpha);
            int[] decalBuf = decalIm.getBuffer();
            int bg = decalBuf[0];
            Graphics2D g = decalIm.getImage().createGraphics();
            ((Graphics)g).translate(-bounds.x, -bounds.y);
            decal.paintDecal(g);
            g.dispose();
            int npix = bounds.width * bounds.height;
            if (hasAlpha) {
                for (int i = 0; i < npix; ++i) {
                    int rgba = decalBuf[i];
                    if (rgba == bg) continue;
                    int n = i;
                    this.alphas_[n] = this.alphas_[n] + Compositor.byteToFloat(rgba >> 24);
                }
            } else {
                for (int i = 0; i < npix; ++i) {
                    int rgba = decalBuf[i];
                    if (rgba == bg) continue;
                    assert ((rgba & 0xFFFFFF) == this.rgb_);
                    this.alphas_[i] = 1.0f;
                }
            }
        }

        public void placeGlyph(int gx, int gy, Glyph glyph, Color color) {
            this.clip_.x -= gx;
            this.clip_.y -= gy;
            Pixer pixer = glyph.createPixer(this.clip_);
            if (pixer != null) {
                this.placePixels(gx - this.x0_, gy - this.y0_, pixer, color);
            }
            this.clip_.x += gx;
            this.clip_.y += gy;
        }

        private void placePixels(int xoff, int yoff, Pixer pixer, Color color) {
            if (color != this.lastColor_) {
                this.lastColor_ = color;
                assert ((color.getRGB() & 0xFFFFFF) == this.rgb_);
                color.getRGBComponents(this.frgba_);
                this.lastAlpha_ = this.frgba_[3];
            }
            float alpha = this.lastAlpha_;
            while (pixer.next()) {
                int index;
                int n = index = this.getPixelIndex(xoff, yoff, pixer);
                this.alphas_[n] = this.alphas_[n] + alpha;
            }
        }

        @Override
        public void flush() {
            int[] rgbs = this.getRgbImage().getBuffer();
            int npix = rgbs.length;
            for (int i = 0; i < npix; ++i) {
                float rawAlpha = Math.min(this.alphas_[i], 1.0f);
                if (rawAlpha == 0.0f) continue;
                float scaleAlpha = this.compositor_.scaleAlpha(rawAlpha);
                int rgba = this.rgb_ | Compositor.floatToByte(scaleAlpha) << 24;
                rgbs[i] = Compositor.srcOverOpaque(rgba, rgbs[i]);
            }
        }
    }
}

