/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.RgbPaperType3D;
import uk.ac.starlink.util.DoubleList;

public class PixelStackPaperType3D
extends RgbPaperType3D {
    private final Compositor compositor_;
    private final FloatPacker alphaPacker_;

    public PixelStackPaperType3D(Compositor compositor, float minAlpha) {
        super("PixelStack", true);
        this.compositor_ = compositor;
        this.alphaPacker_ = minAlpha < 0.003921569f ? PixelStackPaperType3D.createLogFloatPacker(minAlpha) : PixelStackPaperType3D.createLinearFloatPacker();
    }

    @Override
    protected RgbPaperType3D.RgbPaper3D createPaper3D(Rectangle bounds) {
        return new PixelStackPaper(this, bounds);
    }

    private static FloatPacker createLinearFloatPacker() {
        return new FloatPacker(){

            @Override
            public int floatToByte(float fv) {
                return (int)Math.ceil(fv * 255.0f);
            }

            @Override
            public float byteToFloat(int iv) {
                return Compositor.byteToFloat(iv);
            }
        };
    }

    private static FloatPacker createLogFloatPacker(final float minAlpha) {
        final double scale = Math.log(minAlpha) / 255.0;
        final double scale1 = 1.0 / scale;
        return new FloatPacker(){

            @Override
            public int floatToByte(float fv) {
                int iv;
                int n = iv = fv <= minAlpha ? 255 : (int)(Math.log(fv) * scale1);
                assert (iv >= 0 && iv <= 255) : fv + " -> " + iv;
                return iv;
            }

            @Override
            public float byteToFloat(int iv) {
                float fv = (float)Math.exp((double)(iv & 0xFF) * scale);
                assert (fv >= 0.0f && fv <= 1.0f) : iv + " -> " + fv;
                return fv;
            }
        };
    }

    private static interface FloatPacker {
        public int floatToByte(float var1);

        public float byteToFloat(int var1);
    }

    private static class PixelStack {
        private final FloatPacker alphaPacker_;
        private final DoubleList list_;

        PixelStack(FloatPacker alphaPacker) {
            this.alphaPacker_ = alphaPacker;
            this.list_ = new DoubleList();
        }

        public void addPixel(double dz, int rgb, float alpha) {
            this.list_.add(this.pack(dz, rgb, alpha));
        }

        public int getStackRgb(Compositor.Buffer cbuf1) {
            cbuf1.clear();
            int npix = this.list_.size();
            if (npix == 1) {
                double v = this.list_.get(0);
                int rgba = this.unpackRgbPackedAlpha(this.list_.get(0));
                cbuf1.addSample(0, rgba, this.alphaPacker_.byteToFloat(rgba >> 24));
            } else {
                assert (npix > 1);
                double[] array = this.list_.toDoubleArray();
                Arrays.sort(array);
                boolean done = false;
                for (int i = 0; i < npix && !done; ++i) {
                    int rgba = this.unpackRgbPackedAlpha(array[i]);
                    done = cbuf1.addSample(0, rgba, this.alphaPacker_.byteToFloat(rgba >> 24));
                }
            }
            return cbuf1.toRgbInt(0);
        }

        private double pack(double dz, int rgb, float alpha) {
            int ialpha = this.alphaPacker_.floatToByte(alpha);
            int rgba = rgb & 0xFFFFFF | ialpha << 24;
            return Double.longBitsToDouble(Double.doubleToLongBits(dz) & 0xFFFFFFFF00000000L | (long)rgba & 0xFFFFFFFFL);
        }

        private double unpackZ(double packed) {
            return Double.longBitsToDouble(Double.doubleToLongBits(packed) & 0xFFFFFFFF00000000L);
        }

        private int unpackRgbPackedAlpha(double packed) {
            return (int)(Double.doubleToLongBits(packed) & 0xFFFFFFFFL);
        }
    }

    private static class PixelStackPaper
    extends RgbPaperType3D.RgbPaper3D {
        private final Compositor compositor_;
        private final FloatPacker alphaPacker_;
        private final PixelStack[] stacks_;
        private final float[] frgba_;
        private Color lastColor_;
        private int lastRgb_;
        private float lastAlpha_;

        PixelStackPaper(PixelStackPaperType3D paperType, Rectangle bounds) {
            super(paperType, bounds);
            this.compositor_ = paperType.compositor_;
            this.alphaPacker_ = paperType.alphaPacker_;
            this.stacks_ = new PixelStack[bounds.width * bounds.height];
            this.frgba_ = new float[4];
        }

        @Override
        protected void placePixels(int xoff, int yoff, double dz, Pixer pixer, Color color) {
            if (color != this.lastColor_) {
                this.lastColor_ = color;
                int rgba = color.getRGB();
                this.lastRgb_ = rgba & 0xFFFFFF;
                color.getRGBComponents(this.frgba_);
                this.lastAlpha_ = this.frgba_[3];
            }
            int rgb = this.lastRgb_;
            float alpha = this.lastAlpha_;
            while (pixer.next()) {
                int index = this.getPixelIndex(xoff, yoff, pixer);
                PixelStack stack = this.stacks_[index];
                if (stack == null) {
                    this.stacks_[index] = stack = new PixelStack(this.alphaPacker_);
                }
                stack.addPixel(dz, rgb, alpha);
            }
        }

        @Override
        public void flush() {
            int[] rgbs = this.getRgbImage().getBuffer();
            Compositor.Buffer cbuf1 = this.compositor_.createBuffer(1);
            int npix = rgbs.length;
            for (int i = 0; i < npix; ++i) {
                PixelStack stack = this.stacks_[i];
                if (stack == null) continue;
                rgbs[i] = Compositor.srcOverOpaque(stack.getStackRgb(cbuf1), rgbs[i]);
            }
        }
    }
}

