/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;
import uk.ac.starlink.ttools.plot2.paper.RgbPaperType;

public abstract class RgbPaperType3D
extends RgbPaperType
implements PaperType3D {
    protected RgbPaperType3D(String name, boolean upLayer) {
        super(name, upLayer);
    }

    @Override
    public void placeGlyph(Paper paper, double dx, double dy, double dz, Glyph glyph, Color color) {
        int gx = PlotUtil.ifloor(dx);
        int gy = PlotUtil.ifloor(dy);
        ((RgbPaper3D)paper).placeGlyph(gx, gy, dz, glyph, color);
    }

    @Override
    protected RgbPaperType.RgbPaper createPaper(Rectangle bounds) {
        return this.createPaper3D(bounds);
    }

    protected abstract RgbPaper3D createPaper3D(Rectangle var1);

    protected static abstract class RgbPaper3D
    extends RgbPaperType.RgbPaper {
        private final int x0_;
        private final int y0_;
        private final Rectangle clip_;

        public RgbPaper3D(PaperType paperType, Rectangle bounds) {
            super(paperType, bounds);
            this.x0_ = bounds.x;
            this.y0_ = bounds.y;
            this.clip_ = new Rectangle(bounds);
        }

        private void placeGlyph(int gx, int gy, double dz, Glyph glyph, Color color) {
            this.clip_.x -= gx;
            this.clip_.y -= gy;
            Pixer pixer = glyph.createPixer(this.clip_);
            if (pixer != null) {
                this.placePixels(gx - this.x0_, gy - this.y0_, dz, pixer, color);
            }
            this.clip_.x += gx;
            this.clip_.y += gy;
        }

        protected abstract void placePixels(int var1, int var2, double var3, Pixer var5, Color var6);
    }
}

