/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.ttools.plot.Point3D;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.paper.PaintPaperType;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class SortedPaperType3D
extends PaintPaperType
implements PaperType3D {
    public SortedPaperType3D() {
        super("Sorted", true);
    }

    @Override
    protected Paper createPaper(Graphics g, Rectangle bounds) {
        return new SortedPaper3D(this, g);
    }

    @Override
    public void placeGlyph(Paper paper, double dx, double dy, double dz, Glyph glyph, Color color) {
        assert (dx >= -32768.0 && dx <= 32767.0 && dy >= -32768.0 && dy <= 32767.0) : "uh-oh";
        short gx = (short)dx;
        short gy = (short)dy;
        ((SortedPaper3D)paper).placeGlyph(gx, gy, dz, glyph, color);
    }

    @Override
    public void placeDecal(Paper paper, Decal decal) {
        ((SortedPaper3D)paper).placeDecal(decal);
    }

    @Override
    protected void flushPaper(Paper paper) {
        ((SortedPaper3D)paper).flush();
    }

    private static class PlacedGlyph
    extends Point3D {
        final short gx_;
        final short gy_;
        final Glyph glyph_;
        final Color color_;

        PlacedGlyph(Glyph glyph, short gx, short gy, double dz, Color color, int iseq) {
            super(iseq, dz);
            this.gx_ = gx;
            this.gy_ = gy;
            this.glyph_ = glyph;
            this.color_ = color;
        }
    }

    private static class SortedPaper3D
    implements Paper {
        final PaperType paperType_;
        final Graphics graphics_;
        List<PlacedGlyph> list_;
        int iseq_;

        SortedPaper3D(PaperType paperType, Graphics graphics) {
            this.paperType_ = paperType;
            this.graphics_ = graphics;
            this.list_ = new ArrayList<PlacedGlyph>();
        }

        @Override
        public PaperType getPaperType() {
            return this.paperType_;
        }

        void placeGlyph(short gx, short gy, double dz, Glyph glyph, Color color) {
            this.list_.add(new PlacedGlyph(glyph, gx, gy, dz, color, this.iseq_++));
        }

        void placeDecal(Decal decal) {
            decal.paintDecal(this.graphics_);
        }

        void flush() {
            List<PlacedGlyph> points = this.getSortedPoints();
            Color color0 = this.graphics_.getColor();
            for (PlacedGlyph pg : points) {
                short px = pg.gx_;
                short py = pg.gy_;
                this.graphics_.setColor(pg.color_);
                this.graphics_.translate(px, py);
                pg.glyph_.paintGlyph(this.graphics_);
                this.graphics_.translate(-px, -py);
            }
            this.graphics_.setColor(color0);
        }

        List<PlacedGlyph> getSortedPoints() {
            if (!SortedPaper3D.singleColor(this.list_)) {
                Collections.sort(this.list_, Point3D.getComparator(false, true));
            }
            return this.list_;
        }

        private static boolean singleColor(List<PlacedGlyph> list) {
            if (list.size() > 0) {
                Iterator<PlacedGlyph> it = list.iterator();
                Color color = it.next().color_;
                while (it.hasNext()) {
                    if (PlotUtil.equals(color, it.next().color_)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

