/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.io.IOException;
import java.util.ArrayList;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.data.AbstractDataSpec;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

public class ColumnDataSpec
extends AbstractDataSpec {
    private final StarTable table_;
    private final int nCoord_;
    private final Coord[] coords_;
    private final int[][] userCoordColIndices_;
    private static final Object ALL_MASK = new String("ALL");

    public ColumnDataSpec(StarTable table, Coord[] coords, int[][] userCoordColIndices) {
        this.nCoord_ = coords.length;
        if (userCoordColIndices.length != this.nCoord_) {
            throw new IllegalArgumentException("coord count mismatch");
        }
        this.table_ = table;
        this.coords_ = coords;
        this.userCoordColIndices_ = userCoordColIndices;
    }

    @Override
    public StarTable getSourceTable() {
        return this.table_;
    }

    @Override
    public int getCoordCount() {
        return this.coords_.length;
    }

    @Override
    public Object getCoordId(int ic) {
        int[] icols = this.userCoordColIndices_[ic];
        ArrayList<Integer> iclist = new ArrayList<Integer>(icols.length);
        for (int iu = 0; iu < icols.length; ++iu) {
            iclist.add(icols[iu]);
        }
        return iclist;
    }

    @Override
    public Coord getCoord(int ic) {
        return this.coords_[ic];
    }

    @Override
    public Object getMaskId() {
        return ALL_MASK;
    }

    @Override
    public ValueInfo[] getUserCoordInfos(int ic) {
        int[] icols = this.userCoordColIndices_[ic];
        ValueInfo[] infos = new ValueInfo[icols.length];
        for (int iu = 0; iu < icols.length; ++iu) {
            infos[iu] = this.table_.getColumnInfo(icols[iu]);
        }
        return infos;
    }

    @Override
    public UserDataReader createUserDataReader() {
        final Object[][] userRows = new Object[this.nCoord_][];
        for (int ic = 0; ic < this.nCoord_; ++ic) {
            int[] icols = this.userCoordColIndices_[ic];
            userRows[ic] = new Object[icols.length];
        }
        return new UserDataReader(){

            @Override
            public boolean getMaskFlag(RowSequence rseq, long irow) {
                return true;
            }

            @Override
            public Object[] getUserCoordValues(RowSequence rseq, long irow, int icoord) throws IOException {
                Object[] userRow = userRows[icoord];
                int[] icols = ColumnDataSpec.this.userCoordColIndices_[icoord];
                for (int iu = 0; iu < userRow.length; ++iu) {
                    userRow[iu] = rseq.getCell(icols[iu]);
                }
                return userRow;
            }
        };
    }

    @Override
    public boolean isCoordBlank(int icoord) {
        return false;
    }
}

