/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.ttools.plot2.data.CachedDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.MemoryColumnFactory;
import uk.ac.starlink.ttools.plot2.data.SimpleDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.SmartColumnFactory;

public class DataStoreParameter
extends ChoiceParameter<DataStoreFactory> {
    public static final DataStoreFactory SIMPLE = new SimpleDataStoreFactory();
    public static final DataStoreFactory BASIC_CACHE = new CachedDataStoreFactory(new MemoryColumnFactory());
    public static final DataStoreFactory SMART_CACHE = new CachedDataStoreFactory(new SmartColumnFactory(new MemoryColumnFactory()));

    public DataStoreParameter(String name) {
        super(name, DataStoreFactory.class);
        this.addOption(SIMPLE, "simple");
        this.addOption(SMART_CACHE, "cache");
        this.addOption(BASIC_CACHE, "basic-cache");
        this.setDefaultOption(SIMPLE);
        this.setPrompt("Data storage policy");
        this.setDescription(new String[]{"<p>Determines the way that data is accessed when constructing", "the plot.", "There are two basic options, cached or not.", "</p>", "<p>If no caching is used (<code>" + this.getName(SIMPLE) + "</code>)", "then rows are read sequentially from the specified input table(s)", "every time they are required.", "This generally requires a small memory footprint", "(though that can depend on how the table is specified)", "and makes sense if the data only needs to be scanned once", "or perhaps if the table is very large.", "</p>", "<p>If caching is used", "(<code>" + this.getName(SMART_CACHE) + "</code>)", "then the required data is read once", "from the specified input table(s) and cached", "before any plotting is performed,", "and plots are done using this cached data.", "This may use a significant amount of memory for large tables", "but it's usually more sensible (faster)", "if the data will need to be scanned multiple times.", "</p>"});
    }

    public void setDefaultCaching(boolean caching) {
        this.setDefaultOption(this.getDefaultForCaching(caching));
    }

    public DataStoreFactory getDefaultForCaching(boolean isCachingSensible) {
        return isCachingSensible ? SMART_CACHE : SIMPLE;
    }
}

