/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Arrays;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.data.AbstractDataSpec;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;
import uk.ac.starlink.ttools.plot2.task.CoordValue;

public class JELDataSpec
extends AbstractDataSpec {
    private final StarTable table_;
    private final String maskExpr_;
    private final CoordValue[] coordValues_;
    private final ValueInfo[][] userCoordInfos_;
    private final JELKey maskId_;
    private final JELKey[] coordIds_;
    private static final JELKey ALL_MASK = new JELKey(new String[]{new String("true")});

    public JELDataSpec(StarTable table, String maskExpr, CoordValue[] coordValues) throws TaskException {
        this.table_ = table;
        this.maskExpr_ = maskExpr;
        this.coordValues_ = coordValues;
        int nCoord = coordValues.length;
        this.maskId_ = maskExpr == null || "true".equals(maskExpr.trim()) ? ALL_MASK : new JELKey(new String[]{maskExpr});
        this.coordIds_ = new JELKey[nCoord];
        for (int ic = 0; ic < nCoord; ++ic) {
            this.coordIds_[ic] = new JELKey(coordValues[ic].getExpressions());
        }
        JELUserDataReader dataRdr = this.createJELUserDataReader();
        this.userCoordInfos_ = new ValueInfo[nCoord][];
        for (int ic = 0; ic < nCoord; ++ic) {
            int nu = coordValues[ic].getExpressions().length;
            this.userCoordInfos_[ic] = new ValueInfo[nu];
            for (int iu = 0; iu < nu; ++iu) {
                this.userCoordInfos_[ic][iu] = dataRdr.userCoordReaders_[ic][iu].getValueInfo();
            }
        }
    }

    @Override
    public StarTable getSourceTable() {
        return this.table_;
    }

    @Override
    public int getCoordCount() {
        return this.coordValues_.length;
    }

    @Override
    public Object getCoordId(int ic) {
        return this.coordIds_[ic];
    }

    @Override
    public Coord getCoord(int ic) {
        return this.coordValues_[ic].getCoord();
    }

    @Override
    public Object getMaskId() {
        return this.maskId_;
    }

    @Override
    public ValueInfo[] getUserCoordInfos(int ic) {
        return this.userCoordInfos_[ic];
    }

    @Override
    public UserDataReader createUserDataReader() {
        try {
            return this.createJELUserDataReader();
        }
        catch (TaskException e) {
            throw new AssertionError((Object)"Well it worked last time.");
        }
    }

    @Override
    public boolean isCoordBlank(int icoord) {
        for (String expr : this.coordValues_[icoord].getExpressions()) {
            if (expr == null || expr.trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public String[] getCoordExpressions(int ic) {
        return (String[])this.coordIds_[ic].exprs_.clone();
    }

    private JELUserDataReader createJELUserDataReader() throws TaskException {
        return new JELUserDataReader(this.table_, this.maskExpr_, this.coordValues_);
    }

    private static ValueReader createValueReader(String expr, StarTable table, RowSequenceEvaluator evaluator, Library lib, Object fallback, Class<?> reqClazz) throws TaskException {
        CompiledExpression compex;
        if (expr == null || expr.trim().length() == 0) {
            return new FixedValueReader(fallback);
        }
        int ncol = table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            if (!expr.trim().equalsIgnoreCase(info.getName().trim())) continue;
            return new ColumnValueReader(table, icol);
        }
        try {
            compex = JELUtils.compile(lib, table, expr);
        }
        catch (CompilationException e) {
            throw new TaskException("Bad Expression \"" + expr + "\"", (Throwable)e);
        }
        Class<?> exprClazz = compex.getTypeC();
        if (!reqClazz.isAssignableFrom(exprClazz)) {
            String msg = new StringBuffer().append("Expression wrong type: ").append('\"').append(expr).append('\"').append(" is ").append(exprClazz.getName()).append(" not ").append(reqClazz.getName()).toString();
            throw new TaskException(msg);
        }
        return new JelValueReader(evaluator, compex, expr);
    }

    @Equality
    private static class JELKey {
        private final String[] exprs_;

        JELKey(String[] exprs) {
            this.exprs_ = (String[])exprs.clone();
        }

        public boolean equals(Object other) {
            return other instanceof JELKey && Arrays.equals(this.exprs_, ((JELKey)other).exprs_);
        }

        public int hashCode() {
            return Arrays.hashCode(this.exprs_);
        }
    }

    private static class RowSequenceEvaluator
    extends StarTableJELRowReader {
        private RowSequence rseq_;
        private long irow_;

        RowSequenceEvaluator(StarTable table) {
            super(table);
        }

        @Override
        public long getCurrentRow() {
            return this.irow_;
        }

        @Override
        protected Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        public Object evaluateObject(CompiledExpression compex, RowSequence rseq, long irow) throws IOException {
            this.rseq_ = rseq;
            this.irow_ = irow;
            try {
                return this.evaluate(compex);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                return null;
            }
        }
    }

    private static class JelValueReader
    implements ValueReader {
        private final RowSequenceEvaluator evaluator_;
        private final CompiledExpression compex_;
        private final ValueInfo info_;
        private RowSequence rseq_;
        private long irow_;

        JelValueReader(RowSequenceEvaluator evaluator, CompiledExpression compex, String expr) {
            this.evaluator_ = evaluator;
            this.compex_ = compex;
            this.info_ = new DefaultValueInfo(expr, compex.getTypeC(), null);
        }

        @Override
        public Object readValue(RowSequence rseq, long irow) throws IOException {
            return this.evaluator_.evaluateObject(this.compex_, rseq, irow);
        }

        @Override
        public ValueInfo getValueInfo() {
            return this.info_;
        }
    }

    private static class ColumnValueReader
    implements ValueReader {
        private final int icol_;
        private final ValueInfo info_;

        ColumnValueReader(StarTable table, int icol) {
            this.icol_ = icol;
            this.info_ = table.getColumnInfo(icol);
        }

        @Override
        public Object readValue(RowSequence rseq, long irow) throws IOException {
            return rseq.getCell(this.icol_);
        }

        @Override
        public ValueInfo getValueInfo() {
            return this.info_;
        }
    }

    private static class FixedValueReader
    implements ValueReader {
        private final Object value_;

        private FixedValueReader(Object value) {
            this.value_ = value;
        }

        @Override
        public Object readValue(RowSequence rseq, long irow) {
            return this.value_;
        }

        @Override
        public ValueInfo getValueInfo() {
            return null;
        }
    }

    private static interface ValueReader {
        public Object readValue(RowSequence var1, long var2) throws IOException;

        public ValueInfo getValueInfo();
    }

    private static class JELUserDataReader
    implements UserDataReader {
        private final ValueReader maskReader_;
        private final ValueReader[][] userCoordReaders_;
        private final Object[][] userCoordRows_;

        JELUserDataReader(StarTable table, String maskExpr, CoordValue[] coordValues) throws TaskException {
            RowSequenceEvaluator evaluator = new RowSequenceEvaluator(table);
            Library lib = JELUtils.getLibrary(evaluator);
            this.maskReader_ = JELDataSpec.createValueReader(maskExpr, table, evaluator, lib, Boolean.TRUE, Boolean.TYPE);
            int nCoord = coordValues.length;
            this.userCoordRows_ = new Object[nCoord][];
            this.userCoordReaders_ = new ValueReader[nCoord][];
            for (int ic = 0; ic < nCoord; ++ic) {
                CoordValue coordVal = coordValues[ic];
                Input[] inputs = coordVal.getCoord().getInputs();
                String[] ucexprs = coordVal.getExpressions();
                int nu = ucexprs.length;
                this.userCoordRows_[ic] = new Object[nu];
                ValueReader[] vrdrs = new ValueReader[nu];
                for (int iu = 0; iu < nu; ++iu) {
                    vrdrs[iu] = JELDataSpec.createValueReader(ucexprs[iu], table, evaluator, lib, null, inputs[iu].getValueClass());
                }
                this.userCoordReaders_[ic] = vrdrs;
            }
        }

        @Override
        public boolean getMaskFlag(RowSequence rseq, long irow) throws IOException {
            return Boolean.TRUE.equals(this.maskReader_.readValue(rseq, irow));
        }

        @Override
        public Object[] getUserCoordValues(RowSequence rseq, long irow, int icoord) throws IOException {
            ValueReader[] vrdrs = this.userCoordReaders_[icoord];
            int nu = vrdrs.length;
            Object[] userRow = this.userCoordRows_[icoord];
            for (int iu = 0; iu < nu; ++iu) {
                userRow[iu] = vrdrs[iu].readValue(rseq, irow);
            }
            return userRow;
        }
    }
}

