/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.Padding;

public class PaddingParameter
extends Parameter<Padding> {
    public PaddingParameter(String name) {
        super(name, Padding.class, true);
        this.setUsage("<top>,<left>,<bottom>,<right>");
        this.setNullPermitted(true);
    }

    public Padding stringToObject(Environment env, String stringval) throws TaskException {
        String[] svals = stringval.split(",", -1);
        if (svals.length != 4) {
            throw new ParameterValueException((Parameter)this, "Not 4 comma-separated values");
        }
        Integer[] ivals = new Integer[4];
        for (int i = 0; i < 4; ++i) {
            String sv = svals[i].trim();
            if (sv.length() <= 0) continue;
            try {
                ivals[i] = Integer.valueOf(sv);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParameterValueException((Parameter)this, "Not integer: " + sv);
            }
        }
        return new Padding(ivals[0], ivals[1], ivals[2], ivals[3]);
    }

    public String objectToString(Environment env, Padding padding) {
        String spad = new StringBuffer().append(PaddingParameter.toString(padding.getTop())).append(",").append(PaddingParameter.toString(padding.getLeft())).append(",").append(PaddingParameter.toString(padding.getBottom())).append(",").append(PaddingParameter.toString(padding.getRight())).toString();
        return spad.equals(",,,") ? null : spad;
    }

    private static String toString(Integer value) {
        return value == null ? "" : value.toString();
    }
}

