/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;

public abstract class PlotContext {
    private final PlotType plotType_;
    private final DataGeom[] exampleGeoms_;
    private final GangerFactory gangerFact_;

    protected PlotContext(PlotType plotType, DataGeom[] exampleGeoms, GangerFactory gangerFact) {
        this.plotType_ = plotType;
        this.exampleGeoms_ = exampleGeoms;
        this.gangerFact_ = gangerFact;
    }

    public PlotType getPlotType() {
        return this.plotType_;
    }

    public DataGeom[] getExampleGeoms() {
        return this.exampleGeoms_;
    }

    public GangerFactory getGangerFactory() {
        return this.gangerFact_;
    }

    public abstract Parameter[] getGeomParameters(String var1);

    public abstract DataGeom getGeom(Environment var1, String var2) throws TaskException;

    public static PlotContext createStandardContext(PlotType plotType, GangerFactory gangerFact) {
        final DataGeom[] geoms = plotType.getPointDataGeoms();
        return new PlotContext(plotType, geoms, gangerFact){

            @Override
            public Parameter[] getGeomParameters(String suffix) {
                return new Parameter[]{this.createGeomParameter(suffix)};
            }

            @Override
            public DataGeom getGeom(Environment env, String suffix) throws TaskException {
                return (DataGeom)new ParameterFinder<Parameter<DataGeom>>(){

                    @Override
                    public Parameter<DataGeom> createParameter(String sfix) {
                        return this.createGeomParameter(sfix);
                    }
                }.getParameter(env, suffix).objectValue(env);
            }

            private Parameter<DataGeom> createGeomParameter(String suffix) {
                return new DataGeomParameter("geom" + suffix, geoms);
            }
        };
    }

    public static PlotContext createFixedContext(PlotType plotType, final DataGeom geom, GangerFactory gangerFact) {
        return new PlotContext(plotType, new DataGeom[]{geom}, gangerFact){

            @Override
            public Parameter[] getGeomParameters(String suffix) {
                return new Parameter[0];
            }

            @Override
            public DataGeom getGeom(Environment env, String suffix) {
                return geom;
            }
        };
    }

    private static class DataGeomParameter
    extends ChoiceParameter<DataGeom> {
        public DataGeomParameter(String name, DataGeom[] geoms) {
            super(name, (Object[])geoms);
            this.setDefaultOption(geoms[0]);
        }

        public String stringifyOption(DataGeom geom) {
            return geom.getVariantName();
        }
    }
}

