/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.IndicatedRow;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.NavigationListener;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.SingleGanger;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.PlotCaching;
import uk.ac.starlink.ttools.plot2.task.PointSelectionEvent;
import uk.ac.starlink.ttools.plot2.task.PointSelectionListener;

public class PlotDisplay<P, A>
extends JComponent {
    private final Ganger<P, A> ganger_;
    private final DataStore dataStore_;
    private final SurfaceFactory<P, A> surfFact_;
    private final int nz_;
    private final PaperTypeSelector ptSel_;
    private final Compositor compositor_;
    private final boolean surfaceAuxRanging_;
    private final boolean cacheImage_;
    private final List<PointSelectionListener> pslList_;
    private final Executor clickExecutor_;
    private final Zone<P, A>[] zones_;
    private Gang gang_;
    private Decoration navDecoration_;
    public static final String ASPECTS_PROPERTY = "Plot2Aspects";
    private static final boolean WITH_SCROLL = true;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.task");

    public PlotDisplay(Ganger<P, A> ganger, SurfaceFactory<P, A> surfFact, int nz, ZoneContent[] zoneContents, P[] profiles, A[] aspects, ShadeAxisFactory[] shadeFacts, Range[] shadeFixRanges, final Navigator<A> navigator, PaperTypeSelector ptSel, Compositor compositor, DataStore dataStore, PlotCaching caching) {
        this.ganger_ = ganger;
        this.surfFact_ = surfFact;
        this.nz_ = nz;
        this.zones_ = new Zone[this.nz_];
        profiles = ganger.adjustProfiles((Object[])profiles.clone());
        boolean usePlans = caching.getUsePlans();
        Object[] okAspects = ganger.adjustAspects((Object[])aspects.clone(), -1);
        for (int iz = 0; iz < this.nz_; ++iz) {
            this.zones_[iz] = new Zone<P, Object>(zoneContents[iz], profiles[iz], shadeFacts[iz], shadeFixRanges[iz], okAspects[iz], usePlans);
        }
        this.ptSel_ = ptSel;
        this.compositor_ = compositor;
        this.dataStore_ = dataStore;
        this.surfaceAuxRanging_ = !caching.getReuseRanges();
        this.cacheImage_ = caching.getCacheImage();
        this.pslList_ = new ArrayList<PointSelectionListener>();
        if (navigator != null) {
            new NavigationListener<A>(){

                @Override
                public int getSurfaceIndex(Point pos) {
                    return PlotDisplay.this.gang_.getNavigationZoneIndex(pos);
                }

                @Override
                public Surface getSurface(int isurf) {
                    return isurf >= 0 ? ((PlotDisplay)PlotDisplay.this).zones_[isurf].surface_ : null;
                }

                @Override
                public Navigator<A> getNavigator(int isurf) {
                    return navigator;
                }

                @Override
                public Iterable<double[]> createDataPosIterable(Point pos) {
                    int iz = PlotDisplay.this.getZoneIndex(pos);
                    if (iz >= 0) {
                        PlotLayer[] layers = ((PlotDisplay)PlotDisplay.this).zones_[iz].content_.getLayers();
                        return new PointCloud(SubCloud.createSubClouds(layers, true)).createDataPosIterable(PlotDisplay.this.dataStore_);
                    }
                    return null;
                }

                @Override
                protected void setAspect(int isurf, A aspect) {
                    Object[] aspects = (Object[])PlotDisplay.this.getAspects().clone();
                    aspects[isurf] = aspect;
                    PlotDisplay.this.setAspects(PlotDisplay.this.ganger_.adjustAspects(aspects, isurf));
                }

                @Override
                protected void setDecoration(Decoration dec) {
                    PlotDisplay.this.setNavDecoration(dec);
                }
            }.addListeners(this);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                final Point p = evt.getPoint();
                final int iz = PlotDisplay.this.getZoneIndex(p);
                if (iz >= 0 && PlotDisplay.this.pslList_.size() > 0) {
                    Zone zone = PlotDisplay.this.zones_[iz];
                    final Surface surface = zone.surface_;
                    final PlotLayer[] layers = zone.content_.getLayers();
                    if (surface != null && layers.length > 0 && surface.getPlotBounds().contains(p)) {
                        PlotDisplay.this.clickExecutor_.execute(new Runnable(){

                            @Override
                            public void run() {
                                long[] closestRows = PlotDisplay.this.findClosestRows(surface, layers, p);
                                if (closestRows != null) {
                                    final PointSelectionEvent evt = new PointSelectionEvent(PlotDisplay.this, p, iz, closestRows);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            for (PointSelectionListener psl : PlotDisplay.this.pslList_) {
                                                psl.pointSelected(evt);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        });
        this.clickExecutor_ = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, "Point Identifier");
                th.setDaemon(true);
                return th;
            }
        });
    }

    public PlotDisplay(SurfaceFactory<P, A> surfFact, PlotLayer[] layers, P profile, Icon legend, float[] legPos, String title, A aspect, ShadeAxisFactory shadeFact, Range shadeFixRange, Navigator<A> navigator, PaperTypeSelector ptSel, Compositor compositor, Padding padding, DataStore dataStore, PlotCaching caching) {
        this(new SingleGanger(padding), surfFact, 1, new ZoneContent[]{new ZoneContent(layers, legend, legPos, title)}, PlotUtil.singletonArray(profile), PlotUtil.singletonArray(aspect), new ShadeAxisFactory[]{shadeFact}, new Range[]{shadeFixRange}, navigator, ptSel, compositor, dataStore, caching);
    }

    public void clearPlot() {
        for (Zone<P, A> zone : this.zones_) {
            zone.surface_ = null;
            zone.icon_ = null;
        }
    }

    public void addPointSelectionListener(PointSelectionListener psl) {
        this.pslList_.add(psl);
    }

    public void removePointSelectionListener(PointSelectionListener psl) {
        this.pslList_.remove(psl);
    }

    @Override
    public void invalidate() {
        this.clearPlot();
        super.invalidate();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle extBox = PlotUtil.subtractInsets(new Rectangle(this.getSize()), this.getInsets());
        Rectangle[] dataBoxes = new Rectangle[this.nz_];
        boolean gotSurfs = true;
        for (int iz = 0; iz < this.nz_ && gotSurfs; ++iz) {
            Surface surf = this.zones_[iz].surface_;
            if (surf != null) {
                dataBoxes[iz] = surf.getPlotBounds();
                continue;
            }
            this.zones_[iz].icon_ = null;
            gotSurfs = false;
        }
        Gang gang = gotSurfs ? this.ganger_.createGang(dataBoxes) : null;
        Gang approxGang = gang != null ? gang : this.createGang(extBox);
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            if (zone.surface_ != null) continue;
            ZoneContent content = zone.content_;
            Surface oldApproxSurf = zone.approxSurf_;
            zone.approxSurf_ = this.surfFact_.createSurface(approxGang.getZonePlotBounds(iz), zone.profile_, zone.aspect_);
            if (zone.auxRanges_ != null && (!this.surfaceAuxRanging_ || zone.approxSurf_.equals(oldApproxSurf))) continue;
            Object[] plans = zone.plans_ == null ? null : zone.plans_.toArray();
            zone.auxRanges_ = PlotDisplay.getAuxRanges(content.getLayers(), zone.approxSurf_, zone.shadeFixRange_, zone.shadeFact_, plans, this.dataStore_);
            Range shadeRange = zone.auxRanges_.get(AuxScale.COLOR);
            ShadeAxisFactory shadeFact = zone.shadeFact_;
            zone.shadeAxis_ = shadeRange != null && shadeFact != null ? shadeFact.createShadeAxis(shadeRange) : null;
        }
        if (gang == null) {
            gang = this.createGang(extBox);
        }
        this.gang_ = gang;
        long planStart = System.currentTimeMillis();
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            if (zone.icon_ != null) continue;
            ZoneContent content = zone.content_;
            PlotLayer[] layers = content.getLayers();
            zone.surface_ = this.surfFact_.createSurface(gang.getZonePlotBounds(iz), zone.profile_, zone.aspect_);
            Decoration[] decs = PlotPlacement.createPlotDecorations(zone.surface_, content.getLegend(), content.getLegendPosition(), content.getTitle(), zone.shadeAxis_);
            PlotPlacement placer = new PlotPlacement(extBox, zone.surface_, decs);
            LayerOpt[] opts = PaperTypeSelector.getOpts(layers);
            PaperType paperType = this.ptSel_.getPixelPaperType(opts, this.compositor_, this);
            zone.icon_ = PlotUtil.createPlotIcon(placer, layers, zone.auxRanges_, this.dataStore_, paperType, this.cacheImage_, zone.plans_);
        }
        PlotUtil.logTimeFromStart(logger_, "Plan", planStart);
        long paintStart = System.currentTimeMillis();
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            zone.icon_.paintIcon(this, g, extBox.x, extBox.y);
            if (this.cacheImage_) continue;
            zone.icon_ = null;
        }
        if (this.navDecoration_ != null) {
            this.navDecoration_.paintDecoration(g);
        }
        PlotUtil.logTimeFromStart(logger_, "Paint", paintStart);
    }

    public void setAspects(A[] aspects) {
        Object[] oldAspects = (Object[])aspects.clone();
        Arrays.fill(oldAspects, null);
        boolean changed = false;
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            oldAspects[iz] = zone.aspect_;
            A aspect = aspects[iz];
            if (aspect == null || aspect.equals(zone.aspect_)) continue;
            zone.aspect_ = aspect;
            zone.surface_ = null;
            zone.icon_ = null;
            changed = true;
        }
        if (changed) {
            this.repaint();
            this.firePropertyChange(ASPECTS_PROPERTY, oldAspects, aspects);
        }
    }

    private void setNavDecoration(Decoration dec) {
        if (!PlotUtil.equals(this.navDecoration_, dec)) {
            this.navDecoration_ = dec;
            this.repaint();
        }
    }

    public A[] getAspects() {
        A[] aspects = PlotUtil.createAspectArray(this.surfFact_, this.nz_);
        for (int iz = 0; iz < this.nz_; ++iz) {
            aspects[iz] = this.zones_[iz].aspect_;
        }
        return aspects;
    }

    public Surface[] getSurfaces() {
        Surface[] surfs = new Surface[this.nz_];
        for (int iz = 0; iz < this.nz_; ++iz) {
            surfs[iz] = this.zones_[iz].surface_;
        }
        return surfs;
    }

    private int getZoneIndex(Point pos) {
        for (int iz = 0; iz < this.nz_; ++iz) {
            Surface surf = this.zones_[iz].surface_;
            if (surf == null || !surf.getPlotBounds().contains(pos)) continue;
            return iz;
        }
        return -1;
    }

    private Gang createGang(Rectangle extBounds) {
        ZoneContent[] contents = new ZoneContent[this.nz_];
        A[] aspects = PlotUtil.createAspectArray(this.surfFact_, this.nz_);
        P[] profiles = PlotUtil.createProfileArray(this.surfFact_, this.nz_);
        ShadeAxis[] shadeAxes = new ShadeAxis[this.nz_];
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            contents[iz] = zone.content_;
            profiles[iz] = zone.profile_;
            aspects[iz] = zone.aspect_;
            shadeAxes[iz] = zone.shadeAxis_;
        }
        return this.ganger_.createGang(extBounds, this.surfFact_, this.nz_, contents, profiles, aspects, shadeAxes, true);
    }

    @Slow
    private long[] findClosestRows(Surface surface, PlotLayer[] layers, Point point) {
        int nl = layers.length;
        SubCloud[][] layerClouds = new SubCloud[nl][];
        LinkedHashMap<SubCloud, IndicatedRow> cloudMap = new LinkedHashMap<SubCloud, IndicatedRow>();
        for (int il = 0; il < nl; ++il) {
            SubCloud[] clouds = SubCloud.createSubClouds(new PlotLayer[]{layers[il]}, true);
            layerClouds[il] = clouds;
            for (SubCloud cloud : clouds) {
                cloudMap.put(cloud, null);
            }
        }
        for (SubCloud cloud : cloudMap.keySet()) {
            DataGeom geom = cloud.getDataGeom();
            int iPosCoord = cloud.getPosCoordIndex();
            TupleSequence tseq = this.dataStore_.getTupleSequence(cloud.getDataSpec());
            cloudMap.put(cloud, PlotUtil.getClosestRow(surface, geom, iPosCoord, tseq, point));
        }
        long[] closestRows = new long[nl];
        for (int il = 0; il < nl; ++il) {
            IndicatedRow bestRow = null;
            for (SubCloud cloud : layerClouds[il]) {
                double dist;
                IndicatedRow row = (IndicatedRow)cloudMap.get(cloud);
                if (row == null || !((dist = row.getDistance()) <= 4.0) || bestRow != null && !(dist < bestRow.getDistance())) continue;
                bestRow = row;
            }
            closestRows[il] = bestRow == null ? -1L : bestRow.getIndex();
        }
        return Thread.currentThread().isInterrupted() ? null : closestRows;
    }

    @Slow
    public static <P, A> PlotDisplay createPlotDisplay(PlotLayer[] layers, SurfaceFactory<P, A> surfFact, ConfigMap config, Icon legend, float[] legPos, String title, ShadeAxisFactory shadeFact, Range shadeFixRange, PaperTypeSelector ptSel, Compositor compositor, Padding padding, DataStore dataStore, boolean navigable, PlotCaching caching) {
        P profile = surfFact.createProfile(config);
        long t0 = System.currentTimeMillis();
        Range[] ranges = surfFact.useRanges(profile, config) ? surfFact.readRanges(profile, layers, dataStore) : null;
        PlotUtil.logTimeFromStart(logger_, "Range", t0);
        A aspect = surfFact.createAspect(profile, config, ranges);
        Navigator<A> navigator = navigable ? surfFact.createNavigator(config) : null;
        SingleGanger ganger = new SingleGanger(padding);
        ZoneContent[] contents = new ZoneContent[]{new ZoneContent(layers, legend, legPos, title)};
        A[] aspects = PlotUtil.singletonArray(aspect);
        P[] profiles = PlotUtil.singletonArray(profile);
        ShadeAxisFactory[] shadeFacts = new ShadeAxisFactory[]{shadeFact};
        Range[] shadeFixRanges = new Range[]{shadeFixRange};
        return new PlotDisplay(ganger, surfFact, 1, contents, profiles, aspects, shadeFacts, shadeFixRanges, navigator, ptSel, compositor, dataStore, caching);
    }

    @Slow
    public static <P, A> PlotDisplay<P, A> createGangDisplay(Ganger<P, A> ganger, SurfaceFactory<P, A> surfFact, int nz, ZoneContent[] contents, P[] profiles, ConfigMap[] aspectConfigs, ShadeAxisFactory[] shadeFacts, Range[] shadeFixRanges, Navigator<A> navigator, PaperTypeSelector ptSel, Compositor compositor, DataStore dataStore, PlotCaching caching) {
        A[] aspects = PlotUtil.createAspectArray(surfFact, nz);
        long t0 = System.currentTimeMillis();
        for (int iz = 0; iz < nz; ++iz) {
            P profile = profiles[iz];
            ConfigMap config = aspectConfigs[iz];
            Range[] ranges = surfFact.useRanges(profile, config) ? surfFact.readRanges(profile, contents[iz].getLayers(), dataStore) : null;
            aspects[iz] = surfFact.createAspect(profile, config, ranges);
        }
        PlotUtil.logTimeFromStart(logger_, "Range", t0);
        return new PlotDisplay<P, A>(ganger, surfFact, nz, contents, profiles, aspects, shadeFacts, shadeFixRanges, navigator, ptSel, compositor, dataStore, caching);
    }

    @Slow
    public static Map<AuxScale, Range> getAuxRanges(PlotLayer[] layers, Surface surface, Range shadeFixRange, ShadeAxisFactory shadeFact, Object[] plans, DataStore dataStore) {
        AuxScale[] scales = AuxScale.getAuxScales(layers);
        HashMap<AuxScale, Range> auxFixRanges = new HashMap<AuxScale, Range>();
        if (shadeFixRange != null) {
            auxFixRanges.put(AuxScale.COLOR, shadeFixRange);
        }
        HashMap<AuxScale, Boolean> auxLogFlags = new HashMap<AuxScale, Boolean>();
        if (shadeFact != null) {
            auxLogFlags.put(AuxScale.COLOR, shadeFact.isLog());
        }
        HashMap<AuxScale, Subrange> auxSubranges = new HashMap<AuxScale, Subrange>();
        AuxScale[] calcScales = AuxScale.getMissingScales(scales, new HashMap<AuxScale, Range>(), auxFixRanges);
        long start = System.currentTimeMillis();
        plans = plans == null ? new Object[]{} : plans;
        Map<AuxScale, Range> auxDataRanges = AuxScale.calculateAuxRanges(calcScales, layers, surface, plans, dataStore);
        PlotUtil.logTimeFromStart(logger_, "AuxRange", start);
        return AuxScale.getClippedRanges(scales, auxDataRanges, auxFixRanges, auxSubranges, auxLogFlags);
    }

    private static class Zone<P, A> {
        final ZoneContent content_;
        final P profile_;
        final ShadeAxisFactory shadeFact_;
        final Range shadeFixRange_;
        final Set<Object> plans_;
        A aspect_;
        Map<AuxScale, Range> auxRanges_;
        Surface approxSurf_;
        ShadeAxis shadeAxis_;
        Surface surface_;
        Icon icon_;

        Zone(ZoneContent content, P profile, ShadeAxisFactory shadeFact, Range shadeFixRange, A initialAspect, boolean usePlans) {
            this.content_ = content;
            this.profile_ = profile;
            this.shadeFact_ = shadeFact;
            this.shadeFixRange_ = shadeFixRange;
            this.aspect_ = initialAspect;
            this.plans_ = usePlans ? new HashSet() : null;
        }
    }
}

