/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.SingleGanger;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkyPlotType;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.task.ConfigParameter;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;
import uk.ac.starlink.ttools.plot2.task.PlotContext;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;

public class SkyPlot2Task
extends TypedPlot2Task {
    private static final String viewsysName_ = SkySurfaceFactory.VIEWSYS_KEY.getMeta().getShortName();

    public SkyPlot2Task() {
        super(SkyPlotType.getInstance(), null, new SkyPlotContext());
        Parameter viewsysParam = null;
        for (Parameter param : super.getParameters()) {
            if (!viewsysName_.equals(param.getName())) continue;
            viewsysParam = param;
        }
        viewsysParam.setNullPermitted(true);
        viewsysParam.setStringDefault(null);
        ((SkyPlotContext)this.getPlotContext()).setViewsysParameter((Parameter<SkySys>)viewsysParam);
    }

    private static class SkyPlotContext
    extends PlotContext {
        private Parameter<SkySys> viewsysParam_;

        SkyPlotContext() {
            super(SkyPlotType.getInstance(), new DataGeom[]{SkyDataGeom.GENERIC}, SingleGanger.FACTORY);
        }

        public void setViewsysParameter(Parameter<SkySys> viewsysParam) {
            this.viewsysParam_ = viewsysParam;
        }

        @Override
        public Parameter[] getGeomParameters(String suffix) {
            return new Parameter[]{this.createDataSysParameter(suffix)};
        }

        @Override
        public DataGeom getGeom(Environment env, String suffix) throws TaskException {
            SkySys viewsys = (SkySys)this.viewsysParam_.objectValue(env);
            ConfigParameter datasysParam = (ConfigParameter)((Object)new ParameterFinder<ConfigParameter<SkySys>>(){

                @Override
                public ConfigParameter<SkySys> createParameter(String sfix) {
                    return SkyPlotContext.this.createDataSysParameter(sfix);
                }
            }.getParameter(env, suffix));
            datasysParam.setNullPermitted(viewsys == null);
            datasysParam.setDefaultOption(viewsys);
            SkySys datasys = (SkySys)datasysParam.objectValue(env);
            if (viewsys == null && datasys != null) {
                String msg = new StringBuffer().append(datasysParam.getName()).append(" must be null if ").append(this.viewsysParam_.getName()).append(" is null").toString();
                throw new TaskException(msg);
            }
            return SkyDataGeom.createGeom(datasys, viewsys);
        }

        private ConfigParameter<SkySys> createDataSysParameter(String suffix) {
            return ConfigParameter.createLayerSuffixedParameter(SkySurfaceFactory.DATASYS_KEY, suffix, false);
        }
    }
}

