/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.filter.SelectFilter;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.geom.CubePlotType;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.geom.SkyPlotType;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.geom.SpherePlotType;
import uk.ac.starlink.ttools.plot2.geom.TimePlotType;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.LayerSpec;
import uk.ac.starlink.ttools.plot2.task.PlotSpec;
import uk.ac.starlink.ttools.plot2.task.StiltsPlotFormatter;
import uk.ac.starlink.ttools.plot2.task.Suffixer;
import uk.ac.starlink.ttools.plot2.task.ZoneSpec;
import uk.ac.starlink.ttools.task.Credibility;
import uk.ac.starlink.ttools.task.CredibleString;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.MapEnvironment;
import uk.ac.starlink.ttools.task.Setting;
import uk.ac.starlink.ttools.task.SettingGroup;
import uk.ac.starlink.ttools.task.TableNamer;
import uk.ac.starlink.util.LoadException;

public class StiltsPlot {
    private final AbstractPlot2Task task_;
    private final String taskName_;
    private final SettingGroup[] groups_;
    private static final Collection<String> autoFormatNames_ = StiltsPlot.getAutoFormatNames();

    public StiltsPlot(AbstractPlot2Task task, String taskName, SettingGroup[] groups) {
        this.task_ = task;
        this.taskName_ = taskName;
        this.groups_ = groups;
    }

    public AbstractPlot2Task getTask() {
        return this.task_;
    }

    public String getTaskName() {
        return this.taskName_;
    }

    public SettingGroup[] getGroups() {
        return this.groups_;
    }

    private static AbstractPlot2Task createTask(String taskName) throws LoadException {
        return (AbstractPlot2Task)Stilts.getTaskFactory().createObject(taskName);
    }

    public static StiltsPlot createPlot(PlotSpec plotSpec, StiltsPlotFormatter formatter) throws LoadException {
        int iz;
        PlotType plotType = plotSpec.getPlotType();
        Dimension extSize = plotSpec.getExtSize();
        ZoneSpec[] zoneSpecs = plotSpec.getZoneSpecs();
        LayerSpec[] layerSpecs = plotSpec.getLayerSpecs();
        Suffixer zoneSuffixer = formatter.getZoneSuffixer();
        Suffixer layerSuffixer = formatter.getLayerSuffixer();
        TableNamer namer = formatter.getTableNamer();
        String taskName = StiltsPlot.getPlotTaskName(plotType);
        AbstractPlot2Task task = StiltsPlot.createTask(taskName);
        ArrayList<Setting> taskSettings = new ArrayList<Setting>();
        if (extSize != null) {
            Integer xp = new Integer(extSize.width);
            Integer yp = new Integer(extSize.height);
            taskSettings.add(StiltsPlot.createParamSetting(task.getXpixParameter(), xp));
            taskSettings.add(StiltsPlot.createParamSetting(task.getYpixParameter(), yp));
        }
        taskSettings.addAll(Arrays.asList(StiltsPlot.createParamSetting(task.getPaddingParameter(), plotSpec.getPadding())));
        SurfaceFactory sfact = plotType.getSurfaceFactory();
        ConfigKey[] profileKeys = sfact.getProfileKeys();
        ConfigKey[] aspectKeys = sfact.getAspectKeys();
        ConfigKey[] auxKeys = PlotUtil.arrayConcat(StyleKeys.AUX_RAMP.getKeys(), new ConfigKey[]{StyleKeys.SHADE_LOW, StyleKeys.SHADE_HIGH});
        LinkedHashMap<String, ArrayList<Setting>> zoneSettings = new LinkedHashMap<String, ArrayList<Setting>>();
        int nz = zoneSpecs.length;
        String[] zkeys = zoneSuffixer.createSuffixes(nz).toArray(new String[0]);
        ZoneAdjuster[] zadjusters = new ZoneAdjuster[nz];
        for (iz = 0; iz < nz; ++iz) {
            ArrayList<LayerSpec> lspecs = new ArrayList<LayerSpec>();
            for (LayerSpec ls : layerSpecs) {
                if (ls.getZoneIndex() != iz) continue;
                lspecs.add(ls);
            }
            zadjusters[iz] = StiltsPlot.createZoneAdjuster(zoneSpecs[iz], lspecs, plotType);
        }
        for (iz = 0; iz < nz; ++iz) {
            ZoneSpec zoneSpec = zoneSpecs[iz];
            ConfigMap zoneConfig = zoneSpec.getConfig();
            ArrayList<Setting> settings = new ArrayList<Setting>();
            settings.addAll(StiltsPlot.getConfigSettings(zoneConfig, profileKeys));
            settings.add(null);
            settings.addAll(StiltsPlot.getConfigSettings(zoneConfig, aspectKeys));
            settings.add(null);
            if (zoneSpec.getHasAux()) {
                ZoneSpec.RampSpec auxSpec = zoneSpec.getAuxSpec();
                settings.addAll(StiltsPlot.getConfigSettings(zoneConfig, auxKeys));
                settings.add(null);
                settings.add(StiltsPlot.createParamSetting(task.createAuxVisibleParameter(null), auxSpec != null));
                if (auxSpec != null) {
                    settings.add(StiltsPlot.createParamSetting(task.createAuxLabelParameter(null), auxSpec.getLabel()));
                    settings.add(StiltsPlot.createParamSetting(task.createAuxCrowdParameter(null), auxSpec.getCrowding()));
                }
                settings.add(null);
            }
            settings.add(StiltsPlot.createParamSetting(task.createTitleParameter(null), zoneSpec.getTitle()));
            ZoneSpec.LegendSpec legSpec = zoneSpec.getLegendSpec();
            boolean hasLegend = legSpec != null;
            settings.add(StiltsPlot.createParamSetting(task.getLegendParameter(), hasLegend));
            if (hasLegend) {
                settings.addAll(Arrays.asList(StiltsPlot.createParamSetting(task.getLegendBorderParameter(), legSpec.hasBorder()), StiltsPlot.createParamSetting(task.getLegendOpaqueParameter(), legSpec.isOpaque()), StiltsPlot.createParamSetting(task.createLegendPositionParameter(null), StiltsPlot.toDoubles(legSpec.getPosition()))));
            }
            settings.add(null);
            zadjusters[iz].adjustZoneSettings(settings);
            zoneSettings.put(zkeys[iz], settings);
        }
        LinkedHashMap<String, String> layerTypes = new LinkedHashMap<String, String>();
        LinkedHashMap layerSettings = new LinkedHashMap();
        int nl = layerSpecs.length;
        ArrayList<String> legKeys = new ArrayList<String>(nl);
        List<String> lkeys = layerSuffixer.createSuffixes(nl);
        boolean excludeLegend = false;
        for (int il = 0; il < nl; ++il) {
            String ltype;
            LayerSpec lspec = layerSpecs[il];
            int iz2 = lspec.getZoneIndex();
            ZoneSpec zoneSpec = zoneSpecs[iz2];
            ArrayList<Setting> lsettings = new ArrayList<Setting>();
            String lkey = lkeys.get(il);
            lsettings.add(new Setting("zone", zkeys[iz2], ""));
            lsettings.add(null);
            Plotter plotter = lspec.getPlotter();
            ArrayList<Setting> modeSettings = new ArrayList<Setting>();
            if (plotter instanceof ShapePlotter.ShapeModePlotter) {
                ShapePlotter.ShapeModePlotter sPlotter = (ShapePlotter.ShapeModePlotter)plotter;
                ShapeForm form = sPlotter.getForm();
                ShapeMode mode = sPlotter.getMode();
                ltype = form.getFormName();
                modeSettings.add(new Setting("shading", mode.getModeName(), null));
            } else {
                ltype = plotter.getPlotterName();
            }
            lsettings.addAll(StiltsPlot.createInputTableSettings(lspec, namer));
            lsettings.add(null);
            lsettings.addAll(StiltsPlot.createCoordSettings(lspec));
            lsettings.addAll(zadjusters[iz2].getLayerSettings(lspec));
            lsettings.add(null);
            lsettings.addAll(modeSettings);
            lsettings.addAll(StiltsPlot.getConfigSettings(lspec.getConfig(), plotter.getStyleKeys()));
            lsettings.add(null);
            if (zoneSpec.getLegendSpec() != null) {
                String leglabel = lspec.getLegendLabel();
                if (leglabel != null) {
                    lsettings.add(StiltsPlot.createParamSetting(AbstractPlot2Task.createLabelParameter(""), leglabel));
                    legKeys.add(lkey);
                } else {
                    excludeLegend = true;
                }
                lsettings.add(null);
            }
            layerTypes.put(lkey, ltype);
            layerSettings.put(lkey, lsettings);
        }
        List<Setting> commonZoneSettings = StiltsPlot.extractCommonSettings(zoneSettings.values());
        List<Setting> commonLayerSettings = StiltsPlot.extractCommonSettings(layerSettings.values());
        ArrayList<Setting> trailSettings = new ArrayList<Setting>();
        if (lkeys.size() > 1) {
            Setting seqSetting = StiltsPlot.createParamSetting(task.getSequenceParameter(), lkeys.toArray(new String[0]));
            trailSettings.add(StiltsPlot.asDefaultSetting(seqSetting));
        }
        if (excludeLegend) {
            trailSettings.add(StiltsPlot.createParamSetting(task.getLegendSequenceParameter(), legKeys.toArray(new String[0])));
        }
        trailSettings.add(null);
        trailSettings.add(StiltsPlot.createParamSetting(task.createPaintModeParameter().getOutputParameter(), null));
        ArrayList<SettingGroup> groups = new ArrayList<SettingGroup>();
        groups.addAll(StiltsPlot.toGroups(1, taskSettings));
        groups.addAll(StiltsPlot.toGroups(1, commonZoneSettings));
        for (String zkey : zoneSettings.keySet()) {
            List zsettings = (List)zoneSettings.get(zkey);
            groups.addAll(StiltsPlot.toGroups(1, StiltsPlot.addSuffixes(zsettings, zkey)));
        }
        groups.addAll(StiltsPlot.toGroups(1, commonLayerSettings));
        for (String lkey : layerTypes.keySet()) {
            String ltype = (String)layerTypes.get(lkey);
            List lsettings = (List)layerSettings.get(lkey);
            groups.add(new SettingGroup(1, new Setting[]{new Setting("layer" + lkey, ltype, null)}));
            groups.addAll(StiltsPlot.toGroups(2, StiltsPlot.addSuffixes(lsettings, lkey)));
        }
        groups.addAll(StiltsPlot.toGroups(1, trailSettings));
        return new StiltsPlot(task, taskName, groups.toArray(new SettingGroup[0]));
    }

    private static String getPlotTaskName(PlotType ptype) {
        if (ptype instanceof PlanePlotType) {
            return "plot2plane";
        }
        if (ptype instanceof SkyPlotType) {
            return "plot2sky";
        }
        if (ptype instanceof CubePlotType) {
            return "plot2cube";
        }
        if (ptype instanceof SpherePlotType) {
            return "plot2sphere";
        }
        if (ptype instanceof TimePlotType) {
            return "plot2time";
        }
        throw new IllegalArgumentException("Unknown plot type " + ptype);
    }

    private static List<Setting> addSuffixes(List<Setting> settings, String suffix) {
        ArrayList<Setting> outList = new ArrayList<Setting>(settings.size());
        for (Setting s : settings) {
            outList.add(s == null ? null : s.appendSuffix(suffix));
        }
        return outList;
    }

    private static List<Setting> extractCommonSettings(Collection<List<Setting>> lists) {
        ArrayList<Setting> common = new ArrayList<Setting>();
        if (lists.size() > 1) {
            LinkedHashSet<String> allkeys = new LinkedHashSet<String>();
            for (List<Setting> list : lists) {
                for (Setting s : list) {
                    if (s == null) continue;
                    allkeys.add(s.getKey());
                }
            }
            for (String key : allkeys) {
                int nsame = 0;
                int ndiff = 0;
                Setting s0 = null;
                for (List<Setting> list : lists) {
                    Setting s1 = StiltsPlot.findSetting(list, key);
                    if (s1 == null) continue;
                    if (s0 == null) {
                        s0 = s1;
                    }
                    if (s1.equals(s0)) {
                        ++nsame;
                        continue;
                    }
                    ++ndiff;
                }
                if (nsame <= true || ndiff != 0) continue;
                common.add(s0);
                for (List<Setting> list : lists) {
                    list.remove(s0);
                }
            }
        }
        return common;
    }

    private static Setting findSetting(List<Setting> settings, String key) {
        for (Setting s : settings) {
            if (s == null || !s.getKey().equals(key)) continue;
            return s;
        }
        return null;
    }

    private static String argQuote(String txt) {
        boolean hasSpace;
        boolean hasSquot = txt.indexOf(39) >= 0;
        boolean hasDquot = txt.indexOf(34) >= 0;
        boolean bl = hasSpace = txt.indexOf(32) >= 0;
        if (hasSquot || hasDquot || hasSpace) {
            return "\"" + txt.replaceAll("\"", "\\\\\"") + "\"";
        }
        return txt;
    }

    private static List<Setting> getConfigSettings(ConfigMap config, ConfigKey[] keys) {
        int nk = keys.length;
        ArrayList<Setting> settings = new ArrayList<Setting>(nk);
        for (int ik = 0; ik < nk; ++ik) {
            settings.add(StiltsPlot.createConfigSetting(keys[ik], config));
        }
        return settings;
    }

    private static <T> Setting createConfigSetting(ConfigKey<T> key, ConfigMap map) {
        return new Setting(StiltsPlot.getSettingKey(key), key.valueToString(map.get(key)), key.valueToString(key.getDefaultValue()));
    }

    private static String getSettingKey(ConfigKey<?> key) {
        return key.getMeta().getShortName();
    }

    private static <T> Setting createParamSetting(Parameter<T> param, T tval) {
        String value;
        String key = param.getName();
        try {
            value = param.objectToString((Environment)new MapEnvironment(), tval);
        }
        catch (TaskException e) {
            assert (false);
            throw new RuntimeException();
        }
        String dflt = param.getStringDefault();
        return new Setting(key, value, dflt);
    }

    private static Setting createDefaultParamSetting(Parameter<?> param) {
        String dflt = param.getStringDefault();
        return new Setting(param.getName(), dflt, dflt);
    }

    private static Setting asDefaultSetting(Setting setting) {
        return setting.resetDefault(setting.getStringValue());
    }

    private static List<Setting> createInputTableSettings(LayerSpec lspec, TableNamer namer) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        StarTable table = lspec.getTable();
        String suffix = "";
        if (table != null) {
            CredibleString selection;
            InputTableParameter inParam = AbstractPlot2Task.createTableParameter(suffix);
            CredibleString naming = namer.nameTable(table);
            Credibility nameCred = naming.getCredibility();
            Setting tableSetting = new Setting(inParam.getName(), naming.getValue(), null);
            tableSetting.setObjectValue(table);
            tableSetting.setCredibility(nameCred);
            settings.add(tableSetting);
            if (nameCred == Credibility.YES || nameCred == Credibility.MAYBE) {
                Setting tfmtSetting;
                InputFormatParameter fmtParam = inParam.getFormatParameter();
                TableBuilder tfmt = namer.getTableFormat(table);
                if (tfmt != null) {
                    String fmtName = tfmt.getFormatName();
                    tfmtSetting = autoFormatNames_.contains(fmtName) ? StiltsPlot.createDefaultParamSetting(fmtParam) : StiltsPlot.createParamSetting(fmtParam, fmtName);
                } else {
                    tfmtSetting = StiltsPlot.createDefaultParamSetting(fmtParam);
                    tfmtSetting.setCredibility(Credibility.MAYBE);
                }
                settings.add(tfmtSetting);
            }
            if ((selection = lspec.getSelectExpr()) != null) {
                FilterParameter filterParam = AbstractPlot2Task.createFilterParameter(suffix, inParam);
                String filterCmd = new SelectFilter().getName() + " " + StiltsPlot.argQuote(selection.getValue());
                Setting selectSetting = new Setting(filterParam.getName(), filterCmd, null);
                selectSetting.setCredibility(selection.getCredibility());
                settings.add(selectSetting);
            }
        }
        return settings;
    }

    private static List<Setting> createCoordSettings(LayerSpec lspec) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        Map<String, String> coordMap = lspec.getCoordMap();
        if (coordMap != null) {
            for (Map.Entry<String, String> entry : coordMap.entrySet()) {
                settings.add(new Setting(entry.getKey(), entry.getValue(), null));
            }
        }
        return settings;
    }

    private static <T> T getExplicitValue(ConfigKey<T> key, ConfigMap config) {
        return config.keySet().contains(key) ? (T)config.get(key) : null;
    }

    private static double[] toDoubles(float[] farray) {
        if (farray == null) {
            return null;
        }
        int n = farray.length;
        double[] darray = new double[n];
        for (int i = 0; i < n; ++i) {
            double dval = farray[i];
            darray[i] = PlotUtil.roundNumber(dval, 1.0E-5 * dval);
        }
        return darray;
    }

    private static ZoneAdjuster createZoneAdjuster(ZoneSpec zspec, List<LayerSpec> lspecs, PlotType plotType) {
        if (plotType instanceof SkyPlotType) {
            return new SkySysZoneAdjuster(zspec, lspecs);
        }
        return new ZoneAdjuster(){

            @Override
            public void adjustZoneSettings(List<Setting> zsettings) {
            }

            @Override
            public List<Setting> getLayerSettings(LayerSpec lspec) {
                return Collections.emptyList();
            }
        };
    }

    private static List<SettingGroup> toGroups(int level, List<Setting> settings) {
        ArrayList<Setting> inList = new ArrayList<Setting>(settings);
        inList.add(null);
        ArrayList<SettingGroup> glist = new ArrayList<SettingGroup>();
        ArrayList<Setting> slist = new ArrayList<Setting>();
        for (Setting s : inList) {
            if (s != null) {
                slist.add(s);
                continue;
            }
            if (slist.size() <= 0) continue;
            Setting[] line = slist.toArray(new Setting[0]);
            glist.add(new SettingGroup(level, line));
            slist = new ArrayList();
        }
        return glist;
    }

    private static Collection<String> getAutoFormatNames() {
        HashSet<String> list = new HashSet<String>();
        for (Object obj : new StarTableFactory().getDefaultBuilders()) {
            if (obj instanceof TableBuilder) {
                list.add(((TableBuilder)obj).getFormatName());
                continue;
            }
            assert (false);
        }
        return list;
    }

    private static class SkySysZoneAdjuster
    implements ZoneAdjuster {
        private static final ConfigKey<SkySys> VIEWSYS_KEY = SkySurfaceFactory.VIEWSYS_KEY;
        private static final ConfigKey<SkySys> DATASYS_KEY = SkySurfaceFactory.DATASYS_KEY;
        private final SkySys viewsys_;
        private final boolean sysDiffers_;

        SkySysZoneAdjuster(ZoneSpec zspec, List<LayerSpec> lspecs) {
            ConfigMap zconfig = zspec.getConfig();
            this.viewsys_ = (SkySys)StiltsPlot.getExplicitValue(SkySysZoneAdjuster.VIEWSYS_KEY, zconfig);
            boolean differs = false;
            for (LayerSpec lspec : lspecs) {
                SkySys datasys = (SkySys)StiltsPlot.getExplicitValue(SkySysZoneAdjuster.DATASYS_KEY, lspec.getConfig());
                if (datasys == null || datasys.equals(this.viewsys_)) continue;
                differs = true;
            }
            this.sysDiffers_ = differs;
        }

        @Override
        public void adjustZoneSettings(List<Setting> zsettings) {
            for (int i = 0; i < zsettings.size(); ++i) {
                Setting zs = zsettings.get(i);
                if (zs == null || !zs.getKey().equals(StiltsPlot.getSettingKey(SkySysZoneAdjuster.VIEWSYS_KEY))) continue;
                String dflt = this.sysDiffers_ ? null : zs.getStringValue();
                zsettings.set(i, zs.resetDefault(dflt));
            }
        }

        @Override
        public List<Setting> getLayerSettings(LayerSpec lspec) {
            ArrayList<Setting> list = new ArrayList<Setting>();
            ConfigMap lconfig = lspec.getConfig();
            SkySys datasys = (SkySys)StiltsPlot.getExplicitValue(SkySysZoneAdjuster.DATASYS_KEY, lconfig);
            if (datasys != null) {
                Setting ls = StiltsPlot.createConfigSetting(SkySysZoneAdjuster.DATASYS_KEY, lconfig);
                String dflt = this.sysDiffers_ ? null : ls.getStringValue();
                list.add(ls.resetDefault(dflt));
            }
            return list;
        }
    }

    private static interface ZoneAdjuster {
        public void adjustZoneSettings(List<Setting> var1);

        public List<Setting> getLayerSettings(LayerSpec var1);
    }
}

