/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StringContent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;
import uk.ac.starlink.ttools.plot2.task.StiltsPlot;
import uk.ac.starlink.ttools.plot2.task.Suffixer;
import uk.ac.starlink.ttools.task.Credibility;
import uk.ac.starlink.ttools.task.CredibleString;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.LineEnder;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.ttools.task.MapEnvironment;
import uk.ac.starlink.ttools.task.Setting;
import uk.ac.starlink.ttools.task.SettingGroup;
import uk.ac.starlink.ttools.task.TableNamer;

public class StiltsPlotFormatter {
    private final int continueIndent_;
    private final int levelIndent_;
    private final int cwidth_;
    private final CredibleString invocation_;
    private final Suffixer zoneSuffixer_;
    private final Suffixer layerSuffixer_;
    private final LineEnder lineEnder_;
    private final boolean includeDflts_;
    private final TableNamer tableNamer_;
    private final Color syntaxColor_;
    private boolean forceError_;
    private static final Pattern SAFE_REGEX = Pattern.compile("[a-zA-Z0-9,._+:@%/-]*");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.task");
    public static final Suffixer[] ZONE_SUFFIXERS = new Suffixer[]{Suffixer.createAlphaSuffixer("-Alpha", "-", true, true), Suffixer.createAlphaSuffixer("-alpha", "-", true, false), Suffixer.createNumericSuffixer("-Numeric", "-", true), Suffixer.createNumericSuffixer("Numeric", "", true), Suffixer.createAlphaSuffixer("Alpha", "", true, true)};
    public static final Suffixer[] LAYER_SUFFIXERS = new Suffixer[]{Suffixer.createNumericSuffixer("_Numeric", "_", true), Suffixer.createAlphaSuffixer("_Alpha", "_", true, true), Suffixer.createAlphaSuffixer("_alpha", "_", true, false), Suffixer.createNumericSuffixer("Numeric", "", true), Suffixer.createAlphaSuffixer("Alpha", "", true, true)};

    public StiltsPlotFormatter(CredibleString invocation, Suffixer zoneSuffixer, Suffixer layerSuffixer, boolean includeDflts, LineEnder lineEnder, int levelIndent, int cwidth, TableNamer tableNamer) {
        this.invocation_ = invocation;
        this.zoneSuffixer_ = zoneSuffixer;
        this.layerSuffixer_ = layerSuffixer;
        this.includeDflts_ = includeDflts;
        this.lineEnder_ = lineEnder;
        this.levelIndent_ = levelIndent;
        this.cwidth_ = cwidth;
        this.tableNamer_ = tableNamer;
        this.continueIndent_ = 1;
        this.syntaxColor_ = new Color(0xA0A0FF);
    }

    public CredibleString getInvocation() {
        return this.invocation_;
    }

    public Suffixer getZoneSuffixer() {
        return this.zoneSuffixer_;
    }

    public Suffixer getLayerSuffixer() {
        return this.layerSuffixer_;
    }

    public TableNamer getTableNamer() {
        return this.tableNamer_;
    }

    public void setForceError(boolean forceError) {
        this.forceError_ = forceError;
    }

    public Executable createExecutable(StiltsPlot plot) throws TaskException {
        MapEnvironment env = new MapEnvironment(){
            final Map<String, String> map = this.getMap();

            @Override
            public MapEnvironment setValue(String paramName, Object value) {
                if (this.map.containsKey(paramName)) {
                    throw new IllegalStateException("Duplicate parameter: " + paramName);
                }
                return super.setValue(paramName, value);
            }
        };
        try {
            this.populateEnvironment(plot, env);
        }
        catch (RuntimeException e) {
            throw new TaskException(e.getMessage(), (Throwable)e);
        }
        AbstractPlot2Task task = plot.getTask();
        Executable exec = task.createExecutable(env);
        String[] unused = StiltsPlotFormatter.stripExpectedUnused(task, env.getUnused());
        if (unused.length > 0) {
            throw new TaskException(LineInvoker.getUnusedWarning(unused));
        }
        return exec;
    }

    public PlotDisplay createPlotComponent(StiltsPlot plot, boolean caching) throws TaskException, IOException, InterruptedException {
        MapEnvironment env = new MapEnvironment();
        this.populateEnvironment(plot, env);
        return plot.getTask().createPlotComponent(env, caching);
    }

    public StyledDocument createShellDocument(StiltsPlot plot) {
        StyleContext context = StyleContext.getDefaultStyleContext();
        AttributeSet plain = context.getEmptySet();
        AttributeSet faint = context.addAttribute(plain, StyleConstants.Foreground, Color.LIGHT_GRAY);
        AttributeSet syntax = this.syntaxColor_ == null ? plain : context.addAttribute(plain, StyleConstants.Foreground, this.syntaxColor_);
        AttributeSet warning1 = context.addAttribute(plain, StyleConstants.Foreground, Color.BLUE);
        AttributeSet warning2 = context.addAttribute(plain, StyleConstants.Foreground, Color.RED);
        DefaultStyledDocument doc = new DefaultStyledDocument();
        AttributeSet invokeStyle = StiltsPlotFormatter.getStyle(this.invocation_.getCredibility(), plain, warning1, warning2);
        String invokeTxt = this.invocation_.getValue();
        StiltsPlotFormatter.addText(doc, invokeTxt + " ", invokeStyle);
        if (invokeTxt.length() > 16) {
            StiltsPlotFormatter.addText(doc, this.getPrefix(0), faint);
        }
        StiltsPlotFormatter.addText(doc, plot.getTaskName() + " ", plain);
        for (SettingGroup g : this.getGroups(plot)) {
            List<Setting> settings = this.getSettings(g);
            if (settings.size() <= 0) continue;
            String prefix = this.getPrefix(g.getLevel());
            int icr = prefix.lastIndexOf("\n");
            boolean hasNewline = icr >= 0;
            int npre = prefix.length() - icr - 1;
            int npost = hasNewline ? icr : 0;
            String prefixCont = hasNewline ? prefix + StiltsPlotFormatter.spaces(this.continueIndent_) : prefix;
            int npreCont = hasNewline ? npre + this.continueIndent_ : npre;
            StiltsPlotFormatter.addText(doc, prefix, faint);
            int nc = npre;
            for (Setting s : settings) {
                boolean isDflt = s.isDefaultValue();
                AttributeSet keyStyle = isDflt ? faint : plain;
                AttributeSet equStyle = isDflt ? faint : syntax;
                AttributeSet valStyle = StiltsPlotFormatter.getStyle(s.getCredibility(), keyStyle, warning1, warning2);
                String key = s.getKey();
                String val = StiltsPlotFormatter.shellQuote(s.getStringValue());
                int wleng = key.length() + 1 + val.length() + 1;
                if (nc + wleng + npre > this.cwidth_ && nc > npre) {
                    StiltsPlotFormatter.addText(doc, prefixCont, faint);
                    nc = npreCont;
                }
                StiltsPlotFormatter.addText(doc, key, keyStyle);
                StiltsPlotFormatter.addText(doc, "=", equStyle);
                StiltsPlotFormatter.addText(doc, val, valStyle);
                StiltsPlotFormatter.addText(doc, " ", plain);
                nc += wleng;
            }
        }
        return doc;
    }

    private List<Setting> getSettings(SettingGroup group) {
        ArrayList<Setting> list = new ArrayList<Setting>();
        for (Setting s : group.getSettings()) {
            if (!this.includeDflts_ && s.isDefaultValue()) continue;
            list.add(s);
        }
        return list;
    }

    private static String[] stripExpectedUnused(AbstractPlot2Task task, String[] words) {
        InputTableParameter inParam = AbstractPlot2Task.createTableParameter("");
        String fmtName = inParam.getFormatParameter().getName();
        String strmName = inParam.getStreamParameter().getName();
        ArrayList<String> list = new ArrayList<String>();
        for (String word : words) {
            if (word.startsWith(fmtName) || word.startsWith(strmName)) continue;
            list.add(word);
        }
        return list.toArray(new String[0]);
    }

    private List<SettingGroup> getGroups(StiltsPlot plot) {
        ArrayList<SettingGroup> list = new ArrayList<SettingGroup>(Arrays.asList(plot.getGroups()));
        if (this.forceError_) {
            list.add(new SettingGroup(0, new Setting[]{new Setting("force_error", "true", null)}));
        }
        return list;
    }

    private void populateEnvironment(StiltsPlot plot, MapEnvironment env) {
        for (SettingGroup g : this.getGroups(plot)) {
            for (Setting s : this.getSettings(g)) {
                String key = s.getKey();
                Object objVal = s.getObjectValue();
                env.setValue(key, objVal == null ? s.getStringValue() : objVal);
            }
        }
    }

    private void envSettings(MapEnvironment env, Collection<Setting> settings) {
        for (Setting s : settings) {
            if (s == null || s.isDefaultValue()) continue;
            String key = s.getKey();
            Object objVal = s.getObjectValue();
            env.setValue(key, objVal == null ? s.getStringValue() : objVal);
        }
    }

    private static void addText(Document doc, String text, AttributeSet attSet) {
        block2: {
            try {
                doc.insertString(doc.getLength(), text, attSet);
            }
            catch (BadLocationException e) {
                logger_.log(Level.SEVERE, "Can't insert string?", e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static AttributeSet getStyle(Credibility cred, AttributeSet yesStyle, AttributeSet maybeStyle, AttributeSet noStyle) {
        switch (cred) {
            case YES: {
                return yesStyle;
            }
            case MAYBE: {
                return maybeStyle;
            }
            case NO: {
                return noStyle;
            }
        }
        assert (false);
        return yesStyle;
    }

    private static String shellQuote(String txt) {
        if (txt == null) {
            return "";
        }
        if (SAFE_REGEX.matcher(txt).matches()) {
            return txt;
        }
        if (txt.indexOf(39) < 0) {
            return "'" + txt + "'";
        }
        if (txt.matches("[^\"$`!\\\\]*")) {
            return "\"" + txt + "\"";
        }
        return "'" + txt.replaceAll("'", "'\\\\''") + "'";
    }

    private String getPrefix(int level) {
        if (this.lineEnder_.includesNewline()) {
            return new StringBuffer().append(this.lineEnder_.getEndOfLine()).append(StiltsPlotFormatter.spaces(level * this.levelIndent_)).toString();
        }
        return "";
    }

    public static StyledDocument createBasicDocument(String txt) {
        StringContent content;
        block2: {
            content = new StringContent();
            try {
                content.insertString(0, txt);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        StyleContext context = StyleContext.getDefaultStyleContext();
        return new DefaultStyledDocument((AbstractDocument.Content)content, context);
    }

    private static String spaces(int n) {
        StringBuffer sbuf = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sbuf.append(' ');
        }
        return sbuf.toString();
    }
}

