/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public abstract class Suffixer {
    public abstract List<String> createSuffixes(int var1);

    public static Suffixer createNumericSuffixer(final String name, final String separator, final boolean isBlank1) {
        return new Suffixer(){

            @Override
            public List<String> createSuffixes(final int n) {
                if (n == 1 && isBlank1) {
                    return Collections.singletonList("");
                }
                int ndig = 1 + (int)Math.log10(n);
                StringBuffer fbuf = new StringBuffer(ndig);
                for (int i = 0; i < ndig; ++i) {
                    fbuf.append('0');
                }
                final DecimalFormat fmt = new DecimalFormat(fbuf.toString());
                return new AbstractList<String>(){

                    @Override
                    public int size() {
                        return n;
                    }

                    @Override
                    public String get(int i) {
                        return separator + fmt.format(i + 1);
                    }
                };
            }

            public String toString() {
                return name;
            }
        };
    }

    public static Suffixer createAlphaSuffixer(final String name, final String separator, final boolean isBlank1, boolean isUpper) {
        final char c0 = isUpper ? (char)'A' : 'a';
        int nc = 26;
        return new Suffixer(){

            @Override
            public List<String> createSuffixes(final int n) {
                if (n == 1 && isBlank1) {
                    return Collections.singletonList("");
                }
                final int ndig = 1 + (int)(Math.log(n - 1) / Math.log(26.0));
                return new AbstractList<String>(){

                    @Override
                    public int size() {
                        return n;
                    }

                    @Override
                    public String get(int ival) {
                        StringBuffer sbuf = new StringBuffer(ndig);
                        for (int jd = 0; jd < ndig; ++jd) {
                            sbuf.insert(0, (char)(ival % 26 + c0));
                            ival /= 26;
                        }
                        return separator + sbuf.toString();
                    }
                };
            }

            public String toString() {
                return name;
            }
        };
    }
}

