/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plottask.PaintModeParameter;
import uk.ac.starlink.ttools.plottask.Painter;
import uk.ac.starlink.ttools.plottask.SwingPainter;
import uk.ac.starlink.util.Destination;

public abstract class PaintMode {
    private final String name_;
    public static final PaintMode SWING_MODE = new SwingPaintMode();
    public static final PaintMode CGI_MODE = new CgiPaintMode();
    public static final PaintMode DISCARD_MODE = new DiscardPaintMode();

    protected PaintMode(String name) {
        this.name_ = name;
    }

    public abstract Painter createPainter(Environment var1, PaintModeParameter var2) throws TaskException;

    public abstract String getDescription(PaintModeParameter var1);

    public abstract String getModeUsage(PaintModeParameter var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public static PaintMode[] getKnownModes(GraphicExporter[] exporters) {
        OutputPaintMode outMode = new OutputPaintMode(exporters);
        return new PaintMode[]{SWING_MODE, outMode, CGI_MODE, DISCARD_MODE, new AutoPaintMode(outMode)};
    }

    private static class AutoPaintMode
    extends PaintMode {
        private final OutputPaintMode outMode_;

        protected AutoPaintMode(OutputPaintMode outMode) {
            super("auto");
            this.outMode_ = outMode;
        }

        @Override
        public String getDescription(PaintModeParameter modeParam) {
            return "Behaves as <code><ref id='paintmode-swing'>" + SWING_MODE + "</ref></code> or " + "<code><ref id='paintmode-out'>" + this.outMode_ + "</ref></code> " + " mode depending on presence of " + "<code>" + modeParam.getOutputParameter().getName() + "</code> parameter";
        }

        @Override
        public String getModeUsage(PaintModeParameter modeParam) {
            OutputStreamParameter outParam = modeParam.getOutputParameter();
            return " [" + outParam.getName() + "=" + outParam.getUsage() + "]";
        }

        @Override
        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            OutputStreamParameter outParam = param.getOutputParameter();
            ChoiceParameter<GraphicExporter> formatParam = param.getFormatParameter();
            outParam.setNullPermitted(true);
            if (outParam.stringValue(env) == null) {
                return SWING_MODE.createPainter(env, param);
            }
            return this.outMode_.createPainter(env, param);
        }
    }

    private static class DiscardPaintMode
    extends PaintMode {
        DiscardPaintMode() {
            super("discard");
        }

        @Override
        public String getDescription(PaintModeParameter modeParam) {
            return "Plot is drawn, but discarded.  There is no output.";
        }

        @Override
        public String getModeUsage(PaintModeParameter modeParam) {
            return "";
        }

        @Override
        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            return new Painter(){

                @Override
                public void paintPicture(Picture picture) throws IOException {
                    Image image = this.createImage(picture.getPictureWidth(), picture.getPictureHeight());
                    Graphics2D g2 = (Graphics2D)image.getGraphics();
                    picture.paintPicture(g2);
                    g2.dispose();
                    image.flush();
                }

                private Image createImage(int w, int h) {
                    GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    return genv.isHeadless() ? new BufferedImage(w, h, 1) : genv.getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(w, h);
                }
            };
        }
    }

    private static class CgiPaintMode
    extends PaintMode {
        CgiPaintMode() {
            super("cgi");
        }

        @Override
        public String getDescription(PaintModeParameter modeParam) {
            return "Plot will be written in a way suitable for CGI use direct from a web server.\nThe output is in the graphics format given by <code><ref id='graphicExporter'>" + modeParam.getFormatParameter().getName() + "</ref>" + "</code>,\n" + "preceded by a suitable \"Content-type\" declaration.";
        }

        @Override
        public String getModeUsage(PaintModeParameter modeParam) {
            ChoiceParameter<GraphicExporter> formatParam = modeParam.getFormatParameter();
            return " " + formatParam.getName() + "=" + formatParam.getUsage();
        }

        @Override
        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            final GraphicExporter exporter = (GraphicExporter)param.getFormatParameter().objectValue(env);
            final PrintStream out = env.getOutputStream();
            return new Painter(){

                @Override
                public void paintPicture(Picture picture) throws IOException {
                    BufferedOutputStream bout = new BufferedOutputStream(out);
                    StringBuffer hbuf = new StringBuffer();
                    hbuf.append("Content-Type: ").append(exporter.getMimeType()).append('\n');
                    String encoding = exporter.getContentEncoding();
                    if (encoding != null) {
                        hbuf.append("Content-Encoding: ").append(encoding).append('\n');
                    }
                    hbuf.append('\n');
                    bout.write(hbuf.toString().getBytes("UTF-8"));
                    exporter.exportGraphic(picture, bout);
                    bout.flush();
                }
            };
        }
    }

    private static class OutputPaintMode
    extends PaintMode {
        private final GraphicExporter[] exporters_;

        OutputPaintMode(GraphicExporter[] exporters) {
            super("out");
            this.exporters_ = exporters;
        }

        @Override
        public String getDescription(PaintModeParameter modeParam) {
            return "Plot will be written to a file given by <code>" + modeParam.getOutputParameter().getName() + "</code> " + "using the graphics format given by " + "<code>" + "<ref id='graphicExporter'>" + modeParam.getFormatParameter().getName() + "</ref>" + "</code>.";
        }

        @Override
        public String getModeUsage(PaintModeParameter modeParam) {
            OutputStreamParameter outParam = modeParam.getOutputParameter();
            ChoiceParameter<GraphicExporter> formatParam = modeParam.getFormatParameter();
            return " " + outParam.getName() + "=" + outParam.getUsage() + " " + formatParam.getName() + "=" + formatParam.getUsage();
        }

        @Override
        public Painter createPainter(Environment env, PaintModeParameter param) throws TaskException {
            OutputStreamParameter outParam = param.getOutputParameter();
            ChoiceParameter<GraphicExporter> formatParam = param.getFormatParameter();
            final Destination dest = (Destination)outParam.objectValue(env);
            String out = outParam.stringValue(env);
            GraphicExporter dfltExp = null;
            if (out != null) {
                for (int ie = 0; ie < this.exporters_.length; ++ie) {
                    String[] fss = this.exporters_[ie].getFileSuffixes();
                    for (int is = 0; is < fss.length; ++is) {
                        if (!out.toLowerCase().endsWith(fss[is].toLowerCase())) continue;
                        dfltExp = this.exporters_[ie];
                    }
                }
            }
            if (dfltExp != null) {
                formatParam.setStringDefault(dfltExp.getName());
            }
            final GraphicExporter exporter = (GraphicExporter)formatParam.objectValue(env);
            return new Painter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintPicture(Picture picture) throws IOException {
                    BufferedOutputStream out = new BufferedOutputStream(dest.createStream());
                    try {
                        exporter.exportGraphic(picture, out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
            };
        }
    }

    private static class SwingPaintMode
    extends PaintMode {
        SwingPaintMode() {
            super("swing");
        }

        @Override
        public String getDescription(PaintModeParameter modeParam) {
            StringBuffer sbuf = new StringBuffer();
            return new StringBuffer().append("Plot will be displayed in a window on the screen.\n").append("This plot is \"live\"; ").append("it can be resized and ").append("(except for old-style plots)\n").append("navigated around with mouse actions ").append("in the same way as plots in TOPCAT.").toString();
        }

        @Override
        public String getModeUsage(PaintModeParameter modeParam) {
            return "";
        }

        @Override
        public Painter createPainter(Environment env, PaintModeParameter param) {
            return new SwingPainter("STILTS Plot");
        }
    }
}

