/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.AuxLegend;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Legend;
import uk.ac.starlink.ttools.plot.PdfGraphicExporter;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plottask.FontParameter;
import uk.ac.starlink.ttools.plottask.PaintModeParameter;
import uk.ac.starlink.ttools.plottask.Painter;
import uk.ac.starlink.ttools.plottask.PlotStateFactory;
import uk.ac.starlink.ttools.plottask.SwingPainter;

public abstract class PlotTask
implements Task {
    private final String purpose_;
    private final PlotStateFactory stateFactory_;
    private final TablePlot plot_;
    private final List<Parameter> paramList_;
    private final IntegerParameter xpixParam_;
    private final IntegerParameter ypixParam_;
    private final BooleanParameter legendParam_;
    private final FontParameter fontParam_;
    private final PaintModeParameter painterParam_;
    private final StringParameter titleParam_;

    public PlotTask(String purpose, PlotStateFactory stateFactory, TablePlot plot) {
        this.purpose_ = purpose;
        this.stateFactory_ = stateFactory;
        this.plot_ = plot;
        this.paramList_ = new ArrayList<Parameter>();
        this.xpixParam_ = new IntegerParameter("xpix");
        this.xpixParam_.setMinimum(1);
        this.xpixParam_.setPrompt("Width of plot in pixels");
        this.xpixParam_.setDescription(new String[]{"<p>The width of the output graphic in pixels.", "</p>"});
        this.xpixParam_.setIntDefault(400);
        this.paramList_.add((Parameter)this.xpixParam_);
        this.ypixParam_ = new IntegerParameter("ypix");
        this.ypixParam_.setMinimum(1);
        this.ypixParam_.setPrompt("Height of plot in pixels");
        this.ypixParam_.setDescription(new String[]{"<p>The height of the output graphic in pixels.", "</p>"});
        this.ypixParam_.setIntDefault(300);
        this.paramList_.add((Parameter)this.ypixParam_);
        this.fontParam_ = new FontParameter("font");
        this.paramList_.add((Parameter)this.fontParam_);
        this.paramList_.addAll(Arrays.asList(this.fontParam_.getAssociatedParameters()));
        this.legendParam_ = new BooleanParameter("legend");
        this.legendParam_.setPrompt("Whether to include legend");
        this.legendParam_.setDescription(new String[]{"<p>Determines whether a legend showing which plotting style is", "used for each data set.", "Defaults to true if there is more than one set, false otherwise.", "</p>"});
        this.paramList_.add((Parameter)this.legendParam_);
        this.titleParam_ = new StringParameter("title");
        this.titleParam_.setPrompt("Plot title");
        this.titleParam_.setNullPermitted(true);
        this.titleParam_.setDescription(new String[]{"<p>A one-line title to display at the top of the plot.", "</p>"});
        this.paramList_.add((Parameter)this.titleParam_);
        GraphicExporter[] exporters = GraphicExporter.getKnownExporters(PdfGraphicExporter.BASIC);
        this.painterParam_ = new PaintModeParameter("omode", exporters);
        this.paramList_.add((Parameter)this.painterParam_);
        this.paramList_.add((Parameter)this.painterParam_.getOutputParameter());
        this.paramList_.add((Parameter)this.painterParam_.getFormatParameter());
        this.paramList_.addAll(Arrays.asList(this.stateFactory_.getParameters()));
    }

    protected List<Parameter> getParameterList() {
        return this.paramList_;
    }

    public String getPurpose() {
        return this.purpose_;
    }

    public Parameter[] getParameters() {
        return this.paramList_.toArray(new Parameter[0]);
    }

    public Parameter getXpixParameter() {
        return this.xpixParam_;
    }

    public Parameter getYpixParameter() {
        return this.ypixParam_;
    }

    public Executable createExecutable(Environment env) throws TaskException {
        final int xpix = this.xpixParam_.intValue(env);
        final int ypix = this.ypixParam_.intValue(env);
        final PlotState state = this.stateFactory_.getPlotState(env);
        this.legendParam_.setBooleanDefault(state.getPlotData().getSetCount() > 1);
        final boolean hasLegend = this.legendParam_.booleanValue(env);
        final Painter painter = this.painterParam_.painterValue(env);
        final Font font = this.fontParam_.fontValue(env);
        final String title = this.titleParam_.stringValue(env);
        return new Executable(){

            public void execute() throws TaskException, IOException {
                PlotTask.this.stateFactory_.configureFromData(state, PlotTask.this.plot_);
                state.setValid(true);
                PlotTask.this.plot_.setState(state);
                PlotTask.this.plot_.setFont(font);
                JComponent box = PlotTask.addDecoration(PlotTask.this.plot_, state, hasLegend, title);
                Dimension size = new Dimension(xpix, ypix);
                if (painter instanceof SwingPainter) {
                    box.setPreferredSize(size);
                    ((SwingPainter)painter).postComponent(box);
                } else {
                    box.setSize(size);
                    box.setDoubleBuffered(false);
                    box.addNotify();
                    box.validate();
                    painter.paintPicture(GraphicExporter.toPicture(box));
                }
            }
        };
    }

    private static JComponent addDecoration(TablePlot plot, PlotState state, boolean hasLegend, String title) {
        int naux = state.getShaders().length;
        if (naux == 0 && !hasLegend && title == null) {
            return plot;
        }
        JPanel box = new JPanel(new BorderLayout());
        Font font = plot.getFont();
        box.setFont(font);
        box.setOpaque(false);
        box.add((Component)plot, "Center");
        if (title != null) {
            JLabel tLabel = new JLabel(title, 0);
            tLabel.setFont(font);
            tLabel.setOpaque(false);
            box.add((Component)tLabel, "North");
        }
        Box legendBox = Box.createVerticalBox();
        legendBox.setFont(font);
        int topgap = plot.getPlotBounds().y;
        int auxgap = 10;
        int botgap = 37;
        legendBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        box.add((Component)legendBox, "East");
        if (hasLegend) {
            PlotData plotData = state.getPlotData();
            int nset = plotData.getSetCount();
            Style[] styles = new Style[nset];
            String[] labels = new String[nset];
            for (int is = 0; is < nset; ++is) {
                styles[is] = plotData.getSetStyle(is);
                labels[is] = plotData.getSetName(is);
            }
            Legend legend = new Legend();
            CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 10));
            legend.setBorder(border);
            legendBox.add(Box.createVerticalStrut(topgap));
            legendBox.add(legend);
            legend.setStyles(styles, labels);
        }
        if (naux > 0) {
            Box auxBox = Box.createHorizontalBox();
            legendBox.add(auxBox);
            for (int iaux = 0; iaux < naux; ++iaux) {
                AuxLegend auxLegend = new AuxLegend(false, 16);
                auxLegend.setLengthPadding(hasLegend ? auxgap : topgap, botgap);
                if (iaux > 0) {
                    auxBox.add(Box.createHorizontalStrut(10));
                }
                auxBox.add(auxLegend);
                auxLegend.configure(state, iaux);
            }
            auxBox.add(Box.createHorizontalGlue());
        }
        return box;
    }
}

