/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plottask.PlotDataException;

public abstract class TablePointSequence
implements PointSequence {
    private final SequentialJELRowReader rseq_;
    private final CompiledExpression labelCompex_;
    private final CompiledExpression[] setCompexs_;
    private final int nset_;
    private boolean hasLabel_;
    private boolean hasIncludeds_;
    private String label_;
    private boolean[] isIncludeds_;

    protected TablePointSequence(SequentialJELRowReader rseq, String labelExpr, String[] setExprs) throws CompilationException {
        this.rseq_ = rseq;
        Library lib = JELUtils.getLibrary(rseq);
        StarTable table = rseq.getTable();
        this.labelCompex_ = labelExpr == null ? null : JELUtils.compile(lib, table, labelExpr);
        this.nset_ = setExprs.length;
        this.setCompexs_ = new CompiledExpression[this.nset_];
        for (int is = 0; is < this.nset_; ++is) {
            this.setCompexs_[is] = JELUtils.compile(lib, table, setExprs[is], Boolean.TYPE);
        }
        this.isIncludeds_ = new boolean[this.nset_];
    }

    @Override
    public boolean next() {
        this.hasIncludeds_ = false;
        this.hasLabel_ = false;
        try {
            return this.rseq_.next();
        }
        catch (IOException e) {
            throw new PlotDataException(e);
        }
    }

    @Override
    public String getLabel() {
        if (!this.hasLabel_) {
            Object lab = this.evaluate(this.labelCompex_);
            this.label_ = lab == null ? null : lab.toString();
            this.hasLabel_ = true;
        }
        return this.label_;
    }

    @Override
    public boolean isIncluded(int iset) {
        if (!this.hasIncludeds_) {
            for (int is = 0; is < this.nset_; ++is) {
                Object inc = this.evaluate(this.setCompexs_[is]);
                this.isIncludeds_[is] = inc instanceof Boolean ? (Boolean)inc : false;
            }
            this.hasIncludeds_ = true;
        }
        return this.isIncludeds_[iset];
    }

    @Override
    public void close() {
        try {
            this.rseq_.close();
        }
        catch (IOException e) {
            throw new PlotDataException(e);
        }
    }

    protected Object evaluate(CompiledExpression compex) {
        try {
            return this.rseq_.evaluate(compex);
        }
        catch (IOException e) {
            throw new PlotDataException(e);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlotDataException("Unexpected error", e);
        }
    }

    protected double evaluateDouble(CompiledExpression compex) {
        try {
            return this.rseq_.evaluateDouble(compex);
        }
        catch (IOException e) {
            throw new PlotDataException(e);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PlotDataException("Unexpected error", e);
        }
    }
}

