/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.server.StiltsContext;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class FormServlet
extends HttpServlet {
    private ObjectFactory<Task> taskFactory_;
    private StarTableFactory tableFactory_;
    private String taskBase_;
    private Map formWriterMap_;

    public void init(ServletConfig config) throws ServletException {
        FormWriter[] fwriters;
        super.init(config);
        StiltsContext sContext = new StiltsContext(config.getServletContext());
        this.taskBase_ = sContext.getTaskBase();
        this.taskFactory_ = Stilts.getTaskFactory();
        this.tableFactory_ = sContext.getTableFactory();
        HashMap<String, FormWriter> fwmap = new HashMap<String, FormWriter>();
        try {
            fwriters = this.getFormWriters();
        }
        catch (LoadException e) {
            throw new ServletException((Throwable)e);
        }
        for (int iw = 0; iw < fwriters.length; ++iw) {
            FormWriter fw = fwriters[iw];
            fwmap.put(fw.getName(), fw);
        }
        this.formWriterMap_ = Collections.unmodifiableMap(fwmap);
    }

    public void destroy() {
        super.destroy();
    }

    public String getServletInfo() {
        return "STILTS plot form generator";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.process(request, response);
        }
        catch (Throwable e) {
            this.replyError(response, 500, e);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletOutputStream out;
        response.setHeader("STILTS-Version", Stilts.getVersion());
        String subpath = request.getPathInfo();
        String baseUrl = request.getServletPath();
        String taskName = subpath == null ? "" : subpath.replaceAll("^/*", "");
        FormWriter fwriter = (FormWriter)this.formWriterMap_.get(taskName);
        if (taskName.length() == 0) {
            response.setStatus(200);
            response.setContentType("text/html");
            out = response.getOutputStream();
            out.println("<html>");
            out.println("<head><title>Sample STILTS Forms</title></head>");
            out.println("<body>");
            out.println("<h2>Sample STILTS Forms</h2>");
            out.println("<dl>");
            out.println("<dt><b>Histogram</b></dt>");
            out.println("<dd>");
            this.writeSampleForm(baseUrl, out, "plothist");
            out.println("</dd>");
            out.println("<dt><b>2D Scatter Plot</b></dt>");
            out.println("<dd>");
            this.writeSampleForm(baseUrl, out, "plot2d");
            out.println("</dd>");
            out.println("<dt><b>3D Scatter Plot</b></dt>");
            out.println("<dd>");
            this.writeSampleForm(baseUrl, out, "plot3d");
            out.println("</dd>");
            out.println("</dl>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        if (fwriter == null) {
            response.setStatus(400);
            response.setContentType("text/html");
            out = response.getOutputStream();
            out.println("<html>");
            out.println("<head><title>No such form</title></head>");
            out.println("<body>");
            out.println("<h2>No such form</h2>");
            out.println("<h3>Known forms:</h3>");
            out.println("<ul>");
            for (String name : this.formWriterMap_.keySet()) {
                out.println("<li><a href='" + baseUrl + "/" + name + "'>" + name + "</a></li>");
            }
            out.println("</ul>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        } else {
            StarTable table;
            String tableName = request.getParameter("table");
            if (tableName == null) {
                response.setStatus(400);
                response.setContentType("text/plain");
                ServletOutputStream out2 = response.getOutputStream();
                out2.println("Parameter table not specified");
                out2.close();
                return;
            }
            try {
                table = this.tableFactory_.makeStarTable(tableName);
            }
            catch (IOException e) {
                this.replyError(response, 400, e);
                return;
            }
            response.setStatus(200);
            response.setContentType("text/html");
            ServletOutputStream out3 = response.getOutputStream();
            String head = taskName + " form for table " + tableName;
            out3.println("<html>");
            out3.println("<head><title>" + head + "</title></head>");
            out3.println("<body>");
            out3.println("<h2>" + head + "</h2>");
            fwriter.writeForm(out3, table, tableName);
            out3.println("</body>");
            out3.println("</html>");
            out3.close();
        }
    }

    private final void writeSampleForm(String baseUrl, ServletOutputStream out, String taskName) throws IOException {
        out.println("<form action='" + baseUrl + "/" + taskName + "'" + " method='GET'>");
        out.println("Table: ");
        out.println("<input type='text' name='table'/>");
        out.println("<input type='submit' value='" + taskName + " form'/>");
        out.println("</form>");
    }

    private FormWriter[] getFormWriters() throws LoadException {
        return new FormWriter[]{new Plot2dFormWriter(), new Plot3dFormWriter(), new HistogramFormWriter()};
    }

    private void replyError(HttpServletResponse response, int code, Throwable error) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw new ServletException("Error after response commit", error);
        }
        response.setStatus(code);
        response.setContentType("text/plain");
        PrintStream pout = new PrintStream((OutputStream)response.getOutputStream());
        error.printStackTrace(pout);
        pout.flush();
        pout.close();
    }

    private class HistogramFormWriter
    extends FormWriter {
        public HistogramFormWriter() throws LoadException {
            super("plothist");
        }

        @Override
        public void writeControls(ServletOutputStream out, StarTable table) throws IOException {
            out.println("<dl>");
            out.println("<dt><b>X Axis</b></dt>");
            out.println("<dd><dl>");
            this.writeColumnControl(out, "xdata", table, Number.class);
            this.writeTextControl(out, "xlo", this.getParameter("xlo"));
            this.writeTextControl(out, "xhi", this.getParameter("xhi"));
            this.writeBooleanControl(out, "xlog", this.getParameter("xlog"));
            this.writeBooleanControl(out, "xflip", this.getParameter("xflip"));
            out.println("</dl></dd>");
            out.println("<dt><b>Y Axis</b></dt>");
            out.println("<dd><dl>");
            Parameter yloParam = this.getParameter("ylo");
            yloParam.setStringDefault(null);
            this.writeTextControl(out, "ylo", this.getParameter("ylo"));
            this.writeTextControl(out, "yhi", this.getParameter("yhi"));
            this.writeBooleanControl(out, "ylog", this.getParameter("ylog"));
            out.println("</dl></dd>");
            out.println("<dt><b>Image dimensions</b></dt>");
            out.println("<dd><dl>");
            this.writeTextControl(out, "xpix", this.getParameter("xpix"));
            this.writeTextControl(out, "ypix", this.getParameter("ypix"));
            out.println("</dl></dd>");
            out.println("<dt><b>Output Format</b></dt>");
            out.println("<dl><dd>");
            ChoiceParameter fmtParam = (ChoiceParameter)this.getParameter("ofmt");
            fmtParam.setDefaultOption(fmtParam.getOptions()[0]);
            this.writeOptionControl(out, "ofmt", fmtParam);
            out.println("</dd></dl>");
            out.println("</dd>");
            out.println("</dl>");
        }
    }

    private class Plot3dFormWriter
    extends FormWriter {
        public Plot3dFormWriter() throws LoadException {
            super("plot3d");
        }

        @Override
        public void writeControls(ServletOutputStream out, StarTable table) throws IOException {
            out.println("<dl>");
            out.println("<dt><b>X Axis</b></dt>");
            out.println("<dd><dl>");
            this.writeColumnControl(out, "xdata", table, Number.class);
            this.writeTextControl(out, "xlo", this.getParameter("xlo"));
            this.writeTextControl(out, "xhi", this.getParameter("xhi"));
            this.writeBooleanControl(out, "xlog", this.getParameter("xlog"));
            this.writeBooleanControl(out, "xflip", this.getParameter("xflip"));
            out.println("</dl></dd>");
            out.println("<dt><b>Y Axis</b></dt>");
            out.println("<dd><dl>");
            this.writeColumnControl(out, "ydata", table, Number.class);
            this.writeTextControl(out, "ylo", this.getParameter("ylo"));
            this.writeTextControl(out, "yhi", this.getParameter("yhi"));
            this.writeBooleanControl(out, "ylog", this.getParameter("ylog"));
            this.writeBooleanControl(out, "yflip", this.getParameter("yflip"));
            out.println("</dl></dd>");
            out.println("<dt><b>Z Axis</b></dt>");
            out.println("<dd><dl>");
            this.writeColumnControl(out, "zdata", table, Number.class);
            this.writeTextControl(out, "zlo", this.getParameter("zlo"));
            this.writeTextControl(out, "zhi", this.getParameter("zhi"));
            this.writeBooleanControl(out, "zlog", this.getParameter("zlog"));
            this.writeBooleanControl(out, "zflip", this.getParameter("zflip"));
            out.println("</dl></dd>");
            out.println("<dt><b>Image Rotation</b></dt>");
            out.println("<dd><dl>");
            this.writeTextControl(out, "phi", this.getParameter("phi"));
            this.writeTextControl(out, "theta", this.getParameter("theta"));
            out.println("</dl></dd>");
            out.println("<dt><b>Image dimensions</b></dt>");
            out.println("<dd><dl>");
            this.writeTextControl(out, "xpix", this.getParameter("xpix"));
            this.writeTextControl(out, "ypix", this.getParameter("ypix"));
            out.println("</dl></dd>");
            out.println("<dt><b>Output Format</b></dt>");
            out.println("<dl><dd>");
            ChoiceParameter fmtParam = (ChoiceParameter)this.getParameter("ofmt");
            fmtParam.setDefaultOption(fmtParam.getOptions()[0]);
            this.writeOptionControl(out, "ofmt", fmtParam);
            out.println("</dd></dl>");
            out.println("</dd>");
            out.println("</dl>");
        }
    }

    private class Plot2dFormWriter
    extends FormWriter {
        public Plot2dFormWriter() throws LoadException {
            super("plot2d");
        }

        @Override
        public void writeControls(ServletOutputStream out, StarTable table) throws IOException {
            out.println("<dl>");
            out.println("<dt><b>X Axis</b></dt>");
            out.println("<dd><dl>");
            this.writeColumnControl(out, "xdata", table, Number.class);
            this.writeTextControl(out, "xlo", this.getParameter("xlo"));
            this.writeTextControl(out, "xhi", this.getParameter("xhi"));
            this.writeBooleanControl(out, "xlog", this.getParameter("xlog"));
            this.writeBooleanControl(out, "xflip", this.getParameter("xflip"));
            out.println("</dl></dd>");
            out.println("<dt><b>Y Axis</b></dt>");
            out.println("<dd><dl>");
            this.writeColumnControl(out, "ydata", table, Number.class);
            this.writeTextControl(out, "ylo", this.getParameter("ylo"));
            this.writeTextControl(out, "yhi", this.getParameter("yhi"));
            this.writeBooleanControl(out, "ylog", this.getParameter("ylog"));
            this.writeBooleanControl(out, "yflip", this.getParameter("yflip"));
            out.println("</dl></dd>");
            out.println("<dt><b>Image dimensions</b></dt>");
            out.println("<dd><dl>");
            this.writeTextControl(out, "xpix", this.getParameter("xpix"));
            this.writeTextControl(out, "ypix", this.getParameter("ypix"));
            out.println("</dl></dd>");
            out.println("<dt><b>Output Format</b></dt>");
            out.println("<dl><dd>");
            ChoiceParameter fmtParam = (ChoiceParameter)this.getParameter("ofmt");
            fmtParam.setDefaultOption(fmtParam.getOptions()[0]);
            this.writeOptionControl(out, "ofmt", fmtParam);
            out.println("</dd></dl>");
            out.println("</dd>");
            out.println("</dl>");
        }
    }

    private abstract class FormWriter {
        private final String taskName_;
        private final Task task_;
        private final Map paramMap_;

        public FormWriter(String taskName) throws LoadException {
            this.taskName_ = taskName;
            this.task_ = (Task)FormServlet.this.taskFactory_.createObject(taskName);
            this.paramMap_ = new HashMap();
            Parameter[] params = this.task_.getParameters();
            for (int ip = 0; ip < params.length; ++ip) {
                this.paramMap_.put(params[ip].getName(), params[ip]);
            }
        }

        public void writeForm(ServletOutputStream out, StarTable table, String tableName) throws IOException {
            out.println("<form action='" + FormServlet.this.taskBase_ + "/" + this.taskName_ + "'" + " method='GET'" + ">");
            out.println("<input type='hidden' name='in' value='" + tableName + "'/>");
            this.writeControls(out, table);
            out.println("<br />");
            out.println("<input type='submit' value='Plot'/>");
            out.println("</form>");
        }

        public abstract void writeControls(ServletOutputStream var1, StarTable var2) throws IOException;

        protected void writeColumnControl(ServletOutputStream out, String name, StarTable table, Class clazz) throws IOException {
            out.println("<dt><b>" + name + ":</b> <i>(required)</i></dt>");
            out.println("<dd>");
            ColumnInfo[] infos = Tables.getColumnInfos((StarTable)table);
            out.println("Select column ");
            out.println("<select name='" + name + "'" + " id='" + name + "'" + ">");
            out.println("<option></option>");
            for (int ic = 0; ic < infos.length; ++ic) {
                ColumnInfo info = infos[ic];
                if (!clazz.isAssignableFrom(info.getContentClass())) continue;
                out.println("<option>" + info.getName() + "</option>");
            }
            out.println("</select>");
            out.println(" or enter expression ");
            out.println("<input type='text' name='" + name + "'" + ">");
            out.println("</dd>");
        }

        protected void writeTextControl(ServletOutputStream out, String name, Parameter param) throws IOException {
            String dflt = param.getStringDefault();
            out.println("<dt><b>" + name + ":</b></dt>");
            out.println("<dd>");
            out.print("<input type='text' name='" + name + "'");
            if (dflt != null && dflt.length() > 0) {
                out.print(" value='" + dflt + "'");
            }
            out.println("/>");
            out.println("</dd>");
        }

        protected void writeOptionControl(ServletOutputStream out, String name, ChoiceParameter param) throws IOException {
            String dflt = param.getStringDefault();
            out.println("<dt><b>" + name + ":</b></dt>");
            out.println("<dd>");
            out.print("<select name='" + name + "'");
            if (dflt != null && dflt.length() > 0) {
                out.print(" value='" + dflt + "'");
            }
            out.println("/>");
            String[] options = param.getOptionNames();
            for (int io = 0; io < options.length; ++io) {
                out.println("<option>" + options[io] + "</option>");
            }
            out.println("</select>");
            out.println("</dd>");
        }

        protected void writeBooleanControl(ServletOutputStream out, String name, Parameter param) throws IOException {
            out.println("<dt><b>" + name + ":</b></dt>");
            out.println("<dd>");
            out.print("<input type='checkbox' value='true' name='" + name + "'");
            if ("true".equalsIgnoreCase(param.getStringDefault())) {
                out.print(" checked='checked'");
            }
            out.println("/>");
            out.println("</dd>");
        }

        protected Parameter getParameter(String paramName) {
            return (Parameter)this.paramMap_.get(paramName);
        }

        public String getName() {
            return this.taskName_;
        }
    }
}

