/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import adql.db.FunctionDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.vo.AdqlValidator;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;

abstract class AdqlValidatorKit {
    private final AdqlValidator.ValidatorTable[] vtables_;
    private static final String ADQL_ID = "ivo://ivoa.net/std/ADQL";

    protected AdqlValidatorKit(AdqlValidator.ValidatorTable[] vtables) {
        this.vtables_ = vtables;
    }

    public abstract AdqlValidator getValidator(String var1);

    public boolean hasTable(String tableName) {
        if (this.vtables_ == null) {
            return true;
        }
        if (tableName != null) {
            for (AdqlValidator.ValidatorTable vtable : this.vtables_) {
                if (!tableName.equalsIgnoreCase(vtable.getTableName())) continue;
                return true;
            }
        }
        return false;
    }

    public AdqlValidator getSyntaxValidator() {
        return new AdqlValidator((AdqlValidator.ValidatorTable[])null, (FunctionDef[])null, (String[])null);
    }

    public static AdqlValidatorKit createInstance(final Reporter reporter, SchemaMeta[] smetas, TapCapability tcap) {
        TapLanguage lang0;
        TapLanguage[] langs;
        AdqlValidator.ValidatorTable[] vtables;
        if (smetas == null) {
            reporter.report(FixedCode.F_NOTM, "No table metadata (earlier stages failed/skipped?) example parsing will not check table/column ids");
            vtables = null;
        } else {
            ArrayList<1> vtlist = new ArrayList<1>();
            for (SchemaMeta smeta : smetas) {
                final String sname = smeta.getName();
                for (TableMeta tmeta : smeta.getTables()) {
                    final String tname = tmeta.getName();
                    final ArrayList<String> cnames = new ArrayList<String>();
                    for (ColumnMeta cmeta : tmeta.getColumns()) {
                        cnames.add(cmeta.getName());
                    }
                    vtlist.add(new AdqlValidator.ValidatorTable(){

                        public String getSchemaName() {
                            return sname;
                        }

                        public String getTableName() {
                            return tname;
                        }

                        public Collection<String> getColumnNames() {
                            return Collections.unmodifiableList(cnames);
                        }
                    });
                }
            }
            vtables = vtlist.toArray(new AdqlValidator.ValidatorTable[0]);
        }
        if (tcap == null) {
            reporter.report(FixedCode.I_EXA2, "No table capabilities available, assuming vanilla ADQL-2.0 for examples");
            langs = null;
        } else {
            langs = tcap.getLanguages();
            if (langs == null || langs.length == 0) {
                reporter.report(FixedCode.I_EXA2, "No TAP languages declared, assuming vanilla ADQL-2.0 for examples");
            }
        }
        if (langs == null || langs.length == 0) {
            return new AdqlValidatorKit(vtables){

                @Override
                public AdqlValidator getValidator(String langId) {
                    return new AdqlValidator(vtables, new FunctionDef[0], null);
                }
            };
        }
        if (langs.length == 1) {
            lang0 = langs[0];
            return new AdqlValidatorKit(vtables){

                @Override
                public AdqlValidator getValidator(String langId) {
                    return AdqlValidator.createValidator((AdqlValidator.ValidatorTable[])vtables, (TapLanguage)lang0);
                }
            };
        }
        lang0 = AdqlValidatorKit.getDefaultLanguage(langs);
        return new AdqlValidatorKit(vtables){

            @Override
            public AdqlValidator getValidator(String langId) {
                TapLanguage lang;
                if (langId == null) {
                    reporter.report(FixedCode.I_EXA2, "Example language not specified, using " + AdqlValidatorKit.langToString(lang0));
                    lang = lang0;
                } else {
                    TapLanguage nlang = AdqlValidatorKit.getNamedLanguage(langs, langId);
                    if (nlang != null) {
                        lang = nlang;
                    } else {
                        reporter.report(FixedCode.W_EXUL, "Specified language \"" + langId + "\" undeclared in capabilities, " + "using " + AdqlValidatorKit.langToString(lang0));
                        lang = lang0;
                    }
                }
                return AdqlValidator.createValidator((AdqlValidator.ValidatorTable[])vtables, (TapLanguage)lang);
            }
        };
    }

    private static TapLanguage getDefaultLanguage(TapLanguage[] langs) {
        TapLanguage latestAdql = null;
        double latestAdqlVersion = 0.0;
        for (TapLanguage lang : langs) {
            double avers = AdqlValidatorKit.getAdqlVersion(lang);
            if (!(avers > latestAdqlVersion)) continue;
            latestAdqlVersion = avers;
            latestAdql = lang;
        }
        return latestAdql == null ? langs[0] : latestAdql;
    }

    private static TapLanguage getNamedLanguage(TapLanguage[] langs, String langId) {
        String langVers;
        String langName;
        int dashPos = langId.indexOf(45);
        if (dashPos >= 0) {
            langName = langId.substring(0, dashPos);
            langVers = langId.substring(dashPos + 1);
        } else {
            langName = langId;
            langVers = null;
        }
        for (TapLanguage lang : langs) {
            for (String vid : lang.getVersionIds()) {
                if (!langId.equals(vid)) continue;
                return lang;
            }
            if (langId.equals(lang.getName())) {
                return lang;
            }
            if (!langName.equals(lang.getName())) continue;
            for (String vers : lang.getVersions()) {
                if (!langVers.equals(vers)) continue;
                return lang;
            }
        }
        return null;
    }

    private static String langToString(TapLanguage lang) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(lang.getName());
        String[] versions = lang.getVersions();
        if (versions != null && versions.length != 0) {
            if (versions.length == 1) {
                sbuf.append("-").append(versions[0]);
            } else {
                sbuf.append("-{");
                for (int i = 0; i < versions.length; ++i) {
                    if (i > 0) {
                        sbuf.append(",");
                    }
                    sbuf.append(versions[i]);
                }
                sbuf.append("}");
            }
        }
        return sbuf.toString();
    }

    private static double getAdqlVersion(TapLanguage lang) {
        ArrayList<String> vstrs = new ArrayList<String>();
        if ("ADQL".equalsIgnoreCase(lang.getName())) {
            vstrs.addAll(Arrays.asList(lang.getVersions()));
        }
        for (String vid : lang.getVersionIds()) {
            if (!vid.startsWith("ivo://ivoa.net/std/ADQL#")) continue;
            vstrs.add(vid.substring(ADQL_ID.length() + 1));
        }
        double maxVers = 0.0;
        for (String vstr : vstrs) {
            double dv;
            try {
                dv = Double.parseDouble(vstr);
            }
            catch (NumberFormatException e) {
                dv = 0.0;
            }
            maxVers = Math.max(maxVers, dv);
        }
        return maxVers > 0.0 ? maxVers : Double.NaN;
    }
}

