/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TextOutputReporter;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.OutputFormat;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapLanguageFeature;

public class CapabilityStage
implements Stage,
CapabilityHolder {
    private TapCapability tcap_;
    private static final String ADQL2_ID = "ivo://ivoa.net/std/ADQL#v2.0";
    private static final Pattern UDF_FORM_REGEX = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)\\s*\\((.*)\\)\\s*->\\s*(.*)");
    private static final String TOKEN_REGEX = "[^()<>@,;:\\\"/\\[\\]\\?=\\s]+";
    private static final Pattern OUT_MIME_REGEX = Pattern.compile("(text|image|audio|video|application|x-[^()<>@,;:\\\"/\\[\\]\\?=\\s]+)/[^()<>@,;:\\\"/\\[\\]\\?=\\s]+\\s*(;.*)?", 2);

    @Override
    public String getDescription() {
        return "Check content of TAPRegExt capabilities record";
    }

    @Override
    public TapCapability getCapability() {
        return this.tcap_;
    }

    @Override
    public void run(Reporter reporter, EndpointSet endpointSet) {
        this.tcap_ = CapabilityStage.checkCapabilities(reporter, endpointSet.getCapabilitiesEndpoint());
    }

    public static TapCapability checkCapabilities(Reporter reporter, URL capUrl) {
        TapCapability tcap;
        reporter.report(FixedCode.I_CURL, "Reading capability metadata from " + capUrl);
        try {
            tcap = TapCapability.readTapCapability((URL)capUrl);
        }
        catch (SAXException e) {
            reporter.report(FixedCode.E_CPSX, "Error parsing capabilities metadata", e);
            return null;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_CPIO, "Error reading capabilities metadata", e);
            return null;
        }
        new CapabilityRunner(reporter, tcap).run();
        return tcap;
    }

    public static void main(String[] args) throws MalformedURLException {
        if (args.length != 1) {
            System.err.println("Usage: " + CapabilityStage.class.getName() + ": " + "<cap-doc-url>");
            System.exit(1);
        }
        TextOutputReporter reporter = new TextOutputReporter(System.out, ReportType.values(), 10, false, 1024);
        URL capUrl = new URL(args[0]);
        CapabilityStage.checkCapabilities(reporter, capUrl);
    }

    private static class CapabilityRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapCapability tcap_;

        CapabilityRunner(Reporter reporter, TapCapability tcap) {
            this.reporter_ = reporter;
            this.tcap_ = tcap;
        }

        @Override
        public void run() {
            this.checkLanguages();
            this.checkUploadMethods();
            this.checkOutputFormats();
        }

        private void checkLanguages() {
            TapLanguage[] languages = this.tcap_.getLanguages();
            if (languages.length == 0) {
                this.reporter_.report(FixedCode.E_NOQL, "No query languages declared");
                return;
            }
            boolean hasAdql2 = false;
            boolean hasAdql = false;
            for (int il = 0; il < languages.length; ++il) {
                TapLanguage lang = languages[il];
                String langName = lang.getName();
                boolean isAdql2 = false;
                if ("ADQL".equals(langName)) {
                    hasAdql = true;
                    int nvers = lang.getVersions().length;
                    assert (nvers == lang.getVersionIds().length);
                    for (int iv = 0; iv < nvers; ++iv) {
                        String msg;
                        String vname = lang.getVersions()[iv];
                        if (vname == null || vname.trim().length() == 0) {
                            String msg2 = new StringBuffer().append("Language ").append(langName).append(" has empty version string").toString();
                            this.reporter_.report(FixedCode.W_LVAN, msg2);
                        }
                        String vid = lang.getVersionIds()[iv];
                        boolean isNumber2 = "2.0".equals(vname);
                        boolean hasId2 = CapabilityStage.ADQL2_ID.equals(vid);
                        boolean bl = isAdql2 = isNumber2 || hasId2;
                        if (isNumber2 && (vid == null || vid.trim().length() == 0)) {
                            msg = new StringBuffer().append("Language ").append(langName).append(" has version ").append(vname).append(" without ivo-id=\"").append(CapabilityStage.ADQL2_ID).append("\"").toString();
                            this.reporter_.report(FixedCode.W_A2MN, msg);
                            continue;
                        }
                        if (isNumber2 && !hasId2) {
                            msg = new StringBuffer().append("Language ").append(langName).append(" has version ").append(vname).append(" with non-standard ivo-id=\"").append(vid).append("\"").append(" != \"").append(CapabilityStage.ADQL2_ID).append("\"").toString();
                            this.reporter_.report(FixedCode.W_A2MX, msg);
                            continue;
                        }
                        if (isNumber2 || !hasId2) continue;
                        msg = new StringBuffer().append("Language Version with ivo-id=\"").append(vid).append("\" is ").append(langName).append("-").append(vname).append(" not ").append("ADQL-2.0").toString();
                        this.reporter_.report(FixedCode.E_A2XI, msg);
                    }
                }
                hasAdql2 = hasAdql2 || isAdql2;
                this.checkFeatures(lang, isAdql2);
            }
            if (!hasAdql) {
                this.reporter_.report(FixedCode.E_ADQX, "ADQL not declared as a query language");
            } else if (!hasAdql2) {
                this.reporter_.report(FixedCode.W_AD2X, "ADQL-2.0 not declared as a query language");
            }
        }

        private void checkFeatures(TapLanguage language, boolean isAdql2) {
            String langName = language.getName();
            String[] versions = language.getVersions();
            if (versions.length == 1) {
                langName = langName + "-" + versions[0];
            }
            Map featuresMap = language.getFeaturesMap();
            for (String ftype : featuresMap.keySet()) {
                String msg;
                TapLanguageFeature[] features = (TapLanguageFeature[])featuresMap.get(ftype);
                if ("ivo://ivoa.net/std/TAPRegExt#features-udf".equals(ftype)) {
                    this.checkUdfs(langName, features);
                    continue;
                }
                if ("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo".equals(ftype)) {
                    this.checkAdqlGeoms(langName, features);
                    continue;
                }
                if (ftype.startsWith("ivo://ivoa.net/std/TAPRegExt")) {
                    msg = new StringBuffer().append("Unknown standard feature key \"").append(ftype).append("\" for language ").append(langName).toString();
                    this.reporter_.report(FixedCode.E_KEYX, msg);
                    continue;
                }
                msg = new StringBuffer().append("Custom feature type \"").append(ftype).append("\" for language ").append(langName).toString();
                this.reporter_.report(FixedCode.W_CULF, msg);
            }
        }

        private void checkUdfs(String langName, TapLanguageFeature[] features) {
            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                String form = features[ifeat].getForm();
                if (form != null && UDF_FORM_REGEX.matcher(form.trim()).matches()) continue;
                String msg = new StringBuffer().append("Declared ").append(langName).append(" UDF ").append(" has wrong form \"").append(form).append("\"").append(" not \"").append("f(a T[, ...]) -> T)").append("\"").toString();
                this.reporter_.report(FixedCode.E_UDFE, msg);
            }
        }

        private void checkAdqlGeoms(String langName, TapLanguageFeature[] features) {
            HashSet<String> geomSet = new HashSet<String>(Arrays.asList("AREA", "BOX", "CENTROID", "CIRCLE", "CONTAINS", "COORD1", "COORD2", "COORDSYS", "DISTANCE", "INTERSECTS", "POINT", "POLYGON", "REGION"));
            for (int ifeat = 0; ifeat < features.length; ++ifeat) {
                String form = features[ifeat].getForm();
                if (geomSet.contains(form)) continue;
                String msg = new StringBuffer().append("Declared ").append(langName).append(" geometry function \"").append(form).append("\" unknown").toString();
                this.reporter_.report(FixedCode.E_GEOX, msg);
            }
        }

        private void checkUploadMethods() {
            String msg;
            String[] upMethods = this.tcap_.getUploadMethods();
            String stdPrefix = "ivo://ivoa.net/std/TAPRegExt#upload-";
            List<String> mandatorySuffixList = Arrays.asList("inline", "http");
            List<String> stdSuffixList = Arrays.asList("inline", "http", "https", "ftp");
            for (int iu = 0; iu < upMethods.length; ++iu) {
                String upMethod = upMethods[iu];
                if (upMethod.startsWith(stdPrefix)) {
                    String frag = upMethod.substring(stdPrefix.length());
                    if (stdSuffixList.contains(frag)) continue;
                    msg = new StringBuffer().append("Unknown suffix \"").append(frag).append("\" for upload method").toString();
                    this.reporter_.report(FixedCode.E_UPBD, msg);
                    continue;
                }
                String msg2 = new StringBuffer().append("Custom upload method \"").append(upMethod).append("\"").toString();
                this.reporter_.report(FixedCode.W_UPCS, msg2);
            }
            if (upMethods.length > 0) {
                for (String msuff : mandatorySuffixList) {
                    String mmeth = stdPrefix + msuff;
                    if (Arrays.asList(upMethods).contains(mmeth)) continue;
                    msg = "Mandatory upload method " + mmeth + " not declared" + ", though uploads are " + "apparently supported";
                    this.reporter_.report(FixedCode.E_MUPM, msg);
                }
            }
        }

        private void checkOutputFormats() {
            OutputFormat[] outFormats = this.tcap_.getOutputFormats();
            if (outFormats.length == 0) {
                this.reporter_.report(FixedCode.E_NOOF, "No output formats defined");
                return;
            }
            List<String> outKeyList = Arrays.asList("#output-votable-td", "#output-votable-binary", "#output-votable-binary2");
            String stdPrefix = "ivo://ivoa.net/std/TAPRegExt";
            for (int iof = 0; iof < outFormats.length; ++iof) {
                String ivoid;
                String ofName;
                OutputFormat of = outFormats[iof];
                String[] aliases = of.getAliases();
                String mime = of.getMime();
                String string = ofName = aliases.length > 0 ? aliases[0] : mime;
                if (mime == null || !OUT_MIME_REGEX.matcher(mime.trim()).matches()) {
                    String msg = new StringBuffer().append("Illegal MIME type \"").append(mime).append("\" for output format ").append(ofName).toString();
                    this.reporter_.report(FixedCode.E_BMIM, msg);
                }
                if ((ivoid = of.getIvoid()) == null || !ivoid.startsWith(stdPrefix) || outKeyList.contains(ivoid.substring(stdPrefix.length()))) continue;
                String msg = new StringBuffer().append("Unknown standard output format key \"").append(ivoid).append(" for output format ").append(ofName).toString();
                this.reporter_.report(FixedCode.E_XOFK, msg);
            }
        }
    }
}

