/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.taplint.CompareMetadataStage;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.votable.VOStarTable;

public class ColumnMetadataStage
implements Stage {
    private final TapRunner tapRunner_;
    private final MetadataHolder metaHolder_;
    private int maxTables_;
    private static final AdqlSyntax syntax_ = AdqlSyntax.getInstance();

    public ColumnMetadataStage(TapRunner tapRunner, MetadataHolder metaHolder, int maxTables) {
        this.tapRunner_ = tapRunner;
        this.metaHolder_ = metaHolder;
        this.maxTables_ = maxTables;
    }

    public void setMaxTestTables(int maxTables) {
        this.maxTables_ = maxTables;
    }

    @Override
    public String getDescription() {
        return "Check table query result columns against declared metadata";
    }

    @Override
    public void run(Reporter reporter, EndpointSet endpointSet) {
        TableMeta[] tmetas;
        SchemaMeta[] smetas = this.metaHolder_.getTableMetadata();
        ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
        if (smetas != null) {
            for (SchemaMeta smeta : smetas) {
                for (TableMeta tmeta : smeta.getTables()) {
                    tlist.add(tmeta);
                }
            }
        }
        if ((tmetas = tlist.toArray(new TableMeta[0])).length == 0) {
            reporter.report(FixedCode.F_NOTM, "No table metadata available (earlier stages failed/skipped?) - will not run test queries");
            return;
        }
        if (this.maxTables_ > 0 && tmetas.length > this.maxTables_) {
            TableMeta[] tms = new TableMeta[this.maxTables_];
            System.arraycopy(tmetas, 0, tms, 0, this.maxTables_);
            reporter.report(FixedCode.I_TMAX, "Testing only " + this.maxTables_ + "/" + tmetas.length + " tables");
            tmetas = tms;
        }
        new Checker(reporter, endpointSet, this.tapRunner_, tmetas).run();
        this.tapRunner_.reportSummary(reporter);
    }

    public static String normaliseColumnName(String colName) {
        return syntax_.unquote(colName).toLowerCase();
    }

    private static class Checker
    implements Runnable {
        private final Reporter reporter_;
        private final EndpointSet endpointSet_;
        private final TapRunner tRunner_;
        private final TableMeta[] tmetas_;

        Checker(Reporter reporter, EndpointSet endpointSet, TapRunner tRunner, TableMeta[] tmetas) {
            this.reporter_ = reporter;
            this.endpointSet_ = endpointSet;
            this.tRunner_ = tRunner;
            this.tmetas_ = tmetas;
        }

        @Override
        public void run() {
            for (int it = 0; it < this.tmetas_.length; ++it) {
                this.checkTable(this.tmetas_[it]);
            }
        }

        private void checkTable(TableMeta tmeta) {
            String msg;
            String cname;
            Iterator cit;
            StringBuilder sbuf;
            StarTable result;
            int ntop = 1;
            String tname = tmeta.getName();
            String adql = "SELECT TOP " + ntop + " * FROM " + tname;
            TapQuery tq = new TapQuery(this.endpointSet_, adql, null);
            try {
                result = this.tRunner_.attemptGetResultTable(this.reporter_, tq);
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_QERR, "Failed TAP query " + adql, e);
                return;
            }
            catch (SAXException e) {
                this.reporter_.report(FixedCode.E_QERX, "Failed to parse result for TAP query " + adql, e);
                return;
            }
            try {
                result = Tables.randomTable((StarTable)result);
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_VTIO, "Error reading table result for " + adql, e);
                return;
            }
            long nrow = result.getRowCount();
            if (nrow > (long)ntop) {
                String msg2 = "Too many rows returned (" + nrow + " > " + ntop + " for " + adql;
                this.reporter_.report(FixedCode.E_RRTO, msg2);
            }
            ColumnMeta[] colMetas = tmeta.getColumns();
            LinkedHashMap<String, ColumnMeta> declaredMap = new LinkedHashMap<String, ColumnMeta>();
            for (int ic = 0; ic < colMetas.length; ++ic) {
                ColumnMeta colMeta = colMetas[ic];
                declaredMap.put(ColumnMetadataStage.normaliseColumnName(colMeta.getName()), colMeta);
            }
            LinkedHashMap<String, ColumnInfo> resultMap = new LinkedHashMap<String, ColumnInfo>();
            for (int ic = 0; ic < result.getColumnCount(); ++ic) {
                ColumnInfo colInfo = result.getColumnInfo(ic);
                resultMap.put(ColumnMetadataStage.normaliseColumnName(colInfo.getName()), colInfo);
            }
            ArrayList dOnlyList = new ArrayList(declaredMap.keySet());
            dOnlyList.removeAll(resultMap.keySet());
            int ndo = dOnlyList.size();
            if (ndo > 0) {
                sbuf = new StringBuilder().append("SELECT * for table ").append(tname).append(" lacks ").append(ndo).append(" declared ").append(ndo == 1 ? "column" : "columns").append(": ");
                cit = dOnlyList.iterator();
                while (cit.hasNext()) {
                    cname = (String)cit.next();
                    sbuf.append(((ColumnMeta)declaredMap.get(cname)).getName());
                    if (!cit.hasNext()) continue;
                    sbuf.append(", ");
                }
                this.reporter_.report(FixedCode.E_CLDR, sbuf.toString());
            }
            ArrayList rOnlyList = new ArrayList(resultMap.keySet());
            rOnlyList.removeAll(declaredMap.keySet());
            int nro = rOnlyList.size();
            if (nro > 0) {
                sbuf = new StringBuilder().append("SELECT * for table ").append(tname).append(" returns ").append(nro).append(" undeclared ").append(nro == 1 ? "column" : "columns").append(": ");
                cit = rOnlyList.iterator();
                while (cit.hasNext()) {
                    cname = (String)cit.next();
                    sbuf.append(((ColumnInfo)resultMap.get(cname)).getName());
                    if (!cit.hasNext()) continue;
                    sbuf.append(", ");
                }
                this.reporter_.report(FixedCode.E_CLRD, sbuf.toString());
            }
            ArrayList bothList = new ArrayList(declaredMap.keySet());
            bothList.retainAll(resultMap.keySet());
            for (String cname2 : bothList) {
                String dName = ((ColumnMeta)declaredMap.get(cname2)).getName();
                String rName = ((ColumnInfo)resultMap.get(cname2)).getName();
                if (syntax_.unquote(dName).equals(syntax_.unquote(rName))) continue;
                msg = "Declared/result column " + "capitalization mismatch in table " + tname + " " + dName + " != " + rName;
                this.reporter_.report(FixedCode.W_CCAS, msg);
            }
            for (String cname2 : bothList) {
                String rType;
                String dType = ((ColumnMeta)declaredMap.get(cname2)).getDataType();
                if (CompareMetadataStage.compatibleDataTypes(dType, rType = (String)((ColumnInfo)resultMap.get(cname2)).getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class))) continue;
                msg = "Declared/result type mismatch " + "for column " + ((ColumnInfo)resultMap.get(cname2)).getName() + " in table " + tname + " (" + dType + " != " + rType + ")";
                this.reporter_.report(FixedCode.E_CTYP, msg);
            }
        }
    }
}

