/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.net.URL;
import java.util.Arrays;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;

public class ContentType {
    private final String[] permittedTypes_;

    public ContentType(String[] permittedTypes) {
        this.permittedTypes_ = permittedTypes;
    }

    public void checkType(Reporter reporter, String declaredType, URL url) {
        if (declaredType == null || declaredType.trim().length() == 0) {
            reporter.report(FixedCode.W_NOCT, "No Content-Type header for " + url);
        } else if (!this.isPermitted(declaredType)) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("Incorrect Content-Type \"").append(declaredType).append("\"").append(", should be ");
            if (this.permittedTypes_.length == 1) {
                sbuf.append(this.permittedTypes_[0]);
            } else {
                sbuf.append("one of ").append(Arrays.asList(this.permittedTypes_));
            }
            sbuf.append(" for ").append(url);
            reporter.report(FixedCode.E_GMIM, sbuf.toString());
        }
    }

    private boolean isPermitted(String declaredType) {
        for (String typ : this.permittedTypes_) {
            if (!declaredType.startsWith(typ)) continue;
            return true;
        }
        return false;
    }
}

