/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;

public class IvoaSchemaResolver
implements LSResourceResolver {
    private final Reporter reporter_;
    private volatile int nResolved_;
    public static final String VODATASERVICE_URI;
    public static final String CAPABILITIES_URI;
    public static final String AVAILABILITY_URI;
    private static final String TABLES_URI;
    private static final String VORESOURCE_URI;
    private static final String TAPREGEXT_URI;
    private static final String STC_URI;
    private static final String VODATASERVICE10_URI;
    private static final String XLINK_URI;
    private static final Map<String, URL> schemaMap_;
    private static final String SCHEMA_TYPE = "http://www.w3.org/2001/XMLSchema";

    public IvoaSchemaResolver(Reporter reporter) {
        this.reporter_ = reporter;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (SCHEMA_TYPE.equals(type) && namespaceURI != null) {
            URL location = schemaMap_.get(namespaceURI);
            if (location != null) {
                ++this.nResolved_;
                return new UrlInput(location);
            }
            this.reporter_.report(FixedCode.W_UNSC, "Schema from unknown namespace during validation: " + namespaceURI);
            return null;
        }
        return null;
    }

    public int getResolvedCount() {
        return this.nResolved_;
    }

    static Map<String, URL> getSchemaMap() {
        return schemaMap_;
    }

    static {
        Class<IvoaSchemaResolver> base = IvoaSchemaResolver.class;
        HashMap<String, URL> map = new HashMap<String, URL>();
        VODATASERVICE_URI = "http://www.ivoa.net/xml/VODataService/v1.1";
        map.put("http://www.ivoa.net/xml/VODataService/v1.1", base.getResource("VODataService-v1.1.xsd"));
        CAPABILITIES_URI = "http://www.ivoa.net/xml/VOSICapabilities/v1.0";
        map.put("http://www.ivoa.net/xml/VOSICapabilities/v1.0", base.getResource("VOSICapabilities-v1.0.xsd"));
        AVAILABILITY_URI = "http://www.ivoa.net/xml/VOSIAvailability/v1.0";
        map.put("http://www.ivoa.net/xml/VOSIAvailability/v1.0", base.getResource("VOSIAvailability-v1.0.xsd"));
        TABLES_URI = "http://www.ivoa.net/xml/VOSITables/v1.0";
        map.put("http://www.ivoa.net/xml/VOSITables/v1.0", base.getResource("VOSITables-v1.0.xsd"));
        VORESOURCE_URI = "http://www.ivoa.net/xml/VOResource/v1.0";
        map.put("http://www.ivoa.net/xml/VOResource/v1.0", base.getResource("VOResource-v1.0.xsd"));
        TAPREGEXT_URI = "http://www.ivoa.net/xml/TAPRegExt/v1.0";
        map.put("http://www.ivoa.net/xml/TAPRegExt/v1.0", base.getResource("TAPRegExt-v1.0-Erratum1.xsd"));
        STC_URI = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd";
        map.put("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", base.getResource("stc-v1.30.xsd"));
        VODATASERVICE10_URI = "http://www.ivoa.net/xml/VODataService/v1.0";
        map.put("http://www.ivoa.net/xml/VODataService/v1.0", base.getResource("VODataService-v1.0.xsd"));
        XLINK_URI = "http://www.w3.org/1999/xlink";
        map.put("http://www.w3.org/1999/xlink", base.getResource("xlink.xsd"));
        schemaMap_ = Collections.unmodifiableMap(map);
    }

    private static class UrlInput
    implements LSInput {
        private final URL url_;

        public UrlInput(URL url) {
            this.url_ = url;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSystemId() {
            return this.url_.toString();
        }

        @Override
        public void setSystemId(String systemId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException();
        }
    }
}

