/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.CompareMetadataStage;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapQuery;

public class ObsTapStage
implements Stage {
    private final TapRunner tapRunner_;
    private final CapabilityHolder capHolder_;
    private final MetadataHolder metaHolder_;
    private static final String OBSCORE10_ID_WRONG = "ivo://ivoa.net/std/ObsCore-1.0";
    private static final String OBSCORE11_ID_WRONG = "ivo://ivoa.net/std/ObsCore/v1.1";
    private static final String OBSCORE_TNAME = "ivoa.ObsCore";

    public ObsTapStage(TapRunner tapRunner, CapabilityHolder capHolder, MetadataHolder metaHolder) {
        this.tapRunner_ = tapRunner;
        this.capHolder_ = capHolder;
        this.metaHolder_ = metaHolder;
    }

    @Override
    public String getDescription() {
        return "Test implementation of ObsCore Data Model";
    }

    @Override
    public void run(Reporter reporter, EndpointSet endpointSet) {
        boolean is11;
        SchemaMeta[] smetas;
        ObscoreVersion obscoreVersion;
        TapCapability tcap = this.capHolder_.getCapability();
        if (tcap != null) {
            obscoreVersion = this.getObscoreDm(reporter, tcap);
            if (obscoreVersion == null) {
                reporter.report(FixedCode.I_NODM, "Table capabilities lists no ObsCore DataModel - no ObsCore tests");
                return;
            }
        } else {
            obscoreVersion = null;
        }
        if ((smetas = this.metaHolder_.getTableMetadata()) == null) {
            reporter.report(FixedCode.F_NOTM, "No table metadata (earlier stages failed/skipped?)");
            return;
        }
        TableMeta obsMeta = null;
        for (SchemaMeta smeta : smetas) {
            for (TableMeta tmeta : smeta.getTables()) {
                if (!OBSCORE_TNAME.equalsIgnoreCase(tmeta.getName())) continue;
                obsMeta = tmeta;
            }
        }
        if (obsMeta == null) {
            String missingMsg = "No table with name ivoa.ObsCore";
            if (obscoreVersion != null) {
                reporter.report(FixedCode.F_NOTB, missingMsg);
            } else {
                reporter.report(FixedCode.I_OCCP, missingMsg + "; probably just means no ObsCore intended" + " but can't tell for sure" + " because no capabilities present" + " (earlier stages failed/skipped?)");
            }
            return;
        }
        if (obscoreVersion != null) {
            is11 = obscoreVersion.is11_;
        } else {
            String msg = new StringBuffer().append(OBSCORE_TNAME).append(" table present but no ObsCore DM").append(" declaration available").append("; assume ObsCore 1.0").toString();
            reporter.report(FixedCode.W_DMDC, msg);
            is11 = false;
        }
        reporter.report(FixedCode.I_DMID, "Checking against ObsCore DM " + (is11 ? "1.1" : "1.0"));
        new ObsTapRunner(reporter, endpointSet, obsMeta, is11, this.tapRunner_).run();
    }

    private ObscoreVersion getObscoreDm(Reporter reporter, TapCapability tcap) {
        String[] dms = tcap.getDataModels();
        ArrayList<String> dmList = new ArrayList<String>();
        if (dms != null) {
            for (int i = 0; i < dms.length; ++i) {
                dmList.add(dms[i].toLowerCase());
            }
        }
        boolean has10 = dmList.contains(ObscoreVersion.V10.ivoid_.toLowerCase());
        boolean has11 = dmList.contains(ObscoreVersion.V11.ivoid_.toLowerCase());
        boolean has10wrong = dmList.contains(OBSCORE10_ID_WRONG.toLowerCase());
        boolean has11wrong = dmList.contains(OBSCORE11_ID_WRONG.toLowerCase());
        if (has11) {
            if (has10) {
                String msg = new StringBuffer().append("Declared both v1.0 and v1.1 ObsCore DMs (").append(ObscoreVersion.V10.ivoid_).append(" and ").append(ObscoreVersion.V11.ivoid_).append("); can't simultaneously satisfy both").toString();
                reporter.report(FixedCode.W_DMSS, msg);
            }
            return ObscoreVersion.V11;
        }
        if (has10) {
            return ObscoreVersion.V10;
        }
        if (has10wrong) {
            String msg = new StringBuffer().append("Wrong ObsCore identifier ").append(OBSCORE10_ID_WRONG).append(" reported, should be ").append(ObscoreVersion.V10.ivoid_).append(" (known error in TAPRegExt 1.0 document)").toString();
            reporter.report(FixedCode.W_WODM, msg);
            return ObscoreVersion.V10;
        }
        if (has11wrong) {
            String msg = new StringBuffer().append("Wrong ObsCore identifier ").append(OBSCORE11_ID_WRONG).append(" reported, should be ").append(ObscoreVersion.V11.ivoid_).append(" (corrected from PR-ObsCore-20160330)").toString();
            reporter.report(FixedCode.W_WODM, msg);
            return ObscoreVersion.V11;
        }
        for (String dm : dmList) {
            if (dm.toLowerCase().indexOf("obscore") < 0) continue;
            String msg = new StringBuffer().append("Mis-spelt ObsCore identifier? ").append(dm).append(" reported, should be ").append(ObscoreVersion.V10.ivoid_).append(" or ").append(ObscoreVersion.V11.ivoid_).append("; assuming ObsCore 1.0").toString();
            reporter.report(FixedCode.W_IODM, msg);
            return ObscoreVersion.V10;
        }
        return null;
    }

    private static Map<String, ObsCol> createMandatoryColumns(boolean is11) {
        ArrayList<ObsCol> list = new ArrayList<ObsCol>();
        list.addAll(Arrays.asList(new ObsCol("dataproduct_type", Type.VARCHAR, is11 ? "ObsDataset.dataProductType" : "Obs.dataProductType", "meta.id"), new ObsCol("calib_level", Type.INTEGER, is11 ? "ObsDataset.calibLevel" : "Obs.calibLevel", "meta.code;obs.calib"), new ObsCol("obs_collection", Type.VARCHAR, "DataID.Collection", "meta.id"), new ObsCol("obs_id", Type.VARCHAR, "DataID.observationID", "meta.id"), new ObsCol("obs_publisher_did", Type.VARCHAR, "Curation.PublisherDID", "meta.ref.url;meta.curation"), new ObsCol("access_url", Type.CLOB, "Access.Reference", "meta.ref.url"), new ObsCol("access_format", Type.VARCHAR, "Access.Format", "meta.code.mime"), new ObsCol("access_estsize", Type.BIGINT, "Access.Size", "phys.size;meta.file", "kbyte"), new ObsCol("target_name", Type.VARCHAR, "Target.Name", "meta.id;src"), new ObsCol("s_ra", Type.DOUBLE, "Char.SpatialAxis.Coverage.Location.Coord.Position2D.Value2.C1", "pos.eq.ra", "deg"), new ObsCol("s_dec", Type.DOUBLE, "Char.SpatialAxis.Coverage.Location.Coord.Position2D.Value2.C2", "pos.eq.dec", "deg"), new ObsCol("s_fov", Type.DOUBLE, "Char.SpatialAxis.Coverage.Bounds.Extent.diameter", "phys.angSize;instr.fov", "deg"), new ObsCol("s_region", Type.REGION, "Char.SpatialAxis.Coverage.Support.Area", is11 ? "phys.outline;obs.field" : "phys.angArea;obs", null), new ObsCol("s_resolution", Type.DOUBLE, is11 ? "Char.SpatialAxis.Resolution.Refval.value" : "Char.SpatialAxis.Resolution.refval", "pos.angResolution", "arcsec"), new ObsCol("t_min", Type.DOUBLE, is11 ? "Char.TimeAxis.Coverage.Bounds.Limits.StartTime" : "Char.TimeAxis.Coverage.Bounds.Limits.Interval.StartTime", "time.start;obs.exposure", "d"), new ObsCol("t_max", Type.DOUBLE, is11 ? "Char.TimeAxis.Coverage.Bounds.Limits.StopTime" : "Char.TimeAxis.Coverage.Bounds.Limits.Interval.StopTime", "time.end;obs.exposure", "d"), new ObsCol("t_exptime", Type.DOUBLE, "Char.TimeAxis.Coverage.Support.Extent", "time.duration;obs.exposure", "s"), new ObsCol("t_resolution", Type.DOUBLE, is11 ? "Char.TimeAxis.Resolution.Refval.value" : "Char.TimeAxis.Resolution.refval", "time.resolution", "s"), new ObsCol("em_min", Type.DOUBLE, is11 ? "Char.SpectralAxis.Coverage.Bounds.Limits.LoLimit" : "Char.SpectralAxis.Coverage.Bounds.Limits.Interval.LoLim", "em.wl;stat.min", "m"), new ObsCol("em_max", Type.DOUBLE, is11 ? "Char.SpectralAxis.Coverage.Bounds.Limits.HiLimit" : "Char.SpectralAxis.Coverage.Bounds.Limits.Interval.HiLim", "em.wl;stat.max", "m"), new ObsCol("em_res_power", Type.DOUBLE, "Char.SpectralAxis.Resolution.ResolPower.refVal", "spect.resolution"), new ObsCol("o_ucd", Type.VARCHAR, "Char.ObservableAxis.ucd", "meta.ucd"), new ObsCol("pol_states", Type.VARCHAR, "Char.PolarizationAxis.stateList", "meta.code;phys.polarization"), new ObsCol("facility_name", Type.VARCHAR, "Provenance.ObsConfig.facility.name", "meta.id;instr.tel"), new ObsCol("instrument_name", Type.VARCHAR, "Provenance.ObsConfig.instrument.name", "meta.id;instr")));
        assert (list.size() == 25);
        if (is11) {
            list.addAll(Arrays.asList(new ObsCol("s_xel1", Type.BIGINT, "Char.SpatialAxis.numBins1", "meta.number"), new ObsCol("s_xel2", Type.BIGINT, "Char.SpatialAxis.numBins2", "meta.number"), new ObsCol("t_xel", Type.BIGINT, "Char.TimeAxis.numBins", "meta.number"), new ObsCol("em_xel", Type.BIGINT, "Char.SpectralAxis.numBins", "meta.number"), new ObsCol("pol_xel", Type.BIGINT, "Char.PolarizationAxis.numBins", "meta.number")));
            assert (list.size() == 30);
        }
        Map<String, ObsCol> map = ObsTapStage.toMap(list);
        ArrayList<String> dpopts = new ArrayList<String>(Arrays.asList("image", "cube", "spectrum", "sed", "timeseries", "visibility", "event"));
        if (is11) {
            dpopts.add("measurements");
        }
        map.get((Object)"dataproduct_type").hardOptions_ = dpopts.toArray(new String[0]);
        map.get((Object)"calib_level").range_ = new Integer[]{new Integer(0), new Integer(is11 ? 4 : 3)};
        map.get((Object)"calib_level").nullForbidden_ = true;
        map.get((Object)"obs_collection").nullForbidden_ = true;
        map.get((Object)"obs_id").nullForbidden_ = true;
        map.get((Object)"obs_publisher_did").nullForbidden_ = true;
        return map;
    }

    private static Map<String, ObsCol> createOptionalColumns(boolean is11) {
        ArrayList<ObsCol> list = new ArrayList<ObsCol>();
        list.addAll(Arrays.asList(new ObsCol("dataproduct_subtype", Type.VARCHAR, is11 ? "ObsDataset.dataProductSubtype" : "Obs.dataProductSubtype", "meta.id"), new ObsCol("target_class", Type.VARCHAR, "Target.Class", "src.class"), new ObsCol("obs_creation_date", Type.TIMESTAMP, "DataID.Date", "time;meta.dataset"), new ObsCol("obs_creator_name", Type.VARCHAR, "DataID.Creator", "meta.id"), new ObsCol("obs_creator_did", Type.VARCHAR, "DataID.CreatorDID", "meta.id"), new ObsCol("obs_title", Type.VARCHAR, "DataID.Title", "meta.title;obs"), new ObsCol("publisher_id", Type.VARCHAR, "Curation.PublisherID", "meta.ref.url;meta.curation"), new ObsCol("bib_reference", Type.VARCHAR, "Curation.Reference", "meta.bib.bibcode"), new ObsCol("data_rights", Type.VARCHAR, "Curation.Rights", "meta.code"), new ObsCol("obs_release_date", Type.TIMESTAMP, "Curation.releaseDate", "time.release"), new ObsCol("s_ucd", Type.VARCHAR, "Char.SpatialAxis.ucd", "meta.ucd"), new ObsCol("s_unit", Type.VARCHAR, "Char.SpatialAxis.unit", "meta.unit"), new ObsCol("s_resolution_min", Type.DOUBLE, is11 ? "Char.SpatialAxis.Resolution.Bounds.Limits.LoLimit" : "Char.SpatialAxis.Resolution.Bounds.Limits.Interval.LoLim", "pos.angResolution;stat.min", "arcsec"), new ObsCol("s_resolution_max", Type.DOUBLE, is11 ? "Char.SpatialAxis.Resolution.Bounds.Limits.HiLimit" : "Char.SpatialAxis.Resolution.Bounds.Limits.Interval.HiLim", "pos.angResolution;stat.max", "arcsec"), new ObsCol("s_calib_status", Type.VARCHAR, is11 ? "Char.SpatialAxis.calibrationStatus" : "Char.SpatialAxis.calibStatus", "meta.code.qual"), new ObsCol("s_stat_error", Type.DOUBLE, "Char.SpatialAxis.Accuracy.statError.refval.value", "stat.error;pos.eq", "arcsec"), new ObsCol("t_calib_status", Type.VARCHAR, is11 ? "Char.TimeAxis.calibrationStatus" : "Char.TimeAxis.calibStatus", "meta.code.qual"), new ObsCol("t_stat_error", Type.DOUBLE, "Char.TimeAxis.Accuracy.StatError.refval.value", "stat.error;time", "s"), new ObsCol("em_ucd", Type.VARCHAR, "Char.SpectralAxis.ucd", "meta.ucd"), new ObsCol("em_unit", Type.VARCHAR, "Char.SpectralAxis.unit", "meta.unit"), new ObsCol("em_calib_status", Type.VARCHAR, is11 ? "Char.SpectralAxis.calibrationStatus" : "Char.SpectralAxis.calibStatus", "meta.code.qual"), new ObsCol("em_res_power_min", Type.DOUBLE, is11 ? "Char.SpectralAxis.Resolution.ResolPower.LoLimit" : "Char.SpectralAxis.Resolution.ResolPower.LoLim", "spect.resolution;stat.min"), new ObsCol("em_res_power_max", Type.DOUBLE, is11 ? "Char.SpectralAxis.Resolution.ResolPower.HiLimit" : "Char.SpectralAxis.Resolution.ResolPower.HiLim", "spect.resolution;stat.max"), new ObsCol("em_resolution", Type.DOUBLE, "Char.SpectralAxis.Resolution.refval.value", "spect.resolution;stat.mean", "m"), new ObsCol("em_stat_error", Type.DOUBLE, "Char.SpectralAxis.Accuracy.StatError.refval.value", "stat.error;em", "m"), new ObsCol("o_unit", Type.VARCHAR, "Char.ObservableAxis.unit", "meta.unit"), new ObsCol("o_calib_status", Type.VARCHAR, is11 ? "Char.ObservableAxis.calibrationStatus" : "Char.ObservableAxis.calibStatus", "meta.code.qual"), new ObsCol("o_stat_error", Type.DOUBLE, "Char.ObservableAxis.Accuracy.StatError.refval.value", "stat.error;phot.flux"), new ObsCol("proposal_id", Type.VARCHAR, "Provenance.Proposal.identifier", "meta.id;obs.proposal")));
        assert (list.size() == 29);
        if (is11) {
            list.addAll(Arrays.asList(new ObsCol("s_pixel_scale", Type.DOUBLE, "Char.SpatialAxis.Sampling.RefVal.SamplingPeriod", "phys.angSize;instr.pixel", "arcsec")));
            assert (list.size() == 30);
        }
        Map<String, ObsCol> map = ObsTapStage.toMap(list);
        map.get((Object)"s_calib_status").softOptions_ = new String[]{"uncalibrated", "raw", "calibrated"};
        map.get((Object)"em_calib_status").softOptions_ = new String[]{"calibrated", "uncalibrated", "relative", "absolute"};
        map.get((Object)"t_calib_status").softOptions_ = new String[]{"calibrated", "uncalibrated", "relative", "raw"};
        map.get((Object)"o_calib_status").softOptions_ = new String[]{"absolute", "relative", "normalized", "any"};
        return map;
    }

    private static Map<String, ObsCol> toMap(List<ObsCol> cols) {
        LinkedHashMap<String, ObsCol> map = new LinkedHashMap<String, ObsCol>();
        for (ObsCol col : cols) {
            map.put(ObsTapStage.nameKey(col.name_), col);
        }
        assert (cols.size() == map.size());
        return map;
    }

    private static Map<String, ColumnMeta> toMap(ColumnMeta[] cols) {
        LinkedHashMap<String, ColumnMeta> map = new LinkedHashMap<String, ColumnMeta>();
        for (int i = 0; i < cols.length; ++i) {
            map.put(ObsTapStage.nameKey(cols[i].getName()), cols[i]);
        }
        return map;
    }

    private static String nameKey(String name) {
        return name.toLowerCase();
    }

    private static class ObsCol {
        final String name_;
        final Type type_;
        final String utype_;
        final String ucd_;
        final String unit_;
        boolean nullForbidden_;
        String[] hardOptions_;
        String[] softOptions_;
        Comparable[] range_;

        ObsCol(String name, Type type, String utype, String ucd, String unit) {
            this.name_ = name;
            this.type_ = type;
            this.utype_ = "obscore:" + utype;
            this.ucd_ = ucd;
            this.unit_ = unit;
        }

        ObsCol(String name, Type type, String utype, String ucd) {
            this(name, type, utype, ucd, null);
        }
    }

    private static enum ObscoreVersion {
        V10("ivo://ivoa.net/std/ObsCore/v1.0", false),
        V11("ivo://ivoa.net/std/ObsCore#core-1.1", true);

        final String ivoid_;
        final boolean is11_;

        private ObscoreVersion(String ivoid, boolean is11) {
            this.ivoid_ = ivoid;
            this.is11_ = is11;
        }
    }

    private static abstract class TableData {
        private TableData() {
        }

        abstract int getRowCount();

        abstract Object getCell(int var1, int var2);
    }

    private static enum Type {
        INTEGER(new String[]{"SMALLINT", "BIGINT"}, new String[]{"short", "int", "long"}),
        BIGINT(new String[]{"SMALLINT", "INTEGER"}, new String[]{"short", "int", "long"}),
        DOUBLE(new String[]{"REAL"}, new String[]{"float", "double"}),
        VARCHAR(new String[]{"CHAR"}, new String[]{"char", "unicodeChar"}),
        TIMESTAMP(new String[0], new String[]{"char", "unicodeChar"}),
        REGION(new String[0], new String[]{"char", "unicodeChar"}),
        CLOB(new String[]{"VARCHAR", "CHAR"}, new String[]{"char", "unicodeChar"});

        private final Set<String> adqlTypeSet_;
        private final Set<String> votableTypeSet_;

        private Type(String[] adqlTypes, String[] votableTypes) {
            this.adqlTypeSet_ = new HashSet<String>(Arrays.asList(adqlTypes));
            this.votableTypeSet_ = new HashSet<String>(Arrays.asList(votableTypes));
        }

        boolean isEqual(String dtype) {
            String baseDtype = CompareMetadataStage.stripAdqlType(dtype);
            return this.name().equals(baseDtype) || this.votableTypeSet_.contains(baseDtype);
        }

        boolean isCompatible(String dtype) {
            String baseDtype = CompareMetadataStage.stripAdqlType(dtype);
            return this.name().equals(baseDtype) || this.adqlTypeSet_.contains(baseDtype) || this.votableTypeSet_.contains(baseDtype);
        }
    }

    private static class ObsTapRunner
    implements Runnable {
        private final Reporter reporter_;
        private final EndpointSet endpointSet_;
        private final TapRunner tRunner_;
        private final Map<String, ColumnMeta> gotColMap_;
        private final Map<String, ObsCol> reqColMap_;
        private final Map<String, ObsCol> optColMap_;

        ObsTapRunner(Reporter reporter, EndpointSet endpointSet, TableMeta obsMeta, boolean is11, TapRunner tapRunner) {
            this.reporter_ = reporter;
            this.endpointSet_ = endpointSet;
            this.gotColMap_ = ObsTapStage.toMap(obsMeta.getColumns());
            this.tRunner_ = tapRunner;
            this.reqColMap_ = ObsTapStage.createMandatoryColumns(is11);
            this.optColMap_ = ObsTapStage.createOptionalColumns(is11);
        }

        @Override
        public void run() {
            int nreq = 0;
            for (String reqName : this.reqColMap_.keySet()) {
                ObsCol reqCol = this.reqColMap_.get(reqName);
                ColumnMeta gotCol = this.gotColMap_.get(reqName);
                if (gotCol != null) {
                    this.checkMetadata(gotCol, reqCol);
                    ++nreq;
                    continue;
                }
                String msg = new StringBuffer().append("Required ObsCore column ").append(reqName).append(" is missing").toString();
                this.reporter_.report(FixedCode.E_OCOL, msg);
            }
            int nopt = 0;
            for (String optName : this.optColMap_.keySet()) {
                ObsCol optCol = this.optColMap_.get(optName);
                ColumnMeta gotCol = this.gotColMap_.get(optName);
                if (gotCol == null) continue;
                this.checkMetadata(gotCol, optCol);
                ++nopt;
            }
            for (String cname : this.gotColMap_.keySet()) {
                ObsCol stdCol = null;
                if (stdCol == null) {
                    stdCol = this.reqColMap_.get(cname);
                }
                if (stdCol == null) {
                    stdCol = this.optColMap_.get(cname);
                }
                if (stdCol == null) continue;
                this.checkContent(this.gotColMap_.get(cname), stdCol);
            }
            int nother = this.gotColMap_.size() - nreq - nopt;
            String msg = new StringBuffer().append("ivoa.ObsCore columns: ").append(nreq).append("/").append(this.reqColMap_.size()).append(" required, ").append(nopt).append("/").append(this.optColMap_.size()).append(" optional, ").append(nother).append(" custom").toString();
            this.reporter_.report(FixedCode.S_COLS, msg);
            this.tRunner_.reportSummary(this.reporter_);
        }

        private void checkMetadata(ColumnMeta gotCol, ObsCol stdCol) {
            String cname = gotCol.getName();
            this.compareItem(cname, "Utype", FixedCode.E_CUTP, stdCol.utype_, gotCol.getUtype(), false);
            this.compareItem(cname, "UCD", FixedCode.E_CUCD, stdCol.ucd_, gotCol.getUcd(), false);
            this.compareItem(cname, "Unit", FixedCode.E_CUNI, stdCol.unit_, gotCol.getUnit(), true);
            this.checkType(gotCol, stdCol);
        }

        private void checkType(ColumnMeta gotCol, ObsCol stdCol) {
            String cname = gotCol.getName();
            Type stdType = stdCol.type_;
            String gotType = gotCol.getDataType();
            if (!stdType.isEqual(gotType)) {
                if (stdType.isCompatible(gotType)) {
                    String msg = new StringBuffer().append("Imperfect datatype match for ObsCore column ").append(cname).append(": ").append(gotType).append(" != ").append((Object)stdType).toString();
                    this.reporter_.report(FixedCode.W_TYPI, msg);
                } else {
                    String msg = new StringBuffer().append("Wrong datatype for ObsCore column ").append(cname).append(": ").append(gotType).append(" != ").append((Object)stdType).toString();
                    this.reporter_.report(FixedCode.E_TYPX, msg);
                }
            }
        }

        private void checkContent(ColumnMeta gotCol, ObsCol stdCol) {
            String cname = gotCol.getName();
            if (stdCol.nullForbidden_) {
                this.checkNoNulls(cname);
            }
            if (stdCol.range_ != null) {
                this.checkRange(cname, stdCol.range_);
            }
            if (stdCol.hardOptions_ != null) {
                this.checkStringOptions(cname, stdCol.hardOptions_, !stdCol.nullForbidden_, true);
            } else if (stdCol.softOptions_ != null) {
                this.checkStringOptions(cname, stdCol.softOptions_, !stdCol.nullForbidden_, false);
            }
        }

        private void checkNoNulls(String cname) {
            String adql = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(ObsTapStage.OBSCORE_TNAME).append(" WHERE ").append(cname).append(" IS NULL").toString();
            TableData result = this.runQuery(adql);
            if (result != null && result.getRowCount() > 0) {
                String msg = new StringBuffer().append("Illegal NULL(s) in ObsCore column ").append(cname).toString();
                this.reporter_.report(FixedCode.E_HNUL, msg);
            }
        }

        private void checkRange(String cname, Comparable[] range) {
            String adql = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(ObsTapStage.OBSCORE_TNAME).append(" WHERE ").append(cname).append(" NOT BETWEEN ").append(range[0]).append(" AND ").append(range[1]).toString();
            TableData result = this.runQuery(adql);
            if (result != null && result.getRowCount() > 0) {
                String msg = new StringBuffer().append("Value(s) out of range in ObsCore column ").append(cname).append(": ").append(result.getCell(0, 0)).append(" not in [").append(range[0]).append(",").append(range[1]).append("]").toString();
                this.reporter_.report(FixedCode.E_RANG, msg);
            }
        }

        private void checkStringOptions(String cname, String[] opts, boolean nullPermitted, boolean hard) {
            TableData result;
            int maxWrong = 4;
            StringBuffer abuf = new StringBuffer().append("SELECT ").append("DISTINCT TOP ").append(maxWrong).append(" ").append(cname).append(" FROM ").append(ObsTapStage.OBSCORE_TNAME).append(" WHERE ").append(cname).append(" NOT IN (");
            for (int io = 0; io < opts.length; ++io) {
                if (io > 0) {
                    abuf.append(", ");
                }
                abuf.append("'").append(opts[io]).append("'");
            }
            abuf.append(")");
            if (nullPermitted) {
                abuf.append(" AND ").append(cname).append(" IS NOT NULL");
            }
            if ((result = this.runQuery(abuf.toString())) == null) {
                return;
            }
            long nwrong = result.getRowCount();
            if (nwrong > 0L) {
                StringBuffer mbuf = new StringBuffer().append(hard ? "Illegal" : "Non-standard").append(" ").append(nwrong == 1L ? "value" : "values").append(" in column ").append(cname).append(": ");
                int irow = 0;
                while ((long)irow < nwrong) {
                    if (irow > 0) {
                        mbuf.append(", ");
                    }
                    mbuf.append('\"').append(result.getCell(irow, 0)).append('\"');
                    ++irow;
                }
                if (nwrong >= (long)maxWrong) {
                    mbuf.append(", ...");
                }
                mbuf.append("; ").append(hard ? "legal" : "standard").append(" values are: ");
                for (int io = 0; io < opts.length; ++io) {
                    if (io > 0) {
                        mbuf.append(", ");
                    }
                    mbuf.append('\"').append(opts[io]).append('\"');
                }
                this.reporter_.report(hard ? FixedCode.E_ILOP : FixedCode.W_NSOP, mbuf.toString());
            }
        }

        private void compareItem(String colName, String itemName, ReportCode code, String obsValue, String gotValue, boolean isCaseSensitive) {
            String vGot = String.valueOf(gotValue);
            String vObs = String.valueOf(obsValue);
            if (isCaseSensitive ? !vGot.equals(vObs) : !vGot.equalsIgnoreCase(vObs)) {
                String msg = new StringBuffer().append("Wrong ").append(itemName).append(" in ObsCore column ").append(colName).append(": ").append(gotValue).append(" != ").append(obsValue).toString();
                this.reporter_.report(code, msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TableData runQuery(String adql) {
            TapQuery tq = new TapQuery(this.endpointSet_, adql, null);
            StarTable table = this.tRunner_.getResultTable(this.reporter_, tq);
            if (table == null) {
                return null;
            }
            final ArrayList<Object[]> rowList = new ArrayList<Object[]>();
            try {
                RowSequence rseq = table.getRowSequence();
                try {
                    while (rseq.next()) {
                        rowList.add(rseq.getRow());
                    }
                }
                finally {
                    rseq.close();
                }
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.F_TIOF, "Error reading result table", e);
                return null;
            }
            return new TableData(){

                @Override
                public int getRowCount() {
                    return rowList.size();
                }

                @Override
                public Object getCell(int irow, int icol) {
                    return ((Object[])rowList.get(irow))[icol];
                }
            };
        }
    }
}

