/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.ColumnMetadataStage;
import uk.ac.starlink.ttools.taplint.CompareMetadataStage;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.VotLintTapRunner;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOStarTable;

public class QueryStage
implements Stage {
    private final VotLintTapRunner tapRunner_;
    private final MetadataHolder metaHolder_;
    private final CapabilityHolder capHolder_;

    public QueryStage(VotLintTapRunner tapRunner, MetadataHolder metaHolder, CapabilityHolder capHolder) {
        this.tapRunner_ = tapRunner;
        this.metaHolder_ = metaHolder;
        this.capHolder_ = capHolder;
    }

    @Override
    public String getDescription() {
        return "Make ADQL queries in " + this.tapRunner_.getDescription() + " mode";
    }

    @Override
    public void run(Reporter reporter, EndpointSet endpointSet) {
        String[] adqlLangs;
        SchemaMeta[] smetas = this.metaHolder_.getTableMetadata();
        String[] stringArray = adqlLangs = this.capHolder_ == null ? null : QueryStage.getAdqlLanguages(this.capHolder_);
        if (smetas == null || smetas.length == 0) {
            reporter.report(FixedCode.F_NOTM, "No table metadata available (earlier stages failed/skipped?) - will not run test queries");
            return;
        }
        ArrayList<TableMeta> allTables = new ArrayList<TableMeta>();
        ArrayList<TableMeta> dataTables = new ArrayList<TableMeta>();
        for (SchemaMeta smeta : smetas) {
            for (TableMeta tmeta : smeta.getTables()) {
                boolean isTapSchema;
                allTables.add(tmeta);
                String tname = tmeta.getName();
                boolean bl = isTapSchema = tname != null && tname.toUpperCase().startsWith("TAP_SCHEMA.");
                if (isTapSchema) continue;
                dataTables.add(tmeta);
            }
        }
        if (allTables.size() == 0) {
            reporter.report(FixedCode.F_NOTM, "No table metadata available (earlier stages failed/skipped?) - will not run test queries");
            return;
        }
        TableMeta[] tmetas = (dataTables.size() > 0 ? dataTables : allTables).toArray(new TableMeta[0]);
        new Querier(reporter, endpointSet, tmetas, adqlLangs).run();
        this.runDuffQuery(reporter, endpointSet);
        this.tapRunner_.reportSummary(reporter);
    }

    private static String[] getAdqlLanguages(CapabilityHolder capHolder) {
        TapCapability tcap = capHolder.getCapability();
        if (tcap == null) {
            return new String[]{"ADQL", "ADQL-2.0"};
        }
        ArrayList<String> adqlLangList = new ArrayList<String>();
        TapLanguage[] languages = tcap.getLanguages();
        for (int il = 0; il < languages.length; ++il) {
            TapLanguage lang = languages[il];
            if (!"ADQL".equals(lang.getName())) continue;
            String[] versions = lang.getVersions();
            for (int iv = 0; iv < versions.length; ++iv) {
                String version = versions[iv];
                adqlLangList.add(version == null ? "ADQL" : "ADQL-" + version);
            }
        }
        if (!adqlLangList.contains("ADQL")) {
            adqlLangList.add("ADQL");
        }
        return adqlLangList.toArray(new String[0]);
    }

    private void runDuffQuery(Reporter reporter, EndpointSet endpointSet) {
        String duffAdql = "DUFF QUERY";
        reporter.report(FixedCode.I_DUFF, "Submitting duff query: " + duffAdql);
        try {
            TapQuery tq = new TapQuery(endpointSet, duffAdql, null);
            InputStream in = this.tapRunner_.readResultInputStream(reporter, tq);
            VODocument doc = this.tapRunner_.readResultDocument(reporter, in);
            VOElement resultsEl = this.tapRunner_.getResultsResourceElement(reporter, doc);
        }
        catch (SAXException e) {
            reporter.report(FixedCode.E_DFSF, "TAP result parse failed for \"" + duffAdql + "\"", e);
            return;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_DFIO, "TAP job failed for duff query", e);
            return;
        }
        VOElement statusInfo = null;
        for (Node node = resultsEl.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof VOElement)) continue;
            VOElement el = (VOElement)node;
            String name = el.getVOTagName();
            boolean isStatusInfo = "INFO".equals(name) && "QUERY_STATUS".equals(el.getAttribute("name"));
            boolean isTable = "TABLE".equals(name);
            if (isStatusInfo) {
                if (statusInfo != null) {
                    reporter.report(FixedCode.E_EST1, "Multiple INFOs with name='QUERY_STATUS'");
                }
                statusInfo = el;
            }
            if (!isTable) continue;
            reporter.report(FixedCode.W_HSTB, "Return from duff query contains TABLE");
        }
        if (statusInfo == null) {
            reporter.report(FixedCode.E_DNST, "Missing <INFO name='QUERY_STATUS'> element for duff query");
        } else {
            String status = statusInfo.getAttribute("value");
            if ("ERROR".equals(status)) {
                String err = DOMUtils.getTextContent(statusInfo);
                if (err == null || err.trim().length() == 0) {
                    reporter.report(FixedCode.W_NOMS, "<INFO name='QUERY_STATUS' value='ERROR'> element has no message content");
                }
            } else if ("OK".equals(status)) {
                reporter.report(FixedCode.W_DSUC, "Service reports OK from duff query");
            } else {
                String msg = new StringBuffer().append("QUERY_STATUS INFO has unknown value ").append(status).append(" is not OK/ERROR").toString();
                reporter.report(FixedCode.E_DQUS, msg);
            }
        }
    }

    private static class ColSpec {
        private final ColumnMeta cmeta_;
        private String talias_;
        private String rename_;

        ColSpec(ColumnMeta cmeta) {
            this.cmeta_ = cmeta;
        }

        ColumnMeta getColumnMeta() {
            return this.cmeta_;
        }

        public void setTableAlias(String talias) {
            this.talias_ = talias;
        }

        public void setRename(String rename) {
            this.rename_ = rename;
        }

        String getQueryText() {
            StringBuffer sbuf = new StringBuffer();
            if (this.talias_ != null) {
                sbuf.append(this.talias_).append(".");
            }
            sbuf.append(this.cmeta_.getName());
            if (this.rename_ != null) {
                sbuf.append(" AS ").append(this.rename_);
            }
            return sbuf.toString();
        }

        String getResultName() {
            return this.rename_ == null ? this.cmeta_.getName() : this.rename_;
        }
    }

    private class Querier
    implements Runnable {
        private final Reporter reporter_;
        private final EndpointSet endpointSet_;
        private final String[] adqlLangs_;
        private final TableMeta tmeta1_;
        private final TableMeta tmeta2_;
        private final TableMeta tmeta3_;

        Querier(Reporter reporter, EndpointSet endpointSet, TableMeta[] tmetas, String[] adqlLangs) {
            this.reporter_ = reporter;
            this.endpointSet_ = endpointSet;
            this.adqlLangs_ = adqlLangs;
            tmetas = (TableMeta[])tmetas.clone();
            Arrays.sort(tmetas, new Comparator<TableMeta>(){

                @Override
                public int compare(TableMeta tm1, TableMeta tm2) {
                    return tm1.getColumns().length - tm2.getColumns().length;
                }
            });
            int imed = tmetas.length / 2;
            this.tmeta1_ = tmetas[imed];
            this.tmeta2_ = tmetas[Math.min(imed + 1, tmetas.length - 1)];
            this.tmeta3_ = tmetas[Math.min(imed + 2, tmetas.length - 1)];
        }

        @Override
        public void run() {
            this.runOneColumn(this.tmeta1_);
            this.runSomeColumns(this.tmeta2_);
            this.runJustMeta(this.tmeta3_);
        }

        private void runOneColumn(TableMeta tmeta) {
            long nr1;
            if (!this.checkIsQueryable(tmeta)) {
                return;
            }
            int nr0 = 10;
            String tname = tmeta.getName();
            ColumnMeta cmeta1 = tmeta.getColumns()[0];
            ColSpec cspec1 = new ColSpec(cmeta1);
            String tAdql = "SELECT TOP " + 10 + " " + cspec1.getQueryText() + " FROM " + tname;
            StarTable t1 = this.runCheckedQuery(tAdql, -1, new ColSpec[]{cspec1}, 10);
            long l = nr1 = t1 != null ? t1.getRowCount() : 0L;
            assert (nr1 >= 0L);
            if (nr1 > 0L) {
                int nr2 = Math.min((int)nr1 - 1, 9);
                String mAdql = "SELECT " + cspec1.getQueryText() + " FROM " + tname;
                StarTable t2 = this.runCheckedQuery(mAdql, nr2, new ColSpec[]{cspec1}, -1);
                if (t2 != null && !QueryStage.this.tapRunner_.isOverflow(t2)) {
                    String msg = "Overflow not marked - no <INFO name='QUERY_STATUS' value='OVERFLOW'/> after TABLE";
                    this.reporter_.report(FixedCode.E_OVNO, msg);
                }
            }
            if (this.adqlLangs_ != null && this.adqlLangs_.length > 1) {
                ArrayList okLangList = new ArrayList();
                ArrayList<String> failLangList = new ArrayList<String>();
                for (int il = 0; il < this.adqlLangs_.length; ++il) {
                    String lang = this.adqlLangs_[il];
                    String vAdql = "SELECT TOP 1 " + cspec1.getQueryText() + " FROM " + tname;
                    HashMap<String, String> extraParams = new HashMap<String, String>();
                    extraParams.put("LANG", lang);
                    TapQuery tq = new TapQuery(this.endpointSet_, vAdql, extraParams);
                    StarTable result = QueryStage.this.tapRunner_.getResultTable(this.reporter_, tq);
                    (result == null ? failLangList : okLangList).add(lang);
                }
                if (!failLangList.isEmpty() && !okLangList.isEmpty()) {
                    String msg = "Some ADQL language variants fail: " + okLangList + " works, but " + failLangList + " doesn't";
                    this.reporter_.report(FixedCode.E_LVER, msg);
                }
            }
        }

        private void runSomeColumns(TableMeta tmeta) {
            if (!this.checkIsQueryable(tmeta)) {
                return;
            }
            String talias = tmeta.getName().substring(0, 1);
            if (!AdqlSyntax.getInstance().isIdentifier(talias)) {
                talias = "t";
            }
            ArrayList<ColSpec> clist = new ArrayList<ColSpec>();
            int ncol = tmeta.getColumns().length;
            int step = Math.max(1, ncol / 11);
            int ix = 0;
            for (int icol = ncol - 1; icol >= 0; icol -= step) {
                ColSpec cspec = new ColSpec(tmeta.getColumns()[icol]);
                if (ix % 2 == 1) {
                    cspec.setRename("taplint_c_" + (ix + 1));
                }
                if (ix % 3 == 2) {
                    cspec.setTableAlias(talias);
                }
                clist.add(cspec);
                ++ix;
            }
            ColSpec[] cspecs = clist.toArray(new ColSpec[0]);
            int nr = 8;
            StringBuffer abuf = new StringBuffer();
            abuf.append("SELECT ").append("TOP ").append(nr).append(" ");
            Iterator colIt = clist.iterator();
            while (colIt.hasNext()) {
                ColSpec col = (ColSpec)colIt.next();
                abuf.append(col.getQueryText());
                if (colIt.hasNext()) {
                    abuf.append(",");
                }
                abuf.append(" ");
            }
            abuf.append(" FROM ").append(tmeta.getName()).append(" AS ").append(talias);
            String adql = abuf.toString();
            this.runCheckedQuery(adql, -1, cspecs, nr);
        }

        private void runJustMeta(TableMeta tmeta) {
            if (!this.checkIsQueryable(tmeta)) {
                return;
            }
            ColSpec cspec = new ColSpec(tmeta.getColumns()[0]);
            String adql = new StringBuffer().append("SELECT ").append(cspec.getQueryText()).append(" FROM ").append(tmeta.getName()).toString();
            this.runCheckedQuery(adql, 0, new ColSpec[]{cspec}, -1);
        }

        private StarTable runCheckedQuery(String adql, int maxrec, ColSpec[] colSpecs, int maxrow) {
            HashMap<String, String> extraParams = new HashMap<String, String>();
            if (maxrec >= 0) {
                extraParams.put("MAXREC", Integer.toString(maxrec));
            }
            TapQuery tq = new TapQuery(this.endpointSet_, adql, extraParams);
            StarTable table = QueryStage.this.tapRunner_.getResultTable(this.reporter_, tq);
            if (table != null) {
                String msg;
                int nrow = (int)table.getRowCount();
                if (maxrec >= 0 && nrow > maxrec) {
                    msg = new StringBuffer().append("More than MAXREC rows returned (").append(nrow).append(" > ").append(maxrec).append(")").append(" for ").append(adql).toString();
                    this.reporter_.report(FixedCode.E_NREC, msg);
                }
                if (maxrow >= 0 && nrow > maxrow) {
                    msg = new StringBuffer().append("More rows than expected (").append(nrow).append(") returned").append(" for ").append(adql).toString();
                    this.reporter_.report(FixedCode.E_NROW, msg);
                }
                this.checkMeta(adql, colSpecs, table);
            }
            return table;
        }

        private boolean checkIsQueryable(TableMeta tmeta) {
            boolean hasColumns;
            boolean hasName;
            String tname = tmeta.getName();
            boolean bl = hasName = tname != null && tname.length() > 0;
            if (!hasName) {
                this.reporter_.report(FixedCode.F_TBLA, "Table has no name, impossible to phrase ADQL queries");
            }
            boolean bl2 = hasColumns = tmeta.getColumns().length > 0;
            if (!hasColumns) {
                this.reporter_.report(FixedCode.F_ZCOL, "No columns known for " + (tname == null ? "unnamed table" : tname) + ", can't make column queries");
            }
            return hasName && hasColumns;
        }

        private void checkMeta(String adql, ColSpec[] colSpecs, StarTable table) {
            int qCount = colSpecs.length;
            int rCount = table.getColumnCount();
            if (qCount != rCount) {
                String msg = new StringBuffer().append("Query/result column count mismatch; ").append(qCount).append(" != ").append(rCount).append(" for ").append(adql).toString();
                this.reporter_.report(FixedCode.E_MCOL, msg);
                return;
            }
            int ncol = qCount;
            assert (ncol == rCount);
            for (int ic = 0; ic < ncol; ++ic) {
                String rType;
                String rName;
                ColSpec cspec = colSpecs[ic];
                ColumnInfo cinfo = table.getColumnInfo(ic);
                String qName = ColumnMetadataStage.normaliseColumnName(cspec.getResultName());
                if (!qName.equals(rName = ColumnMetadataStage.normaliseColumnName(cinfo.getName()))) {
                    String msg = new StringBuffer().append("Query/result column name mismatch ").append("for column #").append(ic).append("; ").append(qName).append(" != ").append(rName).append(" for ").append(adql).toString();
                    this.reporter_.report(FixedCode.E_CNAM, msg);
                }
                String columnId = rName.equalsIgnoreCase(qName) ? qName : "#" + ic;
                String qType = cspec.getColumnMeta().getDataType();
                if (CompareMetadataStage.compatibleDataTypes(qType, rType = (String)cinfo.getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class))) continue;
                String msg = new StringBuffer().append("Query/result column type possible mismatch ").append("for column ").append(columnId).append("; ").append(qType).append(" vs. ").append(rType).append(" for ").append(adql).toString();
                this.reporter_.report(FixedCode.W_QTYP, msg);
            }
        }
    }
}

