/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;

public class ReporterErrorHandler
implements ErrorHandler {
    private final Reporter reporter_;
    private int warningCount_;
    private int errorCount_;
    private int fatalCount_;

    public ReporterErrorHandler(Reporter reporter) {
        this.reporter_ = reporter;
    }

    public int getFatalCount() {
        return this.fatalCount_;
    }

    public String getSummary() {
        return new StringBuffer().append("SAX report: ").append("warnings ").append(this.warningCount_).append(", ").append("errors ").append(this.errorCount_).append(", ").append("fatal ").append(this.fatalCount_).toString();
    }

    @Override
    public void warning(SAXParseException err) {
        ++this.warningCount_;
        this.reportException(ReportType.WARNING, err);
    }

    @Override
    public void error(SAXParseException err) {
        ++this.errorCount_;
        this.reportException(ReportType.ERROR, err);
    }

    @Override
    public void fatalError(SAXParseException err) {
        ++this.fatalCount_;
        this.reportException(ReportType.ERROR, err);
    }

    private void reportException(ReportType type, SAXParseException err) {
        String msg = err.getMessage();
        if (msg == null) {
            msg = err.toString();
        }
        AdhocCode code = AdhocCode.createCodeFromText(type, msg);
        StringBuffer sbuf = new StringBuffer();
        int il = err.getLineNumber();
        int ic = err.getColumnNumber();
        if (il > 0) {
            sbuf.append(" (l.").append(il);
            if (ic > 0) {
                sbuf.append(", c.").append(ic);
            }
            sbuf.append(")");
        }
        sbuf.append(": ").append(msg);
        this.reporter_.report(code, sbuf.toString());
    }
}

