/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import org.xml.sax.Locator;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.votable.VOTableVersion;

public class ReporterVotLintContext
extends VotLintContext {
    private final Reporter reporter_;

    public ReporterVotLintContext(VOTableVersion version, Reporter reporter) {
        super(version, true, false, null);
        this.reporter_ = reporter;
    }

    @Override
    public void info(String msg) {
        this.report(ReportType.INFO, msg);
    }

    @Override
    public void warning(String msg) {
        this.report(ReportType.WARNING, msg);
    }

    @Override
    public void error(String msg) {
        this.report(ReportType.ERROR, msg);
    }

    private void report(ReportType type, String msg) {
        String label = "VO" + AdhocCode.createLabelChars((Object)((Object)type) + ": " + msg, 2);
        AdhocCode code = new AdhocCode(type, label);
        int il = -1;
        int ic = -1;
        Locator locator = this.getLocator();
        if (locator != null) {
            ic = locator.getColumnNumber();
            il = locator.getLineNumber();
        }
        StringBuffer sbuf = new StringBuffer();
        if (il > 0) {
            sbuf.append(" (l.").append(il);
            if (ic > 0) {
                sbuf.append(", c.").append(ic);
            }
            sbuf.append(")");
        }
        sbuf.append(": ").append(msg);
        this.reporter_.report(code, sbuf.toString());
    }
}

