/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.TableMetadataStage;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;

public class TablesEndpointStage
extends TableMetadataStage {
    private final ContentCoding coding_ = ContentCoding.NONE;

    public TablesEndpointStage() {
        super("/tables", new String[]{"indexed", "primary", "nullable"}, true);
    }

    @Override
    protected SchemaMeta[] readTableMetadata(Reporter reporter, EndpointSet endpointSet) {
        TableSetSaxHandler populatedHandler;
        SAXParser parser;
        BufferedInputStream in;
        URLConnection conn;
        URL turl = endpointSet.getTablesEndpoint();
        reporter.report(FixedCode.I_TURL, "Reading table metadata from " + turl);
        try {
            conn = turl.openConnection();
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FLIO, "Can't open tables endpoint", e);
            return null;
        }
        this.coding_.prepareRequest(conn);
        if (conn instanceof HttpURLConnection) {
            int code;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(true);
            try {
                code = hconn.getResponseCode();
            }
            catch (IOException e) {
                reporter.report(FixedCode.E_FLIO, "Can't open tables endpoint", e);
                return null;
            }
            if (code == 404) {
                String msg = new StringBuffer().append("/tables resource, recommended but not required,").append(" is absent - ").append(code).append(" at ").append(turl).toString();
                reporter.report(FixedCode.W_TBNF, msg);
                return null;
            }
            if (code != 200) {
                String msg = new StringBuffer().append("HTTP response ").append(code).append(" from /tables endpoint").append(" - should be 200 or 404").toString();
                reporter.report(FixedCode.E_FLIO, msg);
                return null;
            }
        }
        try {
            in = new BufferedInputStream(this.coding_.getInputStream(conn));
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FLIO, "Error reading from /tables endpoint", e);
            return null;
        }
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setNamespaceAware(false);
            spfact.setValidating(false);
            parser = spfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            reporter.report(FixedCode.F_CAPC, "Trouble setting up XML parse", e);
            return null;
        }
        catch (SAXException e) {
            reporter.report(FixedCode.F_CAPC, "Trouble setting up XML parse", e);
            return null;
        }
        try {
            TableSetSaxHandler handler = new TableSetSaxHandler();
            parser.parse((InputStream)in, (DefaultHandler)handler);
            populatedHandler = handler;
        }
        catch (SAXException e) {
            reporter.report(FixedCode.E_FLSX, "Can't parse table metadata well enough to check it", e);
            return null;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FLIO, "Error reading table metadata", e);
            return null;
        }
        ArrayList<SchemaMeta> schemaList = new ArrayList<SchemaMeta>();
        schemaList.addAll(Arrays.asList(populatedHandler.getSchemas(false)));
        TableMeta[] nakedTables = populatedHandler.getNakedTables();
        int nNaked = nakedTables.length;
        if (nNaked > 0) {
            String msg = new StringBuffer().append(nNaked).append(" tables declared outside of any schema ").toString();
            reporter.report(FixedCode.E_NAKT, msg);
            SchemaMeta dummySchema = SchemaMeta.createDummySchema((String)"<no_schema>");
            dummySchema.setTables(nakedTables);
            schemaList.add(dummySchema);
        }
        return schemaList.toArray(new SchemaMeta[0]);
    }
}

