/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.taplint.CapabilityStage;
import uk.ac.starlink.ttools.taplint.ColumnMetadataStage;
import uk.ac.starlink.ttools.taplint.CompareMetadataStage;
import uk.ac.starlink.ttools.taplint.ExampleStage;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.IvoaSchemaResolver;
import uk.ac.starlink.ttools.taplint.JobStage;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ObsTapStage;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.QueryStage;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TablesEndpointStage;
import uk.ac.starlink.ttools.taplint.TapSchemaMetadataHolder;
import uk.ac.starlink.ttools.taplint.TapSchemaStage;
import uk.ac.starlink.ttools.taplint.UploadStage;
import uk.ac.starlink.ttools.taplint.VotLintTapRunner;
import uk.ac.starlink.ttools.taplint.XsdStage;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.SchemaMeta;

public class TapLinter {
    private final StageSet stageSet_;
    private final XsdStage tmetaXsdStage_ = new XsdStage(IvoaSchemaResolver.VODATASERVICE_URI, "tableset", false, "table metadata"){

        @Override
        public URL getDocumentUrl(EndpointSet endpointSet) {
            return endpointSet.getTablesEndpoint();
        }
    };
    private final TablesEndpointStage tmetaStage_ = new TablesEndpointStage();
    private final TapSchemaStage tapSchemaStage_ = new TapSchemaStage(VotLintTapRunner.createGetSyncRunner(true));
    private final CompareMetadataStage cfTmetaStage_;
    private final XsdStage tcapXsdStage_;
    private final CapabilityStage tcapStage_;
    private final XsdStage availXsdStage_;
    private final QueryStage getQueryStage_;
    private final QueryStage postQueryStage_;
    private final QueryStage asyncQueryStage_;
    private final JobStage jobStage_;
    private final ColumnMetadataStage colMetaStage_;
    private final UploadStage uploadStage_;
    private final ObsTapStage obstapStage_;
    private final ExampleStage exampleStage_;
    private final TapSchemaMetadataHolder tapSchemaMetadata_ = new TapSchemaMetadataHolder();
    public static final String MDQ_NAME = "MDQ";

    public TapLinter() {
        AnyMetadataHolder metaHolder = new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_, this.tapSchemaMetadata_});
        AnyMetadataHolder declaredMetaHolder = new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_});
        this.cfTmetaStage_ = CompareMetadataStage.createStage(this.tmetaStage_, this.tapSchemaStage_);
        this.tcapXsdStage_ = new XsdStage(IvoaSchemaResolver.CAPABILITIES_URI, "capabilities", true, "capabilities"){

            @Override
            public URL getDocumentUrl(EndpointSet endpointSet) {
                return endpointSet.getCapabilitiesEndpoint();
            }
        };
        this.tcapStage_ = new CapabilityStage();
        this.availXsdStage_ = new XsdStage(IvoaSchemaResolver.AVAILABILITY_URI, "availability", false, "availability"){

            @Override
            public URL getDocumentUrl(EndpointSet endpointSet) {
                return endpointSet.getAvailabilityEndpoint();
            }
        };
        this.getQueryStage_ = new QueryStage(VotLintTapRunner.createGetSyncRunner(true), metaHolder, this.tcapStage_);
        this.postQueryStage_ = new QueryStage(VotLintTapRunner.createPostSyncRunner(true), metaHolder, null);
        this.asyncQueryStage_ = new QueryStage(VotLintTapRunner.createAsyncRunner(500L, true), metaHolder, null);
        this.jobStage_ = new JobStage(metaHolder, 500L);
        this.colMetaStage_ = new ColumnMetadataStage(VotLintTapRunner.createGetSyncRunner(false), declaredMetaHolder, -1);
        this.uploadStage_ = new UploadStage(VotLintTapRunner.createAsyncRunner(500L, true), this.tcapStage_);
        this.obstapStage_ = new ObsTapStage(VotLintTapRunner.createGetSyncRunner(true), this.tcapStage_, new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_}));
        this.exampleStage_ = new ExampleStage(VotLintTapRunner.createGetSyncRunner(true), this.tcapStage_, new AnyMetadataHolder(new MetadataHolder[]{this.tapSchemaStage_, this.tmetaStage_}));
        this.stageSet_ = new StageSet();
        this.stageSet_.add("TMV", this.tmetaXsdStage_, true);
        this.stageSet_.add("TME", this.tmetaStage_, true);
        this.stageSet_.add("TMS", this.tapSchemaStage_, true);
        this.stageSet_.add("TMC", this.cfTmetaStage_, true);
        this.stageSet_.add("CPV", this.tcapXsdStage_, true);
        this.stageSet_.add("CAP", this.tcapStage_, true);
        this.stageSet_.add("AVV", this.availXsdStage_, true);
        this.stageSet_.add("QGE", this.getQueryStage_, true);
        this.stageSet_.add("QPO", this.postQueryStage_, true);
        this.stageSet_.add("QAS", this.asyncQueryStage_, true);
        this.stageSet_.add("UWS", this.jobStage_, true);
        this.stageSet_.add(MDQ_NAME, this.colMetaStage_, true);
        this.stageSet_.add("OBS", this.obstapStage_, true);
        this.stageSet_.add("UPL", this.uploadStage_, true);
        this.stageSet_.add("EXA", this.exampleStage_, true);
    }

    public Map<String, Stage> getKnownStages() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, Stage>(this.stageSet_.stageMap_));
    }

    public boolean isDefault(String code) {
        return this.stageSet_.dflts_.contains(code);
    }

    public Executable createExecutable(final OutputReporter reporter, final EndpointSet endpointSet, Set<String> stageCodeSet, int maxTestTables) throws TaskException {
        ArrayList<String> selectedCodeList = new ArrayList<String>();
        for (String knownCode : this.stageSet_.stageMap_.keySet()) {
            boolean selected = false;
            Iterator<String> sit = stageCodeSet.iterator();
            while (!selected && sit.hasNext()) {
                if (!knownCode.equalsIgnoreCase(sit.next())) continue;
                sit.remove();
                selected = true;
            }
            if (!selected) continue;
            selectedCodeList.add(knownCode);
        }
        if (!stageCodeSet.isEmpty()) {
            throw new TaskException("Unknown stage codes " + stageCodeSet);
        }
        final String[] codes = selectedCodeList.toArray(new String[0]);
        this.tapSchemaMetadata_.setReporter(reporter);
        this.colMetaStage_.setMaxTestTables(maxTestTables);
        final String[] announcements = TapLinter.getAnnouncements();
        return new Executable(){

            public void execute() {
                reporter.start(announcements);
                for (int ic = 0; ic < codes.length; ++ic) {
                    String code = codes[ic];
                    Stage stage = TapLinter.this.stageSet_.getStage(code);
                    assert (stage != null);
                    reporter.startSection(code, stage.getDescription());
                    stage.run(reporter, endpointSet);
                    reporter.summariseUnreportedMessages(code);
                    reporter.endSection();
                }
                reporter.end();
            }
        };
    }

    private static String[] getAnnouncements() {
        String versionLine = new StringBuffer().append("This is STILTS taplint, ").append(Stilts.getVersion()).append("/").append(Stilts.getStarjavaRevision()).toString();
        LinkedHashMap<ReportType, int[]> codeMap = new LinkedHashMap<ReportType, int[]>();
        for (ReportType reportType : ReportType.values()) {
            codeMap.put(reportType, new int[1]);
        }
        for (Enum enum_ : FixedCode.values()) {
            int[] nArray = (int[])codeMap.get((Object)((FixedCode)enum_).getType());
            nArray[0] = nArray[0] + 1;
        }
        StringBuffer cbuf = new StringBuffer().append("Static report types: ");
        for (Map.Entry entry : codeMap.entrySet()) {
            cbuf.append(entry.getKey()).append("(").append(((int[])entry.getValue())[0]).append(")").append(", ");
        }
        cbuf.setLength(cbuf.length() - 2);
        String codesLine = cbuf.toString();
        return new String[]{versionLine, codesLine};
    }

    private static class StageSet {
        Map<String, Stage> stageMap_ = new LinkedHashMap<String, Stage>();
        Set<String> dflts_ = new HashSet<String>();

        StageSet() {
        }

        void add(String code, Stage stage, boolean dflt) {
            this.stageMap_.put(code, stage);
            if (dflt) {
                this.dflts_.add(code);
            }
        }

        Stage getStage(String code) {
            return this.stageMap_.get(code);
        }
    }

    private static class AnyMetadataHolder
    implements MetadataHolder {
        private final MetadataHolder[] holders_;

        AnyMetadataHolder(MetadataHolder[] holders) {
            this.holders_ = holders;
        }

        @Override
        public SchemaMeta[] getTableMetadata() {
            for (int ih = 0; ih < this.holders_.length; ++ih) {
                SchemaMeta[] smetas = this.holders_[ih].getTableMetadata();
                if (smetas == null || smetas.length <= 0) continue;
                return smetas;
            }
            return null;
        }
    }
}

