/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.net.URL;
import org.xml.sax.SAXException;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableSetSaxHandler;

public class TapSchemaMetadataHolder
implements MetadataHolder {
    private Reporter reporter_;
    private SchemaMeta[] metadata_;

    public void setReporter(Reporter reporter) {
        this.reporter_ = reporter;
    }

    @Override
    public SchemaMeta[] getTableMetadata() {
        if (this.metadata_ == null) {
            this.metadata_ = this.readSchemaMetadata();
        }
        return this.metadata_;
    }

    private SchemaMeta[] readSchemaMetadata() {
        URL schemaTablesUrl = TapSchemaMetadataHolder.class.getResource("TAP_SCHEMA_tables.xml");
        if (schemaTablesUrl == null) {
            return null;
        }
        try {
            SchemaMeta[] smetas = TableSetSaxHandler.readTableSet((URL)schemaTablesUrl, (ContentCoding)ContentCoding.NONE);
            if (this.reporter_ != null) {
                this.reporter_.report(FixedCode.I_SCHM, "Using standard TAP_SCHEMA tables for metadata");
            }
            return smetas;
        }
        catch (IOException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }
}

