/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.TableMetadataStage;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapSchemaInterrogator;
import uk.ac.starlink.votable.VOStarTable;

public class TapSchemaStage
extends TableMetadataStage {
    private final TapRunner tapRunner_;

    public TapSchemaStage(TapRunner tapRunner) {
        super("TAP_SCHEMA", new String[]{"indexed", "principal", "std"}, false);
        this.tapRunner_ = tapRunner;
    }

    @Override
    public void run(Reporter reporter, EndpointSet endpointSet) {
        super.run(reporter, endpointSet);
        this.tapRunner_.reportSummary(reporter);
    }

    @Override
    protected SchemaMeta[] readTableMetadata(Reporter reporter, EndpointSet endpointSet) {
        List sList;
        HashMap tMap;
        HashMap fMap;
        HashMap lMap;
        HashMap cMap;
        int maxrec = this.getMetaMaxrec(reporter, endpointSet, this.tapRunner_) + 10;
        LintTapSchemaInterrogator tsi = new LintTapSchemaInterrogator(reporter, endpointSet, maxrec, this.tapRunner_);
        try {
            tsi.checkColumnTypes();
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_CERR, "Error reading TAP_SCHEMA.columns data", e);
        }
        try {
            cMap = tsi.readMap(TapSchemaInterrogator.COLUMN_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_CLIO, "Error reading TAP_SCHEMA.columns table", e);
            cMap = new HashMap();
        }
        try {
            lMap = tsi.readMap(TapSchemaInterrogator.LINK_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_KCIO, "Error reading TAP_SCHEMA.key_columns table", e);
            lMap = new HashMap();
        }
        try {
            fMap = tsi.readMap(TapSchemaInterrogator.FKEY_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FKIO, "Error reading TAP_SCHEMA.keys table", e);
            fMap = new HashMap();
        }
        try {
            tMap = tsi.readMap(TapSchemaInterrogator.TABLE_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_TBIO, "Error reading TAP_SCHEMA.tables table", e);
            tMap = new HashMap();
        }
        try {
            sList = tsi.readList(TapSchemaInterrogator.SCHEMA_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_SCIO, "Error reading TAP_SCHEMA.schemas table", e);
            sList = null;
        }
        ForeignMeta.Link[] l0 = new ForeignMeta.Link[]{};
        for (List flist : fMap.values()) {
            for (ForeignMeta fmeta : flist) {
                tsi.populateForeignKey(fmeta, lMap);
            }
        }
        this.checkEmpty(reporter, lMap, FixedCode.W_FLUN, "key_columns");
        ForeignMeta[] f0 = new ForeignMeta[]{};
        for (List tlist : tMap.values()) {
            for (TableMeta tmeta : tlist) {
                tsi.populateTable(tmeta, fMap, cMap);
            }
        }
        this.checkEmpty(reporter, fMap, FixedCode.W_FKUN, "keys");
        this.checkEmpty(reporter, cMap, FixedCode.W_CLUN, "columns");
        if (sList != null) {
            for (SchemaMeta smeta : sList) {
                tsi.populateSchema(smeta, tMap);
            }
            this.checkEmpty(reporter, tMap, FixedCode.W_TBUN, "tables");
        }
        return sList == null ? null : sList.toArray(new SchemaMeta[0]);
    }

    private int getMetaMaxrec(Reporter reporter, EndpointSet endpointSet, TapRunner tapRunner) {
        String[] tnames = new String[]{"TAP_SCHEMA.schemas", "TAP_SCHEMA.tables", "TAP_SCHEMA.columns", "TAP_SCHEMA.keys", "TAP_SCHEMA.key_columns"};
        int maxrec = 0;
        for (String tname : tnames) {
            int nr = Math.max(maxrec, this.getRowCount(reporter, endpointSet, tapRunner, tname));
            if (nr < 0) {
                return 0;
            }
            maxrec = Math.max(maxrec, nr);
        }
        return maxrec;
    }

    private int getRowCount(Reporter reporter, EndpointSet endpointSet, TapRunner tapRunner, String tname) {
        String adql = "SELECT COUNT(*) AS nr FROM " + tname;
        TapQuery tq = new TapQuery(endpointSet, adql, null);
        StarTable result = tapRunner.getResultTable(reporter, tq);
        if (result != null) {
            try {
                result = Tables.randomTable((StarTable)result);
                if (result.getColumnCount() == 1 && result.getRowCount() == 1L) {
                    Object cell = result.getCell(0L, 0);
                    if (cell instanceof Number) {
                        return ((Number)cell).intValue();
                    }
                    reporter.report(FixedCode.E_NONM, "Non-numeric return cell from " + adql);
                    return -1;
                }
                reporter.report(FixedCode.E_NO11, "Expecting nrow=1, ncol=1, got nrow=" + result.getRowCount() + " ncol=" + result.getColumnCount() + " from " + adql);
                return -1;
            }
            catch (IOException e) {
                reporter.report(FixedCode.E_NRER, "Error counting rows with " + adql, e);
                return -1;
            }
        }
        return -1;
    }

    private void checkEmpty(Reporter reporter, Map<?, ?> map, ReportCode code, String stName) {
        for (Object key : map.keySet()) {
            reporter.report(code, "Unused entry in TAP_SCHEMA." + stName + " table: " + key);
        }
    }

    private static class LintTapSchemaInterrogator
    extends TapSchemaInterrogator {
        private final Reporter reporter_;
        private final TapRunner tapRunner_;
        private static Integer BOOL_TRUE = new Integer(1);
        private static Integer BOOL_FALSE = new Integer(0);

        public LintTapSchemaInterrogator(Reporter reporter, EndpointSet endpointSet, int maxrec, TapRunner tapRunner) {
            super(endpointSet, maxrec, ContentCoding.NONE);
            this.reporter_ = reporter;
            this.tapRunner_ = tapRunner;
        }

        protected StarTable executeQuery(TapQuery tq) throws IOException {
            try {
                return this.tapRunner_.attemptGetResultTable(this.reporter_, tq);
            }
            catch (SAXException e) {
                throw (IOException)new IOException("Result parse error: " + e.getMessage()).initCause(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkColumnTypes() throws IOException {
            String[] colNames = new String[]{"principal", "indexed", "std", "size"};
            String[] colTypes = new String[]{"int", "int", "int", "int"};
            boolean[] colBools = new boolean[]{true, true, true, false};
            String adql = "SELECT principal, indexed, std, \"size\" FROM TAP_SCHEMA.columns";
            StarTable table = this.executeQuery(this.createTapQuery(adql));
            int ncol = Math.min(colNames.length, table.getColumnCount());
            for (int ic = 0; ic < ncol; ++ic) {
                ColumnInfo cinfo = table.getColumnInfo(ic);
                String type = (String)cinfo.getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class);
                if (colTypes[ic].equals(type)) continue;
                String msg = new StringBuffer().append("Column ").append(colNames[ic]).append(" in ").append("TAP_SCHEMA.columns").append(" has wrong type ").append(type).append(" not ").append(colTypes[ic]).toString();
                this.reporter_.report(FixedCode.E_CINT, msg);
                colBools[ic] = false;
            }
            RowSequence rseq = table.getRowSequence();
            try {
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    for (int ic = 0; ic < ncol; ++ic) {
                        Object cell;
                        if (!colBools[ic] || BOOL_TRUE.equals(cell = row[ic]) || BOOL_FALSE.equals(cell)) continue;
                        String msg = new StringBuffer().append("Non-boolean value ").append(cell).append(" in TAP_SCHEMA.columns column ").append(colNames[ic]).toString();
                        this.reporter_.report(FixedCode.E_CLOG, msg);
                    }
                }
            }
            finally {
                rseq.close();
            }
        }
    }
}

