/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.ReporterErrorHandler;
import uk.ac.starlink.ttools.taplint.ReporterVotLintContext;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.ttools.votlint.VersionDetector;
import uk.ac.starlink.ttools.votlint.VotLintContentHandler;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.ttools.votlint.VotLintEntityResolver;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.MultiplexInvocationHandler;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableDOMBuilder;
import uk.ac.starlink.votable.VOTableVersion;

public abstract class VotLintTapRunner
extends TapRunner {
    private final boolean doChecks_;
    public static ValueInfo OVERFLOW_INFO = new DefaultValueInfo("OVERFLOW", Boolean.class, "Is TAP result overflow status set?");
    private static final VOTableVersion TAP_VOT_VERSION = VOTableVersion.V12;

    protected VotLintTapRunner(String name, boolean doChecks) {
        super(name);
        this.doChecks_ = doChecks;
    }

    public boolean isOverflow(StarTable table) {
        DescribedValue ovParam = table.getParameterByName(OVERFLOW_INFO.getName());
        if (ovParam != null && ovParam.getValue() instanceof Boolean) {
            return (Boolean)ovParam.getValue();
        }
        throw new IllegalArgumentException("Not produced by me!");
    }

    protected abstract URLConnection getResultConnection(Reporter var1, TapQuery var2) throws IOException;

    @Override
    protected StarTable executeQuery(Reporter reporter, TapQuery tq) throws IOException, SAXException {
        InputStream in = this.readResultInputStream(reporter, tq);
        VODocument doc = this.readResultDocument(reporter, in);
        return this.readResultVOTable(reporter, doc);
    }

    public InputStream readResultInputStream(Reporter reporter, TapQuery tq) throws IOException, SAXException {
        Compression compression;
        String cCoding;
        URLConnection conn = this.getResultConnection(reporter, tq);
        conn = TapQuery.followRedirects((URLConnection)conn);
        conn.connect();
        String ctype = conn.getContentType();
        if (this.doChecks_) {
            if (ctype == null || ctype.trim().length() == 0) {
                reporter.report(FixedCode.W_NOCT, "No Content-Type header for " + conn.getURL());
            } else if (!(ctype.startsWith("text/xml") || ctype.startsWith("application/xml") || ctype.startsWith("application/x-votable+xml") || ctype.startsWith("text/x-votable+xml"))) {
                String msg = "Bad content type " + ctype + " for HTTP response which should contain " + "VOTable result or error document" + " (" + conn.getURL() + ")";
                reporter.report(FixedCode.E_VOCT, msg);
            }
        }
        if ((cCoding = conn.getContentEncoding()) == null || cCoding.trim().length() == 0 || "identity".equals(cCoding)) {
            compression = Compression.NONE;
        } else if ("gzip".equals(cCoding) || "x-gzip".equals(cCoding)) {
            compression = Compression.GZIP;
        } else if ("compress".equals(cCoding) || "x-compress".equals(cCoding)) {
            compression = Compression.COMPRESS;
        } else {
            reporter.report(FixedCode.W_CEUK, "Unknown Content-Encoding " + cCoding + " for " + conn.getURL());
            compression = Compression.NONE;
        }
        if (this.doChecks_ && compression != Compression.NONE) {
            reporter.report(FixedCode.W_CEZZ, "Compression with Content-Encoding " + cCoding + " for " + conn.getURL());
        }
        try {
            return compression.decompress(conn.getInputStream());
        }
        catch (IOException e) {
            InputStream err;
            if (conn instanceof HttpURLConnection && (err = ((HttpURLConnection)conn).getErrorStream()) != null) {
                return err;
            }
            throw e;
        }
    }

    public VODocument readResultDocument(Reporter reporter, InputStream baseIn) throws IOException, SAXException {
        XMLReader parser;
        VOTableVersion version;
        BufferedInputStream in = new BufferedInputStream(baseIn);
        String versionString = VersionDetector.getVersionString(in);
        if (versionString == null) {
            version = TAP_VOT_VERSION;
            reporter.report(FixedCode.I_VVNL, "Undeclared VOTable version; assuming v" + version);
        } else {
            Map vmap = VOTableVersion.getKnownVersions();
            if (vmap.containsKey(versionString)) {
                ArrayList vlist = new ArrayList(vmap.values());
                if (vlist.indexOf(version = (VOTableVersion)vmap.get(versionString)) < vlist.indexOf(TAP_VOT_VERSION)) {
                    reporter.report(FixedCode.E_VVLO, "Declared VOTable version " + versionString + "<" + TAP_VOT_VERSION);
                }
            } else {
                version = TAP_VOT_VERSION;
                reporter.report(FixedCode.I_VVUN, "Unknown declared VOTable version '" + versionString + "' - assuming v" + version);
            }
        }
        VOTableDOMBuilder domHandler = new VOTableDOMBuilder(StoragePolicy.getDefaultPolicy(), true);
        if (this.doChecks_) {
            ReporterVotLintContext vlContext = new ReporterVotLintContext(version, reporter);
            parser = this.createParser(reporter, vlContext);
            ContentHandler vcHandler = (ContentHandler)new MultiplexInvocationHandler((Object[])new ContentHandler[]{new VotLintContentHandler(vlContext), domHandler}).createMultiplexer(ContentHandler.class);
            parser.setErrorHandler(new ReporterErrorHandler(reporter));
            parser.setContentHandler(vcHandler);
        } else {
            parser = this.createParser(reporter);
            parser.setEntityResolver((EntityResolver)StarEntityResolver.getInstance());
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException err) {
                }

                @Override
                public void error(SAXParseException err) {
                }

                @Override
                public void fatalError(SAXParseException err) {
                }
            });
            parser.setContentHandler((ContentHandler)domHandler);
        }
        parser.parse(new InputSource(in));
        return domHandler.getDocument();
    }

    private StarTable readResultVOTable(Reporter reporter, VODocument doc) throws IOException {
        VOElement resultsEl = this.getResultsResourceElement(reporter, doc);
        VOElement preStatusInfo = null;
        VOElement postStatusInfo = null;
        TableElement tableEl = null;
        for (Node node = resultsEl.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof VOElement)) continue;
            VOElement el = (VOElement)node;
            String name = el.getVOTagName();
            boolean isStatusInfo = "INFO".equals(name) && "QUERY_STATUS".equals(el.getAttribute("name"));
            boolean isTable = "TABLE".equals(name);
            if (isStatusInfo) {
                if (tableEl == null) {
                    if (preStatusInfo == null) {
                        preStatusInfo = el;
                    } else if (this.doChecks_) {
                        reporter.report(FixedCode.E_QST1, "Multiple pre-table INFOs with name='QUERY_STATUS'");
                    }
                } else if (postStatusInfo == null) {
                    postStatusInfo = el;
                } else if (this.doChecks_) {
                    reporter.report(FixedCode.E_QST2, "Multiple post-table INFOs with name='QUERY_STATUS'");
                }
            }
            if (!isTable) continue;
            if (tableEl == null) {
                tableEl = (TableElement)el;
                continue;
            }
            reporter.report(FixedCode.E_TTOO, "Multiple TABLEs in results RESOURCE");
        }
        if (preStatusInfo == null) {
            if (this.doChecks_) {
                reporter.report(FixedCode.E_NOST, "Missing <INFO name='QUERY_STATUS'> element before TABLE");
            }
        } else {
            String preStatus = preStatusInfo.getAttribute("value");
            if ("ERROR".equals(preStatus)) {
                String err = DOMUtils.getTextContent(preStatusInfo);
                if (err == null || err.trim().length() == 0) {
                    if (this.doChecks_) {
                        reporter.report(FixedCode.W_NOMS, "<INFO name='QUERY_STATUS' value='ERROR'> element has no message content");
                    }
                    err = "Unknown TAP result error";
                }
                throw new IOException("Service error: \"" + err + "\"");
            }
            if (!"OK".equals(preStatus) && this.doChecks_) {
                String msg = new StringBuffer().append("Pre-table QUERY_STATUS INFO ").append("has unknown value ").append(preStatus).append(" is not OK/ERROR").toString();
                reporter.report(FixedCode.E_DQUS, msg);
            }
        }
        boolean overflow = false;
        if (postStatusInfo != null) {
            String postStatus = postStatusInfo.getAttribute("value");
            if ("ERROR".equals(postStatus)) {
                String err = DOMUtils.getTextContent(postStatusInfo);
                if (err == null || err.trim().length() == 0) {
                    if (this.doChecks_) {
                        reporter.report(FixedCode.W_NOMS, "<INFO name='QUERY_STATUS' value='ERROR'> element has no message content");
                    }
                    err = "Unknown TAP result error";
                }
                throw new IOException(err);
            }
            if ("OVERFLOW".equals(postStatus)) {
                overflow = true;
            } else if (this.doChecks_) {
                String msg = new StringBuffer().append("Post-table QUERY_STATUS INFO ").append("has unknown value ").append(postStatus).append(" is not ERROR/OVERFLOW").toString();
                reporter.report(FixedCode.W_DQU2, msg);
            }
        }
        if (tableEl == null) {
            throw new IOException("No TABLE element in results RESOURCE");
        }
        VOStarTable table = new VOStarTable(tableEl);
        table.setParameter(new DescribedValue(OVERFLOW_INFO, (Object)overflow));
        return table;
    }

    public VOElement getResultsResourceElement(Reporter reporter, VODocument doc) throws IOException {
        VOElement voEl = (VOElement)doc.getDocumentElement();
        if (!"VOTABLE".equals(voEl.getVOTagName())) {
            String msg = new StringBuffer().append("Top-level element of result document is ").append(voEl.getTagName()).append(" not VOTABLE").toString();
            throw new IOException(msg);
        }
        VOElement[] resourceEls = voEl.getChildrenByName("RESOURCE");
        for (int ie = 0; ie < resourceEls.length; ++ie) {
            VOElement el = resourceEls[ie];
            if (!"results".equals(el.getAttribute("type"))) continue;
            return el;
        }
        if (resourceEls.length == 1) {
            if (this.doChecks_) {
                reporter.report(FixedCode.E_RRES, "TAP response document RESOURCE element is not marked type='results'");
            }
            return resourceEls[0];
        }
        throw new IOException("No RESOURCE with type='results'");
    }

    private XMLReader createParser(Reporter reporter) throws SAXException {
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            spfact.setNamespaceAware(true);
            return spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            reporter.report(FixedCode.F_CAPC, "Trouble setting up XML parse", e);
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
    }

    private XMLReader createParser(Reporter reporter, VotLintContext vlContext) throws SAXException {
        XMLReader parser = this.createParser(reporter);
        VotLintEntityResolver entityResolver = new VotLintEntityResolver(vlContext);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", entityResolver);
            parser.setEntityResolver(entityResolver);
        }
        catch (SAXException e) {
            parser.setEntityResolver((EntityResolver)StarEntityResolver.getInstance());
            reporter.report(FixedCode.F_XENT, "Entity trouble - DTD validation may not be done properly", e);
        }
        return parser;
    }

    public static VotLintTapRunner createPostSyncRunner(boolean doChecks) {
        return new VotLintTapRunner("sync POST", doChecks){

            @Override
            protected URLConnection getResultConnection(Reporter reporter, TapQuery tq) throws IOException {
                return UwsJob.postForm((URL)tq.getEndpointSet().getSyncEndpoint(), (ContentCoding)ContentCoding.NONE, (Map)tq.getStringParams(), (Map)tq.getStreamParams());
            }
        };
    }

    public static VotLintTapRunner createGetSyncRunner(final boolean doChecks) {
        return new VotLintTapRunner("sync GET", doChecks){

            @Override
            protected URLConnection getResultConnection(Reporter reporter, TapQuery tq) throws IOException {
                URL syncEndpoint = tq.getEndpointSet().getSyncEndpoint();
                if (tq.getStreamParams() == null || tq.getStreamParams().isEmpty()) {
                    String ptxt = new String(UwsJob.toPostedBytes((Map)tq.getStringParams()), "utf-8");
                    URL qurl = new URL(syncEndpoint + "?" + ptxt);
                    if (doChecks) {
                        reporter.report(FixedCode.I_QGET, "Query GET URL: " + qurl);
                    }
                    return qurl.openConnection();
                }
                return UwsJob.postForm((URL)syncEndpoint, (ContentCoding)ContentCoding.NONE, (Map)tq.getStringParams(), (Map)tq.getStreamParams());
            }
        };
    }

    public static VotLintTapRunner createAsyncRunner(final long pollMillis, boolean doChecks) {
        return new VotLintTapRunner("async", doChecks){

            @Override
            protected URLConnection getResultConnection(Reporter reporter, TapQuery tq) throws IOException {
                UwsJobInfo info;
                UwsJob uwsJob = UwsJob.createJob((String)tq.getEndpointSet().getAsyncEndpoint().toString(), (Map)tq.getStringParams(), (Map)tq.getStreamParams());
                URL jobUrl = uwsJob.getJobUrl();
                reporter.report(FixedCode.I_QJOB, "Submitted query at " + jobUrl);
                uwsJob.start();
                try {
                    info = uwsJob.waitForFinish(pollMillis);
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("interrupted").initCause(e);
                }
                String phase = info.getPhase();
                if ("COMPLETED".equals(phase)) {
                    uwsJob.setDeleteOnExit(true);
                    return new URL(jobUrl + "/results/result").openConnection();
                }
                if ("ERROR".equals(phase)) {
                    return new URL(jobUrl + "/error").openConnection();
                }
                throw new IOException("Unexpected UWS phase " + phase);
            }
        };
    }
}

