/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.IvoaSchemaResolver;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.ReporterErrorHandler;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.vo.EndpointSet;

public abstract class XsdStage
implements Stage {
    private final String topElName_;
    private final String topElNamespaceUri_;
    private final boolean isMandatory_;
    private final String description_;
    private Result result_;

    protected XsdStage(String topElNamespaceUri, String topElName, boolean isMandatory, String resourceDescription) {
        this.topElName_ = topElName;
        this.topElNamespaceUri_ = topElNamespaceUri;
        this.isMandatory_ = isMandatory;
        this.description_ = "Validate " + resourceDescription + " against XML schema";
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public abstract URL getDocumentUrl(EndpointSet var1);

    @Override
    public void run(Reporter reporter, EndpointSet endpointSet) {
        URL docUrl = this.getDocumentUrl(endpointSet);
        reporter.report(FixedCode.I_VURL, "Validating " + docUrl + " as " + this.topElName_ + " (" + this.topElNamespaceUri_ + ")");
        this.result_ = this.validateDoc(reporter, docUrl);
        if (this.result_ == Result.NOT_FOUND) {
            if (this.isMandatory_) {
                reporter.report(FixedCode.E_GONM, "Mandatory resource " + docUrl + " not present");
            } else {
                reporter.report(FixedCode.W_GONO, "Optional resource " + docUrl + " not present");
            }
        }
    }

    public Result getResult() {
        return this.result_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result validateDoc(Reporter reporter, URL docUrl) {
        Validator val;
        InputStream docStream;
        try {
            docStream = docUrl.openStream();
        }
        catch (FileNotFoundException e) {
            return Result.NOT_FOUND;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_DCER, "Error reading document", e);
            return Result.FAILURE;
        }
        try {
            val = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema().newValidator();
        }
        catch (SAXException e) {
            reporter.report(FixedCode.F_XVAL, "Can't prepare validator", e);
            return Result.FAILURE;
        }
        IvoaSchemaResolver resolver = new IvoaSchemaResolver(reporter);
        val.setResourceResolver(resolver);
        ReporterErrorHandler errHandler = new ReporterErrorHandler(reporter);
        val.setErrorHandler(errHandler);
        TopElementHandler topelHandler = new TopElementHandler();
        try {
            Object msg;
            val.validate(new SAXSource(new InputSource(new BufferedInputStream(docStream))), new SAXResult(topelHandler));
            if (!this.topElName_.equals(topelHandler.topName_)) {
                msg = new StringBuffer().append("Wrong top-level element: ").append("{").append(topelHandler.topUri_).append("}").append(topelHandler.topName_).append(" != ").append("{").append(this.topElNamespaceUri_).append("}").append(this.topElName_).toString();
                reporter.report(FixedCode.E_ELDF, (String)msg);
            }
            if (resolver.getResolvedCount() == 0) {
                msg = new StringBuffer().append("No resources from known namespaces resolved").append("; resolver not used??").append(" (can happen for JRE version<=5)").toString();
                reporter.report(FixedCode.W_ZRES, (String)msg);
            }
            msg = Result.SUCCESS;
            return msg;
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_IOER, "Error reading document to parse");
            Result result = Result.FAILURE;
            return result;
        }
        catch (SAXException e) {
            if (errHandler.getFatalCount() == 0) {
                reporter.report(FixedCode.F_SXER, "Unexpected document parse error", e);
                Result result = Result.SUCCESS;
                return result;
            }
            Result result = Result.FAILURE;
            return result;
        }
        finally {
            if (reporter instanceof OutputReporter) {
                OutputReporter orep = (OutputReporter)reporter;
                orep.summariseUnreportedMessages(orep.getSectionCode());
            }
            reporter.report(FixedCode.S_VALI, errHandler.getSummary());
        }
    }

    private static class TopElementHandler
    extends DefaultHandler {
        private boolean isTop_;
        String topUri_;
        String topName_;

        private TopElementHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (!this.isTop_) {
                this.isTop_ = true;
                this.topUri_ = uri;
                this.topName_ = localName;
            }
        }
    }

    public static enum Result {
        NOT_FOUND,
        FAILURE,
        SUCCESS;

    }
}

